/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.NMSLException;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasParameters;
    private int argumentStack;
    private boolean hasFormals;
    private static final NMSLException \u6f02\u5440\u6f02\u5440 = new NMSLException("\u278a\u4dd9\u4de3\u26ad\u26e3\u4df7\u4df2\u4dee\ua65c\u2711\u4dfb\ua66c\u2748\u4dc3\u4dc1\u26bd\ua669\u4def\u2663\u2741\u45fd\u2761\u4de7\u4df9\u4dcb\ua654\u2680\u273c\u4659\u4dfe\u4dee\u4df1\u4dd0\u44b4\ua688\ua655\u4dc5\u2605\ua677\u4dfc\ua69f\u275b\ua689\u27a2\u4dff\u4dc3\u4dff\u4dcc\u27a3");

    public void visitInnerClassType(String name) {
        this.endArguments();
        this.buf.append('.');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append('[');
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public void visitTypeVariable(String name) {
        this.buf.append('T');
        this.buf.append(name);
        this.buf.append(';');
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append('(');
        }
        this.buf.append(')');
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append(';');
    }

    public void visitBaseType(char descriptor) {
        this.buf.append(descriptor);
    }

    public void visitClassType(String name) {
        this.buf.append('L');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.buf.append('(');
        }
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public SignatureWriter() {
        super(327680);
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append('^');
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append(':');
        return this;
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.buf.append('>');
        }
    }

    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        this.buf.append('*');
    }

    private void endArguments() {
        if (this.argumentStack % 2 != 0) {
            this.buf.append('>');
        }
        this.argumentStack /= 2;
    }

    public void visitFormalTypeParameter(String name) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.buf.append('<');
        }
        this.buf.append(name);
        this.buf.append(':');
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        if (wildcard != '=') {
            this.buf.append(wildcard);
        }
        return this;
    }
}

