/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;
import pers.XiaoShadiao.NMSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInsnNode {
    public static final int LDC_INSN = 9;
    public static final int MULTIANEWARRAY_INSN = 13;
    public static final int FRAME = 14;
    public static final int LINE = 15;
    public static final int LOOKUPSWITCH_INSN = 12;
    public static final int JUMP_INSN = 7;
    int index;
    public static final int INSN = 0;
    AbstractInsnNode prev;
    public static final int VAR_INSN = 2;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public static final int LABEL = 8;
    AbstractInsnNode next;
    public static final int TYPE_INSN = 3;
    public static final int METHOD_INSN = 5;
    protected int opcode;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public static final int FIELD_INSN = 4;
    public static final int INVOKE_DYNAMIC_INSN = 6;
    public static final int INT_INSN = 1;
    public static final int TABLESWITCH_INSN = 11;
    public static final int IINC_INSN = 10;
    private static final NMSLException \u5927\u574f\u86cb = new NMSLException("\ua68a\u4dc6\u4dd6\u4dd6\u2787\ua680\u4dd6\u4dc5\u423f\u4dd8\u4343\u4dd3\u4dcf\u2700\u4dd3\u4dd1\u4dfa\u4de6\u3ed0\u275e\ua67a\u4dcf\u4df6\u26a3\u4dd8\u2631\u3ec3\ua69c\u27b6\u4dd5\u4df0\u26ac\u4dce\ua644\u4dea\u277d\u4dc4\ua651\u4dea\u4de3");

    public AbstractInsnNode getNext() {
        return this.next;
    }

    static LabelNode[] clone(List<LabelNode> labels, Map<LabelNode, LabelNode> map) {
        LabelNode[] clones = new LabelNode[labels.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = map.get(labels.get(i));
        }
        return clones;
    }

    public AbstractInsnNode getPrevious() {
        return this.prev;
    }

    protected final AbstractInsnNode cloneAnnotations(AbstractInsnNode insn) {
        TypeAnnotationNode ann;
        TypeAnnotationNode src;
        int i;
        if (insn.visibleTypeAnnotations != null) {
            this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>();
            for (i = 0; i < insn.visibleTypeAnnotations.size(); ++i) {
                src = insn.visibleTypeAnnotations.get(i);
                ann = new TypeAnnotationNode(src.typeRef, src.typePath, src.desc);
                src.accept(ann);
                this.visibleTypeAnnotations.add(ann);
            }
        }
        if (insn.invisibleTypeAnnotations != null) {
            this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>();
            for (i = 0; i < insn.invisibleTypeAnnotations.size(); ++i) {
                src = insn.invisibleTypeAnnotations.get(i);
                ann = new TypeAnnotationNode(src.typeRef, src.typePath, src.desc);
                src.accept(ann);
                this.invisibleTypeAnnotations.add(ann);
            }
        }
        return this;
    }

    protected AbstractInsnNode(int opcode) {
        this.opcode = opcode;
        this.index = -1;
    }

    public abstract AbstractInsnNode clone(Map<LabelNode, LabelNode> var1);

    public int getOpcode() {
        return this.opcode;
    }

    protected final void acceptAnnotations(MethodVisitor mv) {
        TypeAnnotationNode an;
        int i;
        int n = this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = this.visibleTypeAnnotations.get(i);
            an.accept(mv.visitInsnAnnotation(an.typeRef, an.typePath, an.desc, true));
        }
        n = this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = this.invisibleTypeAnnotations.get(i);
            an.accept(mv.visitInsnAnnotation(an.typeRef, an.typePath, an.desc, false));
        }
    }

    static LabelNode clone(LabelNode label, Map<LabelNode, LabelNode> map) {
        return map.get(label);
    }

    public abstract int getType();

    public abstract void accept(MethodVisitor var1);
}

