/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.analysis.Value;
import pers.XiaoShadiao.NMSLException;

public class BasicValue
implements Value {
    public static final BasicValue FLOAT_VALUE;
    public static final BasicValue INT_VALUE;
    public static final BasicValue REFERENCE_VALUE;
    public static final BasicValue UNINITIALIZED_VALUE;
    private final Type type;
    public static final BasicValue LONG_VALUE;
    public static final BasicValue DOUBLE_VALUE;
    public static final BasicValue RETURNADDRESS_VALUE;
    private static final NMSLException \u6211\u662f\u7f07\u5b81;

    public BasicValue(Type type) {
        this.type = type;
    }

    static {
        \u6211\u662f\u7f07\u5b81 = new NMSLException("\u278a\u4def\u2741\ua685\ua64f\u4dd6\u2738\u4dc3\u4deb\u4dec\u4dd2\u4ddd\u4df3\u4df2\u4dea\u2756\u4dc4\u4dfe\u26b8\u2687\ua677\u270f\u4dd1\u4d8d\u3eab\u2673\u43fc\u4de2\u413d\u2698\u26c4\u272c\u4dc4\ua655\ua674\u272c\u4dc3\u4745");
        UNINITIALIZED_VALUE = new BasicValue(null);
        INT_VALUE = new BasicValue(Type.INT_TYPE);
        FLOAT_VALUE = new BasicValue(Type.FLOAT_TYPE);
        LONG_VALUE = new BasicValue(Type.LONG_TYPE);
        DOUBLE_VALUE = new BasicValue(Type.DOUBLE_TYPE);
        REFERENCE_VALUE = new BasicValue(Type.getObjectType("java/lang/Object"));
        RETURNADDRESS_VALUE = new BasicValue(Type.VOID_TYPE);
    }

    public boolean isReference() {
        return this.type != null && (this.type.getSort() == 10 || this.type.getSort() == 9);
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == RETURNADDRESS_VALUE) {
            return "A";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.type.getDescriptor();
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value instanceof BasicValue) {
            if (this.type == null) {
                return ((BasicValue)value).type == null;
            }
            return this.type.equals(((BasicValue)value).type);
        }
        return false;
    }

    public int getSize() {
        return this.type == Type.LONG_TYPE || this.type == Type.DOUBLE_TYPE ? 2 : 1;
    }
}

