/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import pers.XiaoShadiao.NMSLException;

class Subroutine {
    LabelNode start;
    boolean[] access;
    List<JumpInsnNode> callers;
    private static final NMSLException BANG = new NMSLException("\u2668\u4cec\u4ddf\u2774\u4dc4\u4dc4\u4de0\ua68c\u4ddc\u26e4\u472b\u4dff\ua66c\u262a\ua692\u4de2\u3710\ua692\u4dc6\ua69d\u4de9\u4df1\u4dfd\u4dd7\u27b0\u4dc9\u4def\u3409\u4de9\u43cc\u4ddf\u4dc9\u4ddc\u4de7\u4df3\ua65e\u4dd3");

    public Subroutine copy() {
        Subroutine result = new Subroutine();
        result.start = this.start;
        result.access = new boolean[this.access.length];
        System.arraycopy(this.access, 0, result.access, 0, this.access.length);
        result.callers = new ArrayList<JumpInsnNode>(this.callers);
        return result;
    }

    Subroutine(LabelNode start, int maxLocals, JumpInsnNode caller) {
        this.start = start;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller);
    }

    private Subroutine() {
    }

    public boolean merge(Subroutine subroutine) throws AnalyzerException {
        int i;
        boolean changes = false;
        for (i = 0; i < this.access.length; ++i) {
            if (!subroutine.access[i] || this.access[i]) continue;
            this.access[i] = true;
            changes = true;
        }
        if (subroutine.start == this.start) {
            for (i = 0; i < subroutine.callers.size(); ++i) {
                JumpInsnNode caller = subroutine.callers.get(i);
                if (this.callers.contains(caller)) continue;
                this.callers.add(caller);
                changes = true;
            }
        }
        return changes;
    }
}

