/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.util.CheckMethodAdapter;
import pers.XiaoShadiao.NMSLException;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean named;
    private boolean end;
    private static final NMSLException \u4f59\u4e0b\u7684 = new NMSLException("\u4dd2\ua66e\ua69f\u4dda\ua694\ua64c\u4df4\u4c75\u4dfb\u2790\u4dce\ua647\u4dfd\u2698\u4de6\u2765\u4628\u276b\u2692\u4de8\u4de8\u48ff\u4def\ua683\u26f3\u4df5\ua69c\ua68d\u278f\ua694\u34c6\u4dfb\u34e8\u4ddb\u4dfa\u4dc8\u26fc\u4b43\u4df3\u2784\u4dc7\u4dcf\u2733\u4dc7\u4dee\u3b2b\u4dc5\u4254\u271d");

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.checkEnd();
        this.checkName(name);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitAnnotation(name, desc));
    }

    public CheckAnnotationAdapter(AnnotationVisitor av) {
        this(av, true);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    CheckAnnotationAdapter(AnnotationVisitor av, boolean named) {
        super(327680, av);
        this.named = named;
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private void checkName(String name) {
        if (this.named && name == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }

    public void visit(String name, Object value) {
        int sort;
        this.checkEnd();
        this.checkName(name);
        if (!(value instanceof Byte || value instanceof Boolean || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Type || value instanceof byte[] || value instanceof boolean[] || value instanceof char[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (value instanceof Type && (sort = ((Type)value).getSort()) == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (this.av != null) {
            this.av.visit(name, value);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.checkEnd();
        this.checkName(name);
        CheckMethodAdapter.checkDesc(desc, false);
        if (value == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        if (this.av != null) {
            this.av.visitEnum(name, desc, value);
        }
    }

    public AnnotationVisitor visitArray(String name) {
        this.checkEnd();
        this.checkName(name);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitArray(name), false);
    }
}

