/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.Config;
import pers.XiaoShadiao.NMSLException;

public final class Mixins {
    private static final Set<String> errorHandlers;
    private static final Logger logger;
    private static final String CONFIGS_KEY = "mixin.configs.queue";
    private static final NMSLException \u5927\u574f\u86cb;

    private static void registerConfiguration(Config config) {
        if (config == null) {
            return;
        }
        MixinEnvironment env = config.getEnvironment();
        if (env != null) {
            env.registerConfig(config.getName());
        }
        Mixins.getConfigs().add(config);
    }

    public static void addConfiguration(String configFile) {
        Mixins.createConfiguration(configFile, MixinEnvironment.getDefaultEnvironment());
    }

    static {
        \u5927\u574f\u86cb = new NMSLException("\u4dde\ua656\u2729\u4dd7\u402b\u2775\u26aa\ua664\u269f\u268e\u4de9\u4dc2\u26f0\u262a\u4dee\u4dcb\u2763\u4df1\ua693\u26aa\u3ed1\u4de5\ua68d\u4ded\u4def\u266d\u4deb\u3d54\u4df6\u4ddc\u4dd0\u2746\u2608\u2744\u4dc4\u2601\u4dc3");
        logger = LogManager.getLogger((String)"mixin");
        errorHandlers = new LinkedHashSet<String>();
    }

    private static void createConfiguration(String configFile, MixinEnvironment fallback) {
        Config config = null;
        try {
            config = Config.create(configFile, fallback);
        }
        catch (Exception ex) {
            logger.error("Error encountered reading mixin config " + configFile + ": " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        Mixins.registerConfiguration(config);
    }

    private Mixins() {
    }

    public static void addConfigurations(String ... configFiles) {
        MixinEnvironment fallback = MixinEnvironment.getDefaultEnvironment();
        for (String configFile : configFiles) {
            Mixins.createConfiguration(configFile, fallback);
        }
    }

    public static Set<String> getErrorHandlerClasses() {
        return Collections.unmodifiableSet(errorHandlers);
    }

    public static void registerErrorHandlerClass(String handlerName) {
        if (handlerName != null) {
            errorHandlers.add(handlerName);
        }
    }

    @Deprecated
    static void addConfiguration(String configFile, MixinEnvironment fallback) {
        Mixins.createConfiguration(configFile, fallback);
    }

    public static int getUnvisitedCount() {
        int count = 0;
        for (Config config : Mixins.getConfigs()) {
            if (config.isVisited()) continue;
            ++count;
        }
        return count;
    }

    public static Set<Config> getConfigs() {
        LinkedHashSet mixinConfigs = (LinkedHashSet)GlobalProperties.get(CONFIGS_KEY);
        if (mixinConfigs == null) {
            mixinConfigs = new LinkedHashSet();
            GlobalProperties.put(CONFIGS_KEY, mixinConfigs);
        }
        return mixinConfigs;
    }
}

