/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type returnType;
    private final boolean isInstanceMethod;
    private final Type[] argTypes;
    private static final NMSLException \u6211\u662f\u7f07\u5b9d = new NMSLException("\u485d\u26b8\u4dc1\u43d3\u4dff\u3e3f\u4ddb\u4dd0\u4dc2\u4dc9\u4dcc\u4dc3\u4dda\u4dc1\u2699\u4de5\u4def\ua690\u4757\ua64f\ua65c\u4dc8\u4dc4\ua67a\u4dd1\u4dc9\u4dc3\u4df4\ua664\u4dcf\u4dd1\u4dc4\u3950\u4dce\u4dec\u4dfe\u4dde\u2694\u4df3\u4de6\u4dcd\u4de8\u2653\ua695\u4dca\u4de3\u27b9\u4dca");

    @Override
    public MethodNode generate() {
        int size = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 1 : 0);
        MethodNode method = this.createMethod(size, size);
        if (this.isInstanceMethod) {
            method.instructions.add(new VarInsnNode(25, 0));
        }
        Bytecode.loadArgs(this.argTypes, method.instructions, this.isInstanceMethod ? 1 : 0);
        boolean isPrivate = Bytecode.hasFlag(this.targetMethod, 2);
        int opcode = this.isInstanceMethod ? (isPrivate ? 183 : 182) : 184;
        method.instructions.add(new MethodInsnNode(opcode, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, false));
        method.instructions.add(new InsnNode(this.returnType.getOpcode(172)));
        return method;
    }

    public AccessorGeneratorMethodProxy(AccessorInfo info) {
        super(info);
        this.targetMethod = info.getTargetMethod();
        this.argTypes = info.getArgTypes();
        this.returnType = info.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 8);
    }
}

