/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.InjectorTarget;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public abstract class Injector {
    protected static final Logger logger;
    protected final Type returnType;
    protected InjectionInfo info;
    protected final Type[] methodArgs;
    protected final MethodNode methodNode;
    protected final boolean isStatic;
    protected final ClassNode classNode;
    private static final NMSLException \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934;

    public final List<InjectionNodes.InjectionNode> find(InjectorTarget injectorTarget, List<InjectionPoint> injectionPoints) {
        this.sanityCheck(injectorTarget.getTarget(), injectionPoints);
        ArrayList<InjectionNodes.InjectionNode> myNodes = new ArrayList<InjectionNodes.InjectionNode>();
        for (TargetNode node : this.findTargetNodes(injectorTarget, injectionPoints)) {
            this.addTargetNode(injectorTarget.getTarget(), myNodes, node.insn, node.nominators);
        }
        return myNodes;
    }

    private Collection<TargetNode> findTargetNodes(InjectorTarget injectorTarget, List<InjectionPoint> injectionPoints) {
        IMixinContext mixin = this.info.getContext();
        MethodNode method = injectorTarget.getMethod();
        TreeMap<Integer, TargetNode> targetNodes = new TreeMap<Integer, TargetNode>();
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>(32);
        for (InjectionPoint injectionPoint : injectionPoints) {
            nodes.clear();
            if (injectorTarget.isMerged() && !mixin.getClassName().equals(injectorTarget.getMergedBy()) && !injectionPoint.checkPriority(injectorTarget.getMergedPriority(), mixin.getPriority())) {
                throw new InvalidInjectionException(this.info, String.format("%s on %s with priority %d cannot inject into %s merged by %s with priority %d", injectionPoint, this, mixin.getPriority(), injectorTarget, injectorTarget.getMergedBy(), injectorTarget.getMergedPriority()));
            }
            if (!this.findTargetNodes(method, injectionPoint, injectorTarget.getSlice(injectionPoint), nodes)) continue;
            for (AbstractInsnNode insn : nodes) {
                Integer key = method.instructions.indexOf(insn);
                TargetNode targetNode = (TargetNode)targetNodes.get(key);
                if (targetNode == null) {
                    targetNode = new TargetNode(insn);
                    targetNodes.put(key, targetNode);
                }
                targetNode.nominators.add(injectionPoint);
            }
        }
        return targetNodes.values();
    }

    private Injector(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.methodNode = methodNode;
        this.methodArgs = Type.getArgumentTypes(this.methodNode.desc);
        this.returnType = Type.getReturnType(this.methodNode.desc);
        this.isStatic = Bytecode.methodIsStatic(this.methodNode);
    }

    private static boolean canCoerce(ClassInfo from, ClassInfo to) {
        return from != null && to != null && (to == from || to.hasSuperClass(from));
    }

    protected void postInject(Target target, InjectionNodes.InjectionNode node) {
    }

    static {
        \u6211\u8fd8\u6ca1\u5f00\u59cb\u5410\u820c\u5934 = new NMSLException("\ua685\u26ac\u2723\ua643\u4deb\u278b\ua681\ua646\u4df2\u4dcd\u4dc9\u496e\u2661\u4dd7\u2613\u4deb\u4de9\u4dd7\u276d\ua65f\u274c\u4dce\u4dfc\u4dd7\u4dd2\u4de4\u4dff\u4ddf\u4de3\u4dc4\u4ddc\u4ddf\u4dd5\u4dc1\u4de4\ua65d\u4dfe\u4dd8\u264e\u4dc9\ua668\u4011\u4df3");
        logger = LogManager.getLogger((String)"mixin");
    }

    public static boolean canCoerce(char from, char to) {
        return to == 'I' && "IBSCZ".indexOf(from) > -1;
    }

    public final void inject(Target target, List<InjectionNodes.InjectionNode> nodes) {
        for (InjectionNodes.InjectionNode node : nodes) {
            if (node.isRemoved()) {
                if (!this.info.getContext().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) continue;
                logger.warn("Target node for {} was removed by a previous injector in {}", new Object[]{this.info, target});
                continue;
            }
            this.inject(target, node);
        }
        for (InjectionNodes.InjectionNode node : nodes) {
            this.postInject(target, node);
        }
    }

    public String toString() {
        return String.format("%s::%s", this.classNode.name, this.methodNode.name);
    }

    public Injector(InjectionInfo info) {
        this(info.getClassNode(), info.getMethod());
        this.info = info;
    }

    protected boolean findTargetNodes(MethodNode into, InjectionPoint injectionPoint, InsnList insns, Collection<AbstractInsnNode> nodes) {
        return injectionPoint.find(into.desc, insns, nodes);
    }

    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> myNodes, AbstractInsnNode node, Set<InjectionPoint> nominators) {
        myNodes.add(target.addInjectionNode(node));
    }

    protected AbstractInsnNode invokeHandler(InsnList insns, MethodNode handler) {
        boolean isPrivate;
        boolean bl = isPrivate = (handler.access & 2) != 0;
        int invokeOpcode = this.isStatic ? 184 : (isPrivate ? 183 : 182);
        MethodInsnNode insn = new MethodInsnNode(invokeOpcode, this.classNode.name, handler.name, handler.desc, false);
        insns.add(insn);
        this.info.addCallbackInvocation(handler);
        return insn;
    }

    public static boolean canCoerce(String from, String to) {
        if (from.length() > 1 || to.length() > 1) {
            return false;
        }
        return Injector.canCoerce(from.charAt(0), to.charAt(0));
    }

    protected abstract void inject(Target var1, InjectionNodes.InjectionNode var2);

    protected void throwException(InsnList insns, String exceptionType, String message) {
        insns.add(new TypeInsnNode(187, exceptionType));
        insns.add(new InsnNode(89));
        insns.add(new LdcInsnNode(message));
        insns.add(new MethodInsnNode(183, exceptionType, "<init>", "(Ljava/lang/String;)V", false));
        insns.add(new InsnNode(191));
    }

    public static boolean canCoerce(Type from, Type to) {
        if (from.getSort() == 10 && to.getSort() == 10) {
            return Injector.canCoerce(ClassInfo.forType(from), ClassInfo.forType(to));
        }
        return Injector.canCoerce(from.getDescriptor(), to.getDescriptor());
    }

    protected AbstractInsnNode invokeHandler(InsnList insns) {
        return this.invokeHandler(insns, this.methodNode);
    }

    protected void sanityCheck(Target target, List<InjectionPoint> injectionPoints) {
        if (target.classNode != this.classNode) {
            throw new InvalidInjectionException(this.info, "Target class does not match injector class in " + this);
        }
    }

    public static final class TargetNode {
        final Set<InjectionPoint> nominators = new HashSet<InjectionPoint>();
        final AbstractInsnNode insn;
        private static final NMSLException \u6211\u4eec\u52a0\u5feb\u811a\u6b65\u5427 = new NMSLException("\ua64c\u275c\u4de0\u4dc5\u4dcf\ua686\u3d3c\u2784\u4dda\u4dec\ua680\u4dd0\ua680\u265a\u2777\u4865\u4dde\u2665\u3d0e\u4dc2\u4deb\u27b2\u4dc9\u272a\u48eb\ua655\u27af\u4af1\u4dfd\u45ae\u4dc8\ua692\ua674\u4df9\u4df1\u3b20\u27ad\u4dfc\u4df3\u407b\u4dce\u4d20\u45f3\u42cb");

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != TargetNode.class) {
                return false;
            }
            return ((TargetNode)obj).insn == this.insn;
        }

        public int hashCode() {
            return this.insn.hashCode();
        }

        public Set<InjectionPoint> getNominators() {
            return Collections.unmodifiableSet(this.nominators);
        }

        public AbstractInsnNode getNode() {
            return this.insn;
        }

        TargetNode(AbstractInsnNode insn) {
            this.insn = insn;
        }
    }
}

