/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.code.ReadOnlyInsnList;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorTarget {
    private final int mergedPriority;
    private final ISliceContext context;
    private final Map<String, ReadOnlyInsnList> cache = new HashMap<String, ReadOnlyInsnList>();
    private final Target target;
    private final String mergedBy;
    private static final NMSLException \u6211\u4eec\u4e5f\u6709\u5934\u53d1\u957f\u957f\u7684\u65f6\u5019 = new NMSLException("\u39da\u4df3\u4de2\u2788\u4df4\ua694\u4dcb\u4dc0\u3b4f\u4dd2\u4de2\u272c\u436c\u27ba\u265d\u4de8\u2722\u4dc5\u4dd3\u4de5\u4de3\u4dd4\u4dd3\u4df9\u264f\u4df6\u4dfb\u4dde\u2765\u3bb7\u276a\u4df9\u4df5\u26e9\u2664");

    public InsnList getSlice(InjectionPoint injectionPoint) {
        return this.getSlice(injectionPoint.getSlice());
    }

    public Target getTarget() {
        return this.target;
    }

    public InjectorTarget(ISliceContext context, Target target) {
        this.context = context;
        this.target = target;
        AnnotationNode merged = Annotations.getVisible(target.method, MixinMerged.class);
        this.mergedBy = (String)Annotations.getValue(merged, "mixin");
        this.mergedPriority = Annotations.getValue(merged, "priority", 1000);
    }

    public String toString() {
        return this.target.toString();
    }

    public String getMergedBy() {
        return this.mergedBy;
    }

    public InsnList getSlice(String id) {
        ReadOnlyInsnList slice = this.cache.get(id);
        if (slice == null) {
            MethodSlice sliceInfo = this.context.getSlice(id);
            slice = sliceInfo != null ? sliceInfo.getSlice(this.target.method) : new ReadOnlyInsnList(this.target.method.instructions);
            this.cache.put(id, slice);
        }
        return slice;
    }

    public boolean isMerged() {
        return this.mergedBy != null;
    }

    public void dispose() {
        for (ReadOnlyInsnList insns : this.cache.values()) {
            insns.dispose();
        }
        this.cache.clear();
    }

    public int getMergedPriority() {
        return this.mergedPriority;
    }

    public MethodNode getMethod() {
        return this.target.method;
    }
}

