/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final int opcode;
    private boolean opcodeAfter;
    private final Type returnType;
    private final int ordinal;
    private final LocalVariableDiscriminator discriminator;
    private static final NMSLException \u6211\u4eec\u662f\u7f07\u91cc\u897f\u5e87\u4fc4\u4e1d = new NMSLException("\u4de6\u4df6\u2701\u4a4e\u4de8\u4db9\ua650\u4de4\ua68f\u26c7\u4dcf\u3fa5\u270c\u27a1\u45ce\u27a8\u273b\u43a0\u4df9\u26de\ua671\u26ee\u4dc9\u4d56\u26d3\u3eff\u4de1\u4df9\u4dd3\u4dc6\u4dce\u4dd8\ua673\u3c61\u4ddd\u4de2\u46ba");

    protected BeforeLoadLocal(InjectionPointData data, int opcode, boolean opcodeAfter) {
        super(data.getContext());
        this.returnType = data.getMethodReturnType();
        this.discriminator = data.getLocalVariableDiscriminator();
        this.opcode = data.getOpcode(this.returnType.getOpcode(opcode));
        this.ordinal = data.getOrdinal();
        this.opcodeAfter = opcodeAfter;
    }

    protected BeforeLoadLocal(InjectionPointData data) {
        this(data, 21, false);
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> nodes) {
        SearchState state = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> iter = target.method.instructions.iterator();
        while (iter.hasNext()) {
            int local;
            AbstractInsnNode insn = iter.next();
            if (state.isPendingCheck()) {
                local = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, insn);
                state.check(nodes, insn, local);
                continue;
            }
            if (!(insn instanceof VarInsnNode) || insn.getOpcode() != this.opcode || this.ordinal != -1 && state.success()) continue;
            state.register((VarInsnNode)insn);
            if (this.opcodeAfter) {
                state.setPendingCheck();
                continue;
            }
            local = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, insn);
            state.check(nodes, insn, local);
        }
        return state.success();
    }

    static class SearchState {
        private final boolean print;
        private boolean pendingCheck = false;
        private boolean found = false;
        private final int targetOrdinal;
        private int ordinal = 0;
        private VarInsnNode varNode;
        private static final NMSLException \u4f60\u62cd\u4e94 = new NMSLException("\u27a1\u27a1\u4dc3\u4df6\u2725\u4dc3\u4dd5\u3ef6\u351d\u2649\u4dd5\u4dc9\u3a95\u26c3\u4dd9\u4dc8\u4ded\ua681\u26f4\ua681\u4df0\u272f\u47b8\u4de1\u4dec\u2682\u4dd7\u4dec\u4dd4\ua667\u2765\u4df6\ua66e\u4df3\u2706\u4df9\u35e1\u4de7\u41d6\u4de7\ua65b\u488c\u2635\u4de9\u4de5\u2716\ua677");

        void check(Collection<AbstractInsnNode> nodes, AbstractInsnNode insn, int local) {
            this.pendingCheck = false;
            if (!(local == this.varNode.var || local <= -2 && this.print)) {
                return;
            }
            if (this.targetOrdinal == -1 || this.targetOrdinal == this.ordinal) {
                nodes.add(insn);
                this.found = true;
            }
            ++this.ordinal;
            this.varNode = null;
        }

        SearchState(int targetOrdinal, boolean print) {
            this.targetOrdinal = targetOrdinal;
            this.print = print;
        }

        void setPendingCheck() {
            this.pendingCheck = true;
        }

        boolean success() {
            return this.found;
        }

        boolean isPendingCheck() {
            return this.pendingCheck;
        }

        void register(VarInsnNode node) {
            this.varNode = node;
        }
    }
}

