/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.Locals;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;
import pers.XiaoShadiao.NMSLException;

public class LocalVariableDiscriminator {
    private final int ordinal;
    private final int index;
    private final boolean argsOnly;
    private final boolean print;
    private final Set<String> names;
    private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b9d = new NMSLException("\u4dc3\u2616\u4df3\ua64d\u4ddf\u2600\u27b0\ua667\ua691\u4dd4\u4dda\u4dcb\u4dc9\u4dd9\u26f8\u4dc0\u4de4\u26c5\ua695\u3c88\u2613\u4dcc\u4dec\u2661\u4dd0\ua64a\u26e8\u2707\ua696\u4703\u4dfa\u27a6\u2715\ua648\u4dc2\u4de4");

    public boolean printLVT() {
        return this.print;
    }

    private int findExplicitLocal(Context context) {
        for (int index = context.baseArgIndex; index < context.locals.length; ++index) {
            Context.Local local = context.locals[index];
            if (local == null || !local.type.equals(context.returnType) || !(this.ordinal > -1 ? this.ordinal == local.ord : (this.index >= context.baseArgIndex ? this.index == index : this.names.contains(local.name)))) continue;
            return index;
        }
        return -1;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public int findLocal(Context context) {
        if (this.isImplicit(context)) {
            return this.findImplicitLocal(context);
        }
        return this.findExplicitLocal(context);
    }

    private int findImplicitLocal(Context context) {
        int found = 0;
        int count = 0;
        for (int index = context.baseArgIndex; index < context.locals.length; ++index) {
            Context.Local local = context.locals[index];
            if (local == null || !local.type.equals(context.returnType)) continue;
            ++count;
            found = index;
        }
        if (count == 1) {
            return found;
        }
        throw new InvalidImplicitDiscriminatorException("Found " + count + " candidate variables but exactly 1 is required.");
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isArgsOnly() {
        return this.argsOnly;
    }

    public int findLocal(Type returnType, boolean argsOnly, Target target, AbstractInsnNode node) {
        try {
            return this.findLocal(new Context(returnType, argsOnly, target, node));
        }
        catch (InvalidImplicitDiscriminatorException ex) {
            return -2;
        }
    }

    public boolean hasNames() {
        return !this.names.isEmpty();
    }

    public LocalVariableDiscriminator(boolean argsOnly, int ordinal, int index, Set<String> names, boolean print) {
        this.argsOnly = argsOnly;
        this.ordinal = ordinal;
        this.index = index;
        this.names = Collections.unmodifiableSet(names);
        this.print = print;
    }

    public static LocalVariableDiscriminator parse(AnnotationNode annotation) {
        boolean argsOnly = Annotations.getValue(annotation, "argsOnly", Boolean.FALSE);
        int ordinal = Annotations.getValue(annotation, "ordinal", -1);
        int index = Annotations.getValue(annotation, "index", -1);
        boolean print = Annotations.getValue(annotation, "print", Boolean.FALSE);
        HashSet<String> names = new HashSet<String>();
        List namesList = Annotations.getValue(annotation, "name", (List)null);
        if (namesList != null) {
            names.addAll(namesList);
        }
        return new LocalVariableDiscriminator(argsOnly, ordinal, index, names, print);
    }

    protected boolean isImplicit(Context context) {
        return this.ordinal < 0 && this.index < context.baseArgIndex && this.names.isEmpty();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static class Context
    implements PrettyPrinter.IPrettyPrintable {
        final Type returnType;
        private final boolean isStatic;
        final Target target;
        final AbstractInsnNode node;
        final Local[] locals;
        final int baseArgIndex;
        private static final NMSLException \u6211\u62cd\u516b = new NMSLException("\u4263\u464f\u2795\ua64e\u27b5\u4dfb\u275e\u26bd\ua686\ua681\u4dcf\u26f3\u4dc7\u3591\u4dcb\u3630\u2761\ua67b\u4dfe\ua67d\u4dc6\u40f3\u4dcc\u4dd8\u4dff\u2799\ua64f\u2737\u4dca\u26ab\u4de7\u2784\u3d0a\u4dc1\u2637\ua684\u4dea\u3fa7\u4de2");

        private void initOrdinals() {
            HashMap<Type, Integer> ordinalMap = new HashMap<Type, Integer>();
            for (int l = 0; l < this.locals.length; ++l) {
                Integer ordinal = 0;
                if (this.locals[l] == null) continue;
                ordinal = (Integer)ordinalMap.get(this.locals[l].type);
                ordinal = ordinal == null ? 0 : ordinal + 1;
                ordinalMap.put(this.locals[l].type, ordinal);
                this.locals[l].ord = ordinal;
            }
        }

        @Override
        public void print(PrettyPrinter printer) {
            printer.add("%5s  %7s  %30s  %-50s  %s", "INDEX", "ORDINAL", "TYPE", "NAME", "CANDIDATE");
            for (int l = this.baseArgIndex; l < this.locals.length; ++l) {
                Local local = this.locals[l];
                if (local != null) {
                    Type localType = local.type;
                    String localName = local.name;
                    int ordinal = local.ord;
                    String candidate = this.returnType.equals(localType) ? "YES" : "-";
                    printer.add("[%3d]    [%3d]  %30s  %-50s  %s", l, ordinal, SignaturePrinter.getTypeName(localType, false), localName, candidate);
                    continue;
                }
                if (l <= 0) continue;
                Local prevLocal = this.locals[l - 1];
                boolean isTop = prevLocal != null && prevLocal.type != null && prevLocal.type.getSize() > 1;
                printer.add("[%3d]           %30s", l, isTop ? "<top>" : "-");
            }
        }

        public Context(Type returnType, boolean argsOnly, Target target, AbstractInsnNode node) {
            this.isStatic = Bytecode.methodIsStatic(target.method);
            this.returnType = returnType;
            this.target = target;
            this.node = node;
            this.baseArgIndex = this.isStatic ? 0 : 1;
            this.locals = this.initLocals(target, argsOnly, node);
            this.initOrdinals();
        }

        private Local[] initLocals(Target target, boolean argsOnly, AbstractInsnNode node) {
            LocalVariableNode[] locals;
            if (!argsOnly && (locals = Locals.getLocalsAt(target.classNode, target.method, node)) != null) {
                Local[] lvt = new Local[locals.length];
                for (int l = 0; l < locals.length; ++l) {
                    if (locals[l] == null) continue;
                    lvt[l] = new Local(locals[l].name, Type.getType(locals[l].desc));
                }
                return lvt;
            }
            Local[] lvt = new Local[this.baseArgIndex + target.arguments.length];
            if (!this.isStatic) {
                lvt[0] = new Local("this", Type.getType(target.classNode.name));
            }
            for (int local = this.baseArgIndex; local < lvt.length; ++local) {
                Type arg = target.arguments[local - this.baseArgIndex];
                lvt[local] = new Local("arg" + local, arg);
            }
            return lvt;
        }

        public class Local {
            Type type;
            int ord = 0;
            String name;
            private static final NMSLException \u6211\u4eec\u52a0\u5feb\u811a\u6b65\u5427 = new NMSLException("\u4dca\u4c70\u4dc9\u4dea\u4dc4\u4dff\u4df0\u4de5\u4de7\u4de0\ua691\u2611\u4c66\ua661\u27ae\u4dd2\u4dd7\u4dd6\u274b\u27b2\u26f3\u4ddc\u2763\u4dc7\u26f1\u269d\u48fc\u4dcd\u4de8\u4dea\u4dec\u4df4\u26c9\u4dc0\u4dd9\u4dc3");

            public Local(String name, Type type) {
                this.name = name;
                this.type = type;
            }

            public String toString() {
                return String.format("Local[ordinal=%d, name=%s, type=%s]", this.ord, this.name, this.type);
            }
        }
    }
}

