/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;
import pers.XiaoShadiao.NMSLException;

public class ModifyVariableInjector
extends Injector {
    private final LocalVariableDiscriminator discriminator;
    private static final NMSLException \u522e\u8d77\u5927\u98ce\u7684\u65f6\u5019 = new NMSLException("\u3b27\ua657\u4dc9\u4ddb\u4de9\u4dd3\ua661\ua668\u4ddc\u276a\ua691\u4df2\u4dfc\u266d\u4df1\u4df5\ua67a\u273c\ua66f\u4ddb\u4dc4\u3c52\u26d6\u26a8\u4dca\ua684\ua686\ua655\u3559\u2787");

    public ModifyVariableInjector(InjectionInfo info, LocalVariableDiscriminator discriminator) {
        super(info);
        this.discriminator = discriminator;
    }

    private void printLocals(Context context) {
        SignaturePrinter handlerSig = new SignaturePrinter(this.methodNode.name, this.returnType, this.methodArgs, new String[]{"var"});
        handlerSig.setModifiers(this.methodNode);
        new PrettyPrinter().kvWidth(20).kv("Target Class", this.classNode.name.replace('/', '.')).kv("Target Method", context.target.method.name).kv("Callback Name", this.methodNode.name).kv("Capture Type", SignaturePrinter.getTypeName(this.returnType, false)).kv("Instruction", "%s %s", context.node.getClass().getSimpleName(), Bytecode.getOpcodeName(context.node.getOpcode())).hr().kv("Match mode", this.discriminator.isImplicit(context) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)").kv("Match ordinal", this.discriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(this.discriminator.getOrdinal())).kv("Match index", this.discriminator.getIndex() < context.baseArgIndex ? "any" : Integer.valueOf(this.discriminator.getIndex())).kv("Match name(s)", this.discriminator.hasNames() ? this.discriminator.getNames() : "any").kv("Args only", this.discriminator.isArgsOnly()).hr().add(context).print(System.err);
    }

    @Override
    protected boolean findTargetNodes(MethodNode into, InjectionPoint injectionPoint, InsnList insns, Collection<AbstractInsnNode> nodes) {
        if (injectionPoint instanceof ContextualInjectionPoint) {
            Target target = this.info.getContext().getTargetMethod(into);
            return ((ContextualInjectionPoint)injectionPoint).find(target, nodes);
        }
        return injectionPoint.find(into.desc, insns, nodes);
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        String handlerDesc;
        if (node.isReplaced()) {
            throw new InvalidInjectionException(this.info, "Variable modifier target for " + this + " was removed by another injector");
        }
        Context context = new Context(this.returnType, this.discriminator.isArgsOnly(), target, node.getCurrentTarget());
        if (this.discriminator.printLVT()) {
            this.printLocals(context);
        }
        if (!(handlerDesc = Bytecode.getDescriptor(new Type[]{this.returnType}, this.returnType)).equals(this.methodNode.desc)) {
            throw new InvalidInjectionException(this.info, "Variable modifier " + this + " has an invalid signature, expected " + handlerDesc + " but found " + this.methodNode.desc);
        }
        try {
            int local = this.discriminator.findLocal(context);
            if (local > -1) {
                this.inject(context, local);
            }
        }
        catch (InvalidImplicitDiscriminatorException ex) {
            if (this.discriminator.printLVT()) {
                this.info.addCallbackInvocation(this.methodNode);
                return;
            }
            throw new InvalidInjectionException(this.info, "Implicit variable modifier injection failed in " + this, (Throwable)ex);
        }
        target.insns.insertBefore(context.node, context.insns);
        target.addToStack(this.isStatic ? 1 : 2);
    }

    private void inject(Context context, int local) {
        if (!this.isStatic) {
            context.insns.add(new VarInsnNode(25, 0));
        }
        context.insns.add(new VarInsnNode(this.returnType.getOpcode(21), local));
        this.invokeHandler(context.insns);
        context.insns.add(new VarInsnNode(this.returnType.getOpcode(54), local));
    }

    @Override
    protected void sanityCheck(Target target, List<InjectionPoint> injectionPoints) {
        super.sanityCheck(target, injectionPoints);
        if (target.isStatic != this.isStatic) {
            throw new InvalidInjectionException(this.info, "'static' of variable modifier method does not match target in " + this);
        }
        int ordinal = this.discriminator.getOrdinal();
        if (ordinal < -1) {
            throw new InvalidInjectionException(this.info, "Invalid ordinal " + ordinal + " specified in " + this);
        }
        if (this.discriminator.getIndex() == 0 && !this.isStatic) {
            throw new InvalidInjectionException(this.info, "Invalid index 0 specified in non-static variable modifier " + this);
        }
    }

    static abstract class ContextualInjectionPoint
    extends InjectionPoint {
        protected final IMixinContext context;
        private static final NMSLException \u963f\u96c5\u5979 = new NMSLException("\u27a2\u4dd6\u2710\u4df4\u4dd6\ua68d\ua681\u26dd\u4dcf\u3dca\u49da\u4dcd\u4df7\u4dce\u4b9b\u4dd1\u2625\u4de0\u4dd0\u266c\u270c\u4dd2\u4dfd\u4dec\u4716\ua687\u4dd4\ua64d\u4df2\u2609\u4dd2\u4dc4\u4de3\u46a7\u4dc2\ua650\u273c\u4de7\u265d\u4df0\u276c\u4deb\u4dea\u4de8\u3965\u2765");

        @Override
        public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
            throw new InvalidInjectionException(this.context, this.getAtCode() + " injection point must be used in conjunction with @ModifyVariable");
        }

        ContextualInjectionPoint(IMixinContext context) {
            this.context = context;
        }

        abstract boolean find(Target var1, Collection<AbstractInsnNode> var2);
    }

    static class Context
    extends LocalVariableDiscriminator.Context {
        final InsnList insns = new InsnList();
        private static final NMSLException \u5c31\u5f88\u5c11\u5566 = new NMSLException("\u4df1\u4dd9\u4de5\u4dc1\u4dd7\u3b7c\u276c\u4dcb\u4df1\ua690\u2682\u2748\u4c92\u49e7\u4dec\u3938\u4dd2\u447d\u39aa\u2725\u273c\u26ba\u4deb\u474b\u2688\u4dfe\u277d\u4dce\u4dd8\u4dea\u4dd6\u4dc6\u4bdb\u4dff\u4dc4\u4de5\u26bd\u4de1\u3d9e\u4dcc\ua65f\u4de4\u4dde\u26e4\u2717\u3c84\u2737\u4df6\ua671");

        public Context(Type returnType, boolean argsOnly, Target target, AbstractInsnNode node) {
            super(returnType, argsOnly, target, node);
        }
    }
}

