/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="RETURN")
public class BeforeReturn
extends InjectionPoint {
    private final int ordinal;
    private static final NMSLException \u8fd9\u56de\u4e5f\u8981\u901f\u6218\u901f\u51b3\u5417 = new NMSLException("\u4de2\u4dfe\u4dd3\u47b1\u2725\u4deb\u2749\u270a\u276b\u4ddf\u27a8\u4dee\u2768\u27ad\u266e\u4dde\u2764\u36f2\u4df2\u4dff\u4de3\u4de3\u4df4\u269d\u26c5\ua654\u4dd4\u4def\u27b7\u4dfa\u262f\u2617\u4dc5\u4dee\u2791\u4de3\u3fef\ua65c\u4dc5\u4dee\u26f7\u271d\u4dcf\ua66c");

    @Override
    public boolean checkPriority(int targetPriority, int ownerPriority) {
        return true;
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int returnOpcode = Type.getReturnType(desc).getOpcode(172);
        int ordinal = 0;
        ListIterator<AbstractInsnNode> iter = insns.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = iter.next();
            if (!(insn instanceof InsnNode) || insn.getOpcode() != returnOpcode) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }

    public BeforeReturn(InjectionPointData data) {
        super(data);
        this.ordinal = data.getOrdinal();
    }
}

