/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import pers.XiaoShadiao.NMSLException;

@InjectionPoint.AtCode(value="JUMP")
public class JumpInsnPoint
extends InjectionPoint {
    private final int opCode;
    private final int ordinal;
    private static final NMSLException \u7f07\u5b9d\u4e0d\u6015 = new NMSLException("\u4ddd\ua666\u4329\u3783\u4ddf\u262a\u26ec\u4dc2\u276b\u4dfd\u4de8\u26e8\u49c7\u2663\u3860\u4a4b\u4dcb\u26f5\u2769\u40ec\u4df0\u4df5\u261c\ua68e\u2693\u4dda\ua672\u279a\u4dd1\u4df5\u390e\u4df4\u4df0\u4dce\ua679\u4df7\u4dca\u4df2\u4dd0\u4ded\ua68f\ua699\u4dce\u4dc2");

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int ordinal = 0;
        ListIterator<AbstractInsnNode> iter = insns.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = iter.next();
            if (!(insn instanceof JumpInsnNode) || this.opCode != -1 && insn.getOpcode() != this.opCode) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }

    public JumpInsnPoint(InjectionPointData data) {
        this.opCode = data.getOpcode(-1, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 198, 199, -1);
        this.ordinal = data.getOrdinal();
    }
}

