/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;
    private static final NMSLException \u8eab\u4f53\u597d = new NMSLException("\u4dc1\u2791\u4ddd\u270d\u4dc4\u4df0\u4bc6\u4dfe\u4dff\u4dfc\u38ed\u4dec\u4a46\u2743\u4dd0\u2783\u4dd3\u4dc8\u26c6\u4dcc\u4a98\u4d61\u4ddc\u269c\u2740\u4dcc\ua649\u26e3\u4dd9\u4dcf\u4df6\u4dcb\u4dd1\u4df0\u268f\u4dc5\u4dd3");

    public void replace(AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        InjectionNode injectionNode = this.get(oldNode);
        if (injectionNode != null) {
            injectionNode.replace(newNode);
        }
    }

    public boolean contains(AbstractInsnNode node) {
        return this.get(node) != null;
    }

    public InjectionNode get(AbstractInsnNode node) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(node)) continue;
            return injectionNode;
        }
        return null;
    }

    public InjectionNode add(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(node);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public void remove(AbstractInsnNode node) {
        InjectionNode injectionNode = this.get(node);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private final AbstractInsnNode originalTarget;
        private final int id;
        private AbstractInsnNode currentTarget;
        private Map<String, Object> decorations;
        private static int nextId;
        private static final NMSLException \u6b22\u8fce\u548c\u6211\u4eec\u540c\u884c;

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public int getId() {
            return this.id;
        }

        public boolean isRemoved() {
            return this.currentTarget == null;
        }

        @Override
        public int compareTo(InjectionNode other) {
            return other == null ? Integer.MAX_VALUE : this.hashCode() - other.hashCode();
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public boolean isReplaced() {
            return this.originalTarget != this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode target) {
            this.currentTarget = target;
            return this;
        }

        public <V> InjectionNode decorate(String key, V value) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(key, value);
            return this;
        }

        public boolean matches(AbstractInsnNode node) {
            return this.originalTarget == node || this.currentTarget == node;
        }

        public InjectionNode(AbstractInsnNode node) {
            this.currentTarget = this.originalTarget = node;
            this.id = nextId++;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        static {
            \u6b22\u8fce\u548c\u6211\u4eec\u540c\u884c = new NMSLException("\u4dcd\u263e\u4dee\ua68c\u4dd4\u4dcc\u4dc9\u4753\u4df7\u2722\u4ded\u278e\ua697\u4de2\u4df1\u4dee\u2711\u4dca\ua646\u261d\u270c\u279a\u4de7\ua65f\u4de6\u44ba\u4dd2\ua675\u4de3\u270a\u4de1\u2735\u4df9\u4dd8\u27a4\u26ac\u4df3\u4ddb\u265d\u4de6\u276e\u4ddb\u274c\u4dfc\ua68e\u4dfa\ua69a\u4dcf\ua696");
            nextId = 0;
        }

        public String toString() {
            return String.format("InjectionNode[%s]", Bytecode.describeNode(this.currentTarget).replaceAll("\\s+", " "));
        }

        public <V> V getDecoration(String key) {
            return (V)(this.decorations == null ? null : this.decorations.get(key));
        }

        public boolean hasDecoration(String key) {
            return this.decorations != null && this.decorations.get(key) != null;
        }
    }
}

