/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public class InjectorGroupInfo {
    private final List<InjectionInfo> members = new ArrayList<InjectionInfo>();
    private final String name;
    private int minCallbackCount = -1;
    private final boolean isDefault;
    private int maxCallbackCount = Integer.MAX_VALUE;
    private static final NMSLException \u6211\u62cd\u4e00 = new NMSLException("\u2645\ua68c\u4de0\u2759\u4dd5\u2741\u2728\u2606\u27b6\u4dcd\u4de1\u2757\ua644\u4df6\ua642\u4de6\u4dc5\u4b0c\u4dcf\u4dee\u4dc1\ua652\u274c\u4dda\u42c6\u4ddc\u4dc7\u4dc9\u442f\u4dfe\u260d\u2644\u2798\u4df1\u4dd0\u4ddf\ua676\u4dd5\u4df3\u4dde\ua656\u2669\u27be\u3465\u2677");

    InjectorGroupInfo(String name, boolean flag) {
        this.name = name;
        this.isDefault = flag;
    }

    public Collection<InjectionInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public int getMinRequired() {
        return Math.max(this.minCallbackCount, 1);
    }

    public InjectorGroupInfo add(InjectionInfo member) {
        this.members.add(member);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public InjectorGroupInfo(String name) {
        this(name, false);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setMinRequired(int min) {
        if (min < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group min count. Attempted to set min=" + min + " on " + this);
        }
        if (this.minCallbackCount > 0 && this.minCallbackCount != min) {
            LogManager.getLogger((String)"mixin").warn("Conflicting min value '{}' on @Group({}), previously specified {}", new Object[]{min, this.name, this.minCallbackCount});
        }
        this.minCallbackCount = Math.max(this.minCallbackCount, min);
    }

    public InjectorGroupInfo validate() throws InjectionValidationException {
        if (this.members.size() == 0) {
            return this;
        }
        int total = 0;
        for (InjectionInfo member : this.members) {
            total += member.getInjectedCallbackCount();
        }
        int min = this.getMinRequired();
        int max = this.getMaxAllowed();
        if (total < min) {
            throw new InjectionValidationException(this, String.format("expected %d invocation(s) but only %d succeeded", min, total));
        }
        if (total > max) {
            throw new InjectionValidationException(this, String.format("maximum of %d invocation(s) allowed but %d succeeded", max, total));
        }
        return this;
    }

    public void setMaxAllowed(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Cannot set zero or negative value for injector group max count. Attempted to set max=" + max + " on " + this);
        }
        if (this.maxCallbackCount < Integer.MAX_VALUE && this.maxCallbackCount != max) {
            LogManager.getLogger((String)"mixin").warn("Conflicting max value '{}' on @Group({}), previously specified {}", new Object[]{max, this.name, this.maxCallbackCount});
        }
        this.maxCallbackCount = Math.min(this.maxCallbackCount, max);
    }

    public int getMaxAllowed() {
        return Math.min(this.maxCallbackCount, Integer.MAX_VALUE);
    }

    public String toString() {
        return String.format("@Group(name=%s, min=%d, max=%d)", this.getName(), this.getMinRequired(), this.getMaxAllowed());
    }

    public static final class Map
    extends HashMap<String, InjectorGroupInfo> {
        private static final InjectorGroupInfo NO_GROUP;
        private static final long serialVersionUID = 1L;
        private static final NMSLException \u9884\u5907\u8d77;

        public InjectorGroupInfo parseGroup(MethodNode method, String defaultGroup) {
            return this.parseGroup(Annotations.getInvisible(method, Group.class), defaultGroup);
        }

        public InjectorGroupInfo forName(String name) {
            InjectorGroupInfo value = (InjectorGroupInfo)super.get(name);
            if (value == null) {
                value = new InjectorGroupInfo(name);
                this.put(name, value);
            }
            return value;
        }

        static {
            \u9884\u5907\u8d77 = new NMSLException("\ua642\u2617\u263f\u4dc4\u2674\ua64c\u4dfa\u3a6b\u2610\u36be\ua691\u4df9\u4de4\u4dc4\u4ddf\u2730\u2769\u2738\u4de3\u4dd3\u4de4\u4de3\u26cc\u4df1\u264c\ua659\ua64b\u4dcd\u4df8\u4de1\u266d\u4df9\u26e3\u4dc4\u2718\u267d\u2612\u47ad\ua64c");
            NO_GROUP = new InjectorGroupInfo("NONE", true);
        }

        @Override
        public InjectorGroupInfo get(Object key) {
            return this.forName(key.toString());
        }

        public void validateAll() throws InjectionValidationException {
            for (InjectorGroupInfo group : this.values()) {
                group.validate();
            }
        }

        public InjectorGroupInfo parseGroup(AnnotationNode annotation, String defaultGroup) {
            Integer max;
            if (annotation == null) {
                return NO_GROUP;
            }
            String name = (String)Annotations.getValue(annotation, "name");
            if (name == null || name.isEmpty()) {
                name = defaultGroup;
            }
            InjectorGroupInfo groupInfo = this.forName(name);
            Integer min = (Integer)Annotations.getValue(annotation, "min");
            if (min != null && min != -1) {
                groupInfo.setMinRequired(min);
            }
            if ((max = (Integer)Annotations.getValue(annotation, "max")) != null && max != -1) {
                groupInfo.setMaxAllowed(max);
            }
            return groupInfo;
        }
    }
}

