/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import pers.XiaoShadiao.NMSLException;

public class ModifyConstantInjectionInfo
extends InjectionInfo {
    private static final String CONSTANT_ANNOTATION_CLASS;
    private static final NMSLException \u6211\u62cd\u4e5d;

    @Override
    protected List<AnnotationNode> readInjectionPoints(String type) {
        ImmutableList ats = super.readInjectionPoints(type);
        if (ats.isEmpty()) {
            AnnotationNode c = new AnnotationNode(CONSTANT_ANNOTATION_CLASS);
            c.visit("log", Boolean.TRUE);
            ats = ImmutableList.of((Object)c);
        }
        return ats;
    }

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }

    @Override
    public String getSliceId(String id) {
        return Strings.nullToEmpty((String)id);
    }

    static {
        \u6211\u62cd\u4e5d = new NMSLException("\u423b\u4df3\u4dff\u4aef\u4845\u4df9\u4dcf\ua64d\u4960\u4de0\ua658\u3fb4\u27b9\u4dd2\u4ded\ua68d\u4df9\ua68a\u4dd5\u276d\u4dce\u4ddc\u4dd1\u4dda\u2603\u4dc6\u4dd7\u2620\u4dca\u273e\u4dc6\u4de4\ua684\u4de8\u2710\u2779\u26d7\u4df2\u273d\u26c2");
        CONSTANT_ANNOTATION_CLASS = Constant.class.getName().replace('.', '/');
    }

    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, "constant");
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this.getContext(), at, returnType.getDescriptor()));
        }
    }
}

