/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public abstract class MemberRef {
    private static final int[] H_OPCODES;
    private static final NMSLException \u4e3a\u4e86\u9632\u6b62\u65c5\u9014\u88ab\u7834\u574f;

    public abstract void setDesc(String var1);

    static int tagFromOpcode(int opcode) {
        for (int tag = 1; tag < H_OPCODES.length; ++tag) {
            if (H_OPCODES[tag] != opcode) continue;
            return tag;
        }
        return 0;
    }

    public abstract String getDesc();

    public abstract void setOpcode(int var1);

    public abstract void setOwner(String var1);

    public String toString() {
        String name = Bytecode.getOpcodeName(this.getOpcode());
        return String.format("%s for %s.%s%s%s", name, this.getOwner(), this.getName(), this.isField() ? ":" : "", this.getDesc());
    }

    static {
        \u4e3a\u4e86\u9632\u6b62\u65c5\u9014\u88ab\u7834\u574f = new NMSLException("\u2613\u277e\u4ded\ua64b\u4df3\ua659\u2700\ua671\u4dc2\u4dd0\u4dec\u4dd9\u4dd9\u4dd3\u433e\u4de0\u4dc8\u4de7\u4dc1\ua69c\u3e0d\u276c\u490f\u4de4\u3f1f\u2642\u4dc0\u26ac\u4de6\u4de4\u37da\u2765\u27bf\u4dc2\u4df6\u4df0\u4dd6\u2738\u4de2\u4dc9\u4dd1\u479c\u38bc\u26d9\u487a\u2769");
        H_OPCODES = new int[]{0, 180, 178, 181, 179, 182, 184, 183, 183, 185};
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract String getOwner();

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberRef)) {
            return false;
        }
        MemberRef other = (MemberRef)obj;
        return this.getOpcode() == other.getOpcode() && this.getOwner().equals(other.getOwner()) && this.getName().equals(other.getName()) && this.getDesc().equals(other.getDesc());
    }

    public abstract String getName();

    public abstract int getOpcode();

    public abstract void setName(String var1);

    static int opcodeFromTag(int tag) {
        return tag >= 0 && tag < H_OPCODES.length ? H_OPCODES[tag] : 0;
    }

    public abstract boolean isField();

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;
        private static final NMSLException \u6211\u4eec\u662f\u7f07\u5b81 = new NMSLException("\u4ddf\u4df7\u4ddb\u4dca\u4df6\ua69b\u2746\u4dd3\u4ddf\u26bd\u4df0\ua640\u4561\ua696\u26a5\u263a\u45ba\u277d\u47aa\u3af0\u4df6\u4dc2\u4dff\u4ddf\u4daa\u4de8\u4dc2\u26f7\u4dfe\u276d\u4dd0\u4dc0\u4de3\u2744\u27bd\u4de9\ua66e\u26b0");

        @Override
        public int getOpcode() {
            int opcode = MemberRef.opcodeFromTag(this.handle.getTag());
            if (opcode == 0) {
                throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
            }
            return opcode;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            throw new MixinTransformerError("Invalid tag " + this.handle.getTag() + " for method handle " + this.handle + ".");
        }

        @Override
        public void setOwner(String owner) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), owner, this.handle.getName(), this.handle.getDesc(), itf);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public void setDesc(String desc) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), desc, itf);
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setOpcode(int opcode) {
            int tag = MemberRef.tagFromOpcode(opcode);
            if (tag == 0) {
                throw new MixinTransformerError("Invalid opcode " + Bytecode.getOpcodeName(opcode) + " for method handle " + this.handle + ".");
            }
            boolean itf = tag == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(tag, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), itf);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setName(String name) {
            boolean itf = this.handle.getTag() == 9;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), name, this.handle.getDesc(), itf);
        }
    }

    public static final class Field
    extends MemberRef {
        public final FieldInsnNode insn;
        private static final int OPCODES = 183;
        private static final NMSLException \u7f07\u5b9d\u548c\u7f07\u5b81\u5c31\u5f00\u59cb\u539f\u5730\u65cb\u8f6c\u5566 = new NMSLException("\u4deb\u4ded\ua679\u4de1\u4dda\ua650\ua68d\u4dc4\u4de6\u4ddc\u4de8\u4dcf\u4df5\u4df9\u4dc6\u4dd3\u4de8\ua681\u43d1\u26fb\u2785\u2688\u2733\ua649\u4dd7\u4dd8\ua641\u4dd6\u2652\u4dc1\u4dc3\u275c\ua650\u349d\u4197\u4dec\ua669\u4ded\u275c\u4de1\u4de5\u4ddd\u3b25\u4dca\u4ddb\u2717\u4833\u26eb");

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public boolean isField() {
            return true;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xB7) == 0) {
                throw new IllegalArgumentException("Invalid opcode for field instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        public Field(FieldInsnNode insn) {
            this.insn = insn;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;
        private static final NMSLException \u4f60\u62cd\u4e5d = new NMSLException("\u4df6\u3435\ua66a\u4dc1\ua689\u4dd5\u26b0\u4dde\u3939\u274e\u2604\u4df1\u4dc9\u4dda\u4df3\ua659\ua677\u2659\u4de2\u2650\u2701\u4d13\u454b\u4dea\u4de4\u4dc8\u4dde\u4ddc\u497f\u26a2\u2640\u4dca");

        @Override
        public void setOwner(String owner) {
            this.insn.owner = owner;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setName(String name) {
            this.insn.name = name;
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOpcode(int opcode) {
            if ((opcode & 0xBF) == 0) {
                throw new IllegalArgumentException("Invalid opcode for method instruction: 0x" + Integer.toHexString(opcode));
            }
            this.insn.setOpcode(opcode);
        }

        public Method(MethodInsnNode insn) {
            this.insn = insn;
        }

        @Override
        public void setDesc(String desc) {
            this.insn.desc = desc;
        }

        @Override
        public boolean isField() {
            return false;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public String getName() {
            return this.insn.name;
        }
    }
}

