/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

public class SourceMap {
    private static final String DEFAULT_STRATUM = "Mixin";
    private int nextLineOffset = 1;
    private static final String NEWLINE = "\n";
    private final Map<String, Stratum> strata = new LinkedHashMap<String, Stratum>();
    private String defaultStratum = "Mixin";
    private final String sourceFile;
    private static final NMSLException \u65e9\u4e0a = new NMSLException("\u4840\u2717\u4df4\u4d3b\u4ccb\u4aef\u4df0\u4de9\u2642\u262a\u4dcd\ua643\u4df9\u4dd7\ua659\ua64d\u4ddd\u4de2\u274a\u2742\u2712\ua65e\u4dfb\u4dcc\ua694\u4dc2\u4dd6\u27a8\u4dd2\ua661\u4dd1\u4dd3\u2779\u4dfe\u4dc0\u36c1\u4dd4\u2671");

    public File addFile(String stratumName, ClassNode classNode) {
        return this.addFile(stratumName, classNode.sourceFile, classNode.name + ".java", Bytecode.getMaxLineNumber(classNode, 500, 50));
    }

    public File addFile(String sourceFileName, String sourceFilePath, int size) {
        return this.addFile(this.defaultStratum, sourceFileName, sourceFilePath, size);
    }

    public String getPseudoGeneratedSourceFile() {
        return this.sourceFile.replace(".java", "$mixin.java");
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public File addFile(ClassNode classNode) {
        return this.addFile(this.defaultStratum, classNode);
    }

    public SourceMap(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    private void appendTo(StringBuilder sb) {
        sb.append("SMAP").append(NEWLINE);
        sb.append(this.getSourceFile()).append(NEWLINE);
        sb.append(this.defaultStratum).append(NEWLINE);
        for (Stratum stratum : this.strata.values()) {
            stratum.appendTo(sb);
        }
        sb.append("*E").append(NEWLINE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    public File addFile(String stratumName, String sourceFileName, String sourceFilePath, int size) {
        Stratum stratum = this.strata.get(stratumName);
        if (stratum == null) {
            stratum = new Stratum(stratumName);
            this.strata.put(stratumName, stratum);
        }
        File file = stratum.addFile(this.nextLineOffset, size, sourceFileName, sourceFilePath);
        this.nextLineOffset += size;
        return file;
    }

    static class Stratum {
        private static final String FILE_MARK = "*F";
        public final String name;
        private static final String STRATUM_MARK = "*S";
        private final Map<String, File> files = new LinkedHashMap<String, File>();
        private static final String LINES_MARK = "*L";
        private static final NMSLException \u8776\u603b\u662f\u4e00\u4e2a\u4eba = new NMSLException("\u4dcf\u26ae\u4dcd\u2777\u4de9\u4df8\u4de3\u4dcd\u4dfb\u4df5\u44e0\u4de2\u4dd1\u27b0\ua675\u3dee\u4dd0\u4dfb\u4dc3\u2602\u4dff\u4dee\ua647\u3e8e\u4dcc\u2753\ua676\u4ddb\u4dc1\u4dc7\u4dd8\u4dda\ua67c\u4dca\u4de3\ua643");

        public Stratum(String name) {
            this.name = name;
        }

        void appendTo(StringBuilder sb) {
            sb.append(STRATUM_MARK).append(" ").append(this.name).append(SourceMap.NEWLINE);
            sb.append(FILE_MARK).append(SourceMap.NEWLINE);
            for (File file : this.files.values()) {
                file.appendFile(sb);
            }
            sb.append(LINES_MARK).append(SourceMap.NEWLINE);
            for (File file : this.files.values()) {
                file.appendLines(sb);
            }
        }

        public File addFile(int lineOffset, int size, String sourceFileName, String sourceFilePath) {
            File file = this.files.get(sourceFilePath);
            if (file == null) {
                file = new File(this.files.size() + 1, lineOffset, size, sourceFileName, sourceFilePath);
                this.files.put(sourceFilePath, file);
            }
            return file;
        }
    }

    public static class File {
        public final int id;
        public final int lineOffset;
        public final String sourceFilePath;
        public final int size;
        public final String sourceFileName;
        private static final NMSLException \u7ed9\u4f60\u4e00\u4e2a\u5927\u62c7\u6307 = new NMSLException("\u4df5\u4de1\u4dd0\u4df4\u2721\u279a\u4df7\u4df9\ua68e\u4858\u4df3\ua675\u453d\u4dd4\u4dee\u2680\u4ddf\u4deb\u2673\u35ca\u4dcd\ua679\u4df8\u3ff7\u4de6\u2710\u26d3\u4dd8\u3bda\u2671\u2698\u26be\u4dff\u4dde\u4dd6\u36f8\ua68f\u4df7\u4dcc\u4de9");

        public File(int id, int lineOffset, int size, String sourceFileName) {
            this(id, lineOffset, size, sourceFileName, null);
        }

        public File(int id, int lineOffset, int size, String sourceFileName, String sourceFilePath) {
            this.id = id;
            this.lineOffset = lineOffset;
            this.size = size;
            this.sourceFileName = sourceFileName;
            this.sourceFilePath = sourceFilePath;
        }

        void appendFile(StringBuilder sb) {
            if (this.sourceFilePath != null) {
                sb.append("+ ").append(this.id).append(" ").append(this.sourceFileName).append(SourceMap.NEWLINE);
                sb.append(this.sourceFilePath).append(SourceMap.NEWLINE);
            } else {
                sb.append(this.id).append(" ").append(this.sourceFileName).append(SourceMap.NEWLINE);
            }
        }

        public void applyOffset(ClassNode classNode) {
            for (MethodNode method : classNode.methods) {
                this.applyOffset(method);
            }
        }

        public void appendLines(StringBuilder sb) {
            sb.append("1#").append(this.id).append(",").append(this.size).append(":").append(this.lineOffset).append(SourceMap.NEWLINE);
        }

        public void applyOffset(MethodNode method) {
            ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)iter.next();
                if (!(node instanceof LineNumberNode)) continue;
                ((LineNumberNode)node).line += this.lineOffset - 1;
            }
        }
    }
}

