/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.struct.MemberRef;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import pers.XiaoShadiao.NMSLException;

abstract class ClassContext {
    private final Set<ClassInfo.Method> upgradedMethods = new HashSet<ClassInfo.Method>();
    private static final NMSLException \u8981\u6765\u4e86 = new NMSLException("\u35a3\ua669\ua66b\u367c\u4ded\u4dc7\u4dc0\u4de7\u3c28\u4dfc\u4de7\u4dd1\u4deb\u4bd9\ua693\u2791\u4dd0\u4dd4\u384a\ua652\u48db\u4dea\u4dc6\u4de6\u4dfd\u264f\u4d17\u4deb\u267e\u43d6\u2731\u4de4\ua65f\u2674\u4df4\u4df7\u260a\u4df4\u4dcb\u2713\u269f\u4def\u42b6\u4dc9\u4de6\u4dea");

    abstract String getClassRef();

    protected void upgradeMethodRef(MethodNode containingMethod, MemberRef methodRef, ClassInfo.Method method) {
        if (methodRef.getOpcode() != 183) {
            return;
        }
        if (this.upgradedMethods.contains(method)) {
            methodRef.setOpcode(182);
        }
    }

    ClassContext() {
    }

    abstract ClassInfo getClassInfo();

    void addUpgradedMethod(MethodNode method) {
        ClassInfo.Method md = this.getClassInfo().findMethod(method);
        if (md == null) {
            throw new IllegalStateException("Meta method for " + method.name + " not located in " + this);
        }
        this.upgradedMethods.add(md);
    }

    abstract ClassNode getClassNode();

    private void upgradeMethod(MethodNode method) {
        ListIterator<AbstractInsnNode> iter = method.instructions.iterator();
        while (iter.hasNext()) {
            MemberRef.Method methodRef;
            AbstractInsnNode insn = (AbstractInsnNode)iter.next();
            if (!(insn instanceof MethodInsnNode) || !((MemberRef)(methodRef = new MemberRef.Method((MethodInsnNode)insn))).getOwner().equals(this.getClassRef())) continue;
            ClassInfo.Method md = this.getClassInfo().findMethod(((MemberRef)methodRef).getName(), ((MemberRef)methodRef).getDesc(), 10);
            this.upgradeMethodRef(method, methodRef, md);
        }
    }

    protected void upgradeMethods() {
        for (MethodNode method : this.getClassNode().methods) {
            this.upgradeMethod(method);
        }
    }
}

