/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.commons.ClassRemapper;
import org.spongepowered.asm.lib.commons.Remapper;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.transformers.MixinClassWriter;
import pers.XiaoShadiao.NMSLException;

final class InnerClassGenerator
implements IClassGenerator {
    private static final Logger logger;
    private final Map<String, InnerClassInfo> innerClasses;
    private final Map<String, String> innerClassNames = new HashMap<String, String>();
    private static final NMSLException \u8981\u662f\u4ed6\u4e0d\u8bf4;

    static {
        \u8981\u662f\u4ed6\u4e0d\u8bf4 = new NMSLException("\u271a\u4dc1\ua69d\u4dcd\u27a0\u4df1\u4ddc\u4de1\u4dc3\u37cb\u4dfb\u4dd8\u4ddd\u4dd8\u27af\u263a\u2615\u2702\u2720\u2657\u4df5\u3b7c\u4df6\u4ddd\u4dd9\u4dd7\u264d\u4df1\u4de4\u27a9\u4dc2\u4de1\u4df3\ua661\u4de0\u26cc\u268d\u4de1\u4dcc\u4dca\u3e4c\u39e7\u4df8\u4df3\u4de1\u4df5\u2688\u4dff");
        logger = LogManager.getLogger((String)"mixin");
    }

    private byte[] generate(InnerClassInfo info) {
        try {
            logger.debug("Generating mapped inner class {} (originally {})", new Object[]{info.getName(), info.getOriginalName()});
            ClassReader cr = new ClassReader(info.getClassBytes());
            MixinClassWriter cw = new MixinClassWriter(cr, 0);
            cr.accept(new InnerClassAdapter((ClassVisitor)cw, info), 8);
            return cw.toByteArray();
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] generate(String name) {
        String ref = name.replace('.', '/');
        InnerClassInfo info = this.innerClasses.get(ref);
        if (info != null) {
            return this.generate(info);
        }
        return null;
    }

    InnerClassGenerator() {
        this.innerClasses = new HashMap<String, InnerClassInfo>();
    }

    private static String getUniqueReference(String originalName, MixinTargetContext context) {
        String name = originalName.substring(originalName.lastIndexOf(36) + 1);
        if (name.matches("^[0-9]+$")) {
            name = "Anonymous";
        }
        return String.format("%s$%s$%s", context.getTargetClassRef(), name, UUID.randomUUID().toString().replace("-", ""));
    }

    public String registerInnerClass(MixinInfo owner, String originalName, MixinTargetContext context) {
        String id = String.format("%s%s", originalName, context);
        String ref = this.innerClassNames.get(id);
        if (ref == null) {
            ref = InnerClassGenerator.getUniqueReference(originalName, context);
            this.innerClassNames.put(id, ref);
            this.innerClasses.put(ref, new InnerClassInfo(ref, originalName, owner, context));
            logger.debug("Inner class {} in {} on {} gets unique name {}", new Object[]{originalName, owner.getClassRef(), context.getTargetClassRef(), ref});
        }
        return ref;
    }

    static class InnerClassAdapter
    extends ClassRemapper {
        private final InnerClassInfo info;
        private static final NMSLException \u6211\u4eec\u7684\u8863\u670d\u5c31\u662f\u963f\u96c5\u7f1d\u7684 = new NMSLException("\u4dfa\u4df8\ua68c\u3df0\u4dd6\u2679\u4ddc\u4dce\u4dc4\u4de4\u4dde\u4df7\ua67f\ua66c\u4deb\u4dde\u395f\ua678\u4dec\u4df9\u4de8\u2714\u2776\u4dcb\ua697\u4df1\ua65d\u4dc4\u260d\u275d\u4de2\u4deb\ua696\u4dfb\u4dfc\u263c\u4ddb\u26f8\u4c65\u3976\u263f");

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name.startsWith(this.info.getOriginalName() + "$")) {
                throw new InvalidMixinException((IMixinInfo)this.info.getOwner(), "Found unsupported nested inner class " + name + " in " + this.info.getOriginalName());
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public InnerClassAdapter(ClassVisitor cv, InnerClassInfo info) {
            super(327680, cv, info);
            this.info = info;
        }

        @Override
        public void visitSource(String source, String debug) {
            super.visitSource(source, debug);
            AnnotationVisitor av = this.cv.visitAnnotation("Lorg/spongepowered/asm/mixin/transformer/meta/MixinInner;", false);
            av.visit("mixin", this.info.getOwner().toString());
            av.visit("name", this.info.getOriginalName().substring(this.info.getOriginalName().lastIndexOf(47) + 1));
            av.visitEnd();
        }
    }

    static class InnerClassInfo
    extends Remapper {
        private final String originalName;
        private final String targetName;
        private final MixinInfo owner;
        private final String name;
        private final String ownerName;
        private final MixinTargetContext target;
        private static final NMSLException \u7f07\u5b9d\u548c\u7f07\u5b81\u5c31\u5f00\u59cb\u539f\u5730\u65cb\u8f6c\u5566 = new NMSLException("\u4dd1\u4de7\ua690\ua67c\u4dc0\u4dd9\u2745\u4dcd\u2666\u43fa\u4d3b\u4ddc\u4df6\u2658\u4df7\u3714\u274b\u26fa\u4de7\u4de5\u4de0\u4dc7\u27bf\u273f\u2701\u27ab\u4dec\u26d2\u27ae\u4dd6\u4dcc\u4456\u2618\u4dcb\u4ddf\u4ad9\u4ded\u26ee\u4ddd\u4dc5\u4dd3\u4df1\ua677\u4dda\u4dfe\u4dc3\ua682\u2681");

        String getOriginalName() {
            return this.originalName;
        }

        InnerClassInfo(String name, String originalName, MixinInfo owner, MixinTargetContext target) {
            this.name = name;
            this.originalName = originalName;
            this.owner = owner;
            this.ownerName = owner.getClassRef();
            this.target = target;
            this.targetName = target.getTargetClassRef();
        }

        MixinInfo getOwner() {
            return this.owner;
        }

        @Override
        public String map(String key) {
            if (this.originalName.equals(key)) {
                return this.name;
            }
            if (this.ownerName.equals(key)) {
                return this.targetName;
            }
            return key;
        }

        String getTargetName() {
            return this.targetName;
        }

        String getOwnerName() {
            return this.ownerName;
        }

        String getName() {
            return this.name;
        }

        byte[] getClassBytes() throws ClassNotFoundException, IOException {
            return MixinService.getService().getBytecodeProvider().getClassBytes(this.originalName, true);
        }

        MixinTargetContext getTarget() {
            return this.target;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            ClassInfo.Method method;
            if (this.ownerName.equalsIgnoreCase(owner) && (method = this.owner.getClassInfo().findMethod(name, desc, 10)) != null) {
                return method.getName();
            }
            return super.mapMethodName(owner, name, desc);
        }

        public String toString() {
            return this.name;
        }
    }
}

