/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.NMSLException;

public final class InterfaceInfo {
    private final boolean unique;
    private Set<String> methods;
    private final MixinInfo mixin;
    private final Type iface;
    private final String prefix;
    private static final NMSLException \u4e00\u4e2a\u4eba\u625b\u4e0b\u6240\u6709\u771f\u662f\u574f\u4e60\u60ef\u5440 = new NMSLException("\u4dcb\u4de4\u2696\u4de2\u4de0\u277a\ua65a\u4de6\ua695\u4dd0\u4df8\u264f\u2728\ua658\u4477\ua694\u26a1\u4dd7\u34df\ua65d\u4dc9\u268e\ua691\ua69b\u4dd8\ua668\u4dcb\u2743\u3a39\u4dd1\u421d\u4dd8\u4dc7\u2624\u4dff\u4dc5\u4dee\u4dfa\u4df3\u4dfa\u4d38");

    private void decorateUniqueMethod(MethodNode method) {
        if (!this.unique) {
            return;
        }
        if (Annotations.getVisible(method, Unique.class) == null) {
            Annotations.setVisible(method, Unique.class, new Object[0]);
            this.mixin.getClassInfo().findMethod(method).setUnique(true);
        }
    }

    public int hashCode() {
        int result = this.mixin.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + this.iface.hashCode();
        return result;
    }

    private void initMethods() {
        this.methods = new HashSet<String>();
        this.readInterface(this.iface.getInternalName());
    }

    public Type getIface() {
        return this.iface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterfaceInfo that = (InterfaceInfo)o;
        return this.mixin.equals(that.mixin) && this.prefix.equals(that.prefix) && this.iface.equals(that.iface);
    }

    public String getName() {
        return this.iface.getClassName();
    }

    private InterfaceInfo(MixinInfo mixin, String prefix, Type iface, boolean unique) {
        if (prefix == null || prefix.length() < 2 || !prefix.endsWith("$")) {
            throw new InvalidMixinException((IMixinInfo)mixin, String.format("Prefix %s for iface %s is not valid", prefix, iface.toString()));
        }
        this.mixin = mixin;
        this.prefix = prefix;
        this.iface = iface;
        this.unique = unique;
    }

    private void readInterface(String ifaceName) {
        ClassInfo interfaceInfo = ClassInfo.forName(ifaceName);
        for (ClassInfo.Method ifaceMethod : interfaceInfo.getMethods()) {
            this.methods.add(ifaceMethod.toString());
        }
        for (String superIface : interfaceInfo.getInterfaces()) {
            this.readInterface(superIface);
        }
    }

    public boolean renameMethod(MethodNode method) {
        if (this.methods == null) {
            this.initMethods();
        }
        if (!method.name.startsWith(this.prefix)) {
            if (this.methods.contains(method.name + method.desc)) {
                this.decorateUniqueMethod(method);
            }
            return false;
        }
        String realName = method.name.substring(this.prefix.length());
        String signature = realName + method.desc;
        if (!this.methods.contains(signature)) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format("%s does not exist in target interface %s", realName, this.getName()));
        }
        if ((method.access & 1) == 0) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format("%s cannot implement %s because it is not visible", realName, this.getName()));
        }
        Annotations.setVisible(method, MixinRenamed.class, "originalName", method.name, "isInterfaceMember", true);
        this.decorateUniqueMethod(method);
        method.name = realName;
        return true;
    }

    static InterfaceInfo fromAnnotation(MixinInfo mixin, AnnotationNode node) {
        String prefix = (String)Annotations.getValue(node, "prefix");
        Type iface = (Type)Annotations.getValue(node, "iface");
        Boolean unique = (Boolean)Annotations.getValue(node, "unique");
        if (prefix == null || iface == null) {
            throw new InvalidMixinException((IMixinInfo)mixin, String.format("@Interface annotation on %s is missing a required parameter", mixin));
        }
        return new InterfaceInfo(mixin, prefix, iface, unique != null && unique != false);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getInternalName() {
        return this.iface.getInternalName();
    }

    public String getPrefix() {
        return this.prefix;
    }
}

