/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorAccessor;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorInterface;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTargetAlreadyLoadedException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.NMSLException;

class MixinInfo
implements Comparable<MixinInfo>,
IMixinInfo {
    private final transient Profiler profiler;
    private final transient int order;
    private static final IMixinService classLoaderUtil;
    static int mixinOrder;
    private final int priority;
    private final boolean virtual;
    private final transient boolean strict;
    private transient State pendingState;
    private final List<ClassInfo> targetClasses;
    private final transient Logger logger = LogManager.getLogger((String)"mixin");
    private final transient IMixinConfigPlugin plugin;
    private final String className;
    private final transient ClassInfo info;
    private final transient MixinEnvironment.Phase phase;
    private final transient MixinConfig parent;
    private transient State state;
    private final String name;
    private final transient SubType type;
    private final List<String> targetClassNames;
    private final transient IMixinService service;
    private static final NMSLException \u6211\u662f\u7f07\u5b89;

    protected List<ClassInfo> readTargetClasses(MixinClassNode classNode, boolean suppressPlugin) {
        if (classNode == null) {
            return Collections.emptyList();
        }
        AnnotationNode mixin = Annotations.getInvisible(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException((IMixinInfo)this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        ArrayList<ClassInfo> targets = new ArrayList<ClassInfo>();
        List publicTargets = (List)Annotations.getValue(mixin, "value");
        List privateTargets = (List)Annotations.getValue(mixin, "targets");
        if (publicTargets != null) {
            this.readTargets(targets, Lists.transform((List)publicTargets, (Function)new Function<Type, String>(){
                private static final NMSLException \u65e9\u4e0a = new NMSLException("\u4df1\u4ded\u4dcb\u4408\u4dde\u4de1\u4dd9\u2700\u4ddc\u26f7\u4def\u46c6\u3af1\u4ddf\ua697\u2724\u4dc9\u4de4\u35af\u4de0\ua68b\u4de8\ua663\u27bb\ua682\u4dcf\u4de3\ua678\u2731\u4de9\u4dfa\u4dff\u495c\u4dd8\u272c\u4ded\u4b84\u4dc9\ua695\u4dca\u4ded\u26ee");

                public String apply(Type input) {
                    return input.getClassName();
                }
            }), suppressPlugin, false);
        }
        if (privateTargets != null) {
            this.readTargets(targets, Lists.transform((List)privateTargets, (Function)new Function<String, String>(){
                private static final NMSLException \u6211\u62cd\u4e09 = new NMSLException("\u26be\ua687\u2666\u26d0\u2691\u4dc2\u2629\u4df5\u4df8\u4dd7\u4ddd\u4dec\u2796\u4dcd\u27b1\u3d9f\u27a7\u2676\u47ef\u4de9\u35c5\u4dcb\u3a52\u27a2\u4df3\u4de9\u26a8\u4df1\u4dd7\u4df3\u2753\u2750\u488c\u4dc5\u277d\u27af\u4dfb\u4dd4\u2655\u4dc2\u4dfd\u4df0\u3ae4\u4dcf\u4de4\u4df0\u4df6\u42b5");

                public String apply(String input) {
                    return MixinInfo.this.getParent().remapClassName(MixinInfo.this.getClassRef(), input);
                }
            }), suppressPlugin, true);
        }
        return targets;
    }

    @Override
    public MixinEnvironment.Phase getPhase() {
        return this.phase;
    }

    MixinTargetContext createContextFor(TargetClassContext target) {
        MixinClassNode classNode = this.getClassNode(8);
        Profiler.Section preTimer = this.profiler.begin("pre");
        MixinTargetContext preProcessor = this.type.createPreProcessor(classNode).prepare().createContextFor(target);
        preTimer.end();
        return preProcessor;
    }

    protected boolean readPseudo(ClassNode classNode) {
        return Annotations.getInvisible(classNode, Pseudo.class) != null;
    }

    @Override
    public List<String> getTargetClasses() {
        return this.targetClassNames;
    }

    public Level getLoggingLevel() {
        return this.parent.getLoggingLevel();
    }

    @Override
    public boolean isDetachedSuper() {
        return this.getState().isDetachedSuper();
    }

    MixinInfo(IMixinService service, MixinConfig parent, String name, boolean runTransformers, IMixinConfigPlugin plugin, boolean suppressPlugin) {
        this.profiler = MixinEnvironment.getProfiler();
        this.order = mixinOrder++;
        this.service = service;
        this.parent = parent;
        this.name = name;
        this.className = parent.getMixinPackage() + name;
        this.plugin = plugin;
        this.phase = parent.getEnvironment().getPhase();
        this.strict = parent.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_TARGETS);
        try {
            byte[] mixinBytes = this.loadMixinClass(this.className, runTransformers);
            this.pendingState = new State(mixinBytes);
            this.info = this.pendingState.getClassInfo();
            this.type = SubType.getTypeFor(this);
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)ex);
        }
        if (!this.type.isLoadable()) {
            classLoaderUtil.registerInvalidClass(this.className);
        }
        try {
            this.priority = this.readPriority(this.pendingState.getClassNode());
            this.virtual = this.readPseudo(this.pendingState.getClassNode());
            this.targetClasses = this.readTargetClasses(this.pendingState.getClassNode(), suppressPlugin);
            this.targetClassNames = Collections.unmodifiableList(Lists.transform(this.targetClasses, (Function)Functions.toStringFunction()));
        }
        catch (InvalidMixinException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)ex);
        }
    }

    private boolean isReloading() {
        return this.pendingState instanceof Reloaded;
    }

    public void postApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            Profiler.Section pluginTimer = this.profiler.begin("plugin");
            this.plugin.postApply(transformedName, targetClass, this.className, this);
            pluginTimer.end();
        }
        this.parent.postApply(transformedName, targetClass);
    }

    public boolean isAccessor() {
        return this.type instanceof SubType.Accessor;
    }

    private ClassInfo getTarget(String targetName, boolean checkPublic) throws InvalidMixinException {
        ClassInfo targetInfo = ClassInfo.forName(targetName);
        if (targetInfo == null) {
            if (this.isVirtual()) {
                this.logger.debug("Skipping virtual target {} for {}", new Object[]{targetName, this});
            } else {
                this.handleTargetError(String.format("@Mixin target %s was not found %s", targetName, this));
            }
            return null;
        }
        this.type.validateTarget(targetName, targetInfo);
        if (checkPublic && targetInfo.isPublic() && !this.isVirtual()) {
            this.handleTargetError(String.format("@Mixin target %s is public in %s and should be specified in value", targetName, this));
        }
        return targetInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    ClassInfo getClassInfo() {
        return this.info;
    }

    private boolean shouldApplyMixin(boolean suppressPlugin, String targetName) {
        Profiler.Section pluginTimer = this.profiler.begin("plugin");
        boolean result = this.plugin == null || suppressPlugin || this.plugin.shouldApplyMixin(targetName, this.className);
        pluginTimer.end();
        return result;
    }

    @Override
    public MixinClassNode getClassNode(int flags) {
        return this.getState().createClassNode(flags);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public String getClassRef() {
        return this.getClassInfo().getName();
    }

    public boolean isLoadable() {
        return this.type.isLoadable();
    }

    Set<String> getInterfaces() {
        return this.getState().getInterfaces();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean isUnique() {
        return this.getState().isUnique();
    }

    @Override
    public byte[] getClassBytes() {
        return this.getState().getClassBytes();
    }

    @Override
    public IMixinConfig getConfig() {
        return this.parent;
    }

    private void readTargets(Collection<ClassInfo> outTargets, Collection<String> inTargets, boolean suppressPlugin, boolean checkPublic) {
        for (String targetRef : inTargets) {
            ClassInfo targetInfo;
            String targetName = targetRef.replace('/', '.');
            if (classLoaderUtil.isClassLoaded(targetName) && !this.isReloading()) {
                String message = String.format("Critical problem: %s target %s was already transformed.", this, targetName);
                if (this.parent.isRequired()) {
                    throw new MixinTargetAlreadyLoadedException((IMixinInfo)this, message, targetName);
                }
                this.logger.error(message);
            }
            if (!this.shouldApplyMixin(suppressPlugin, targetName) || (targetInfo = this.getTarget(targetName, checkPublic)) == null || outTargets.contains(targetInfo)) continue;
            outTargets.add(targetInfo);
            targetInfo.addMixin(this);
        }
    }

    MixinConfig getParent() {
        return this.parent;
    }

    void reloadMixin(byte[] mixinBytes) {
        if (this.pendingState != null) {
            throw new IllegalStateException("Cannot reload mixin while it is initialising");
        }
        this.pendingState = new Reloaded(this.state, mixinBytes);
        this.validate();
    }

    void validate() {
        if (this.pendingState == null) {
            throw new IllegalStateException("No pending validation state for " + this);
        }
        try {
            this.pendingState.validate(this.type, this.targetClasses);
            this.state = this.pendingState;
        }
        finally {
            this.pendingState = null;
        }
    }

    static {
        \u6211\u662f\u7f07\u5b89 = new NMSLException("\u4dfb\u2659\u26f9\u27a8\u4deb\ua698\u275e\u4dca\u4dec\u4df1\u4dfa\u4df9\ua643\u2794\u4df3\u4ded\u264a\ua653\u4dc9\u377d\u4df6\u4dee\u2708\u268b\u26ba\u4dc7\u2615\u4dc7\u4df3\u2617\u4dfb\u4de7\u4dd5\ua677\u27bf\u4dfa\u26f7\ua642\ua686\ua661\u4dcf\u4dfd\u4dc6\u4ddc");
        classLoaderUtil = MixinService.getService();
        mixinOrder = 0;
    }

    Set<String> getSyntheticInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getSyntheticInnerClasses());
    }

    private byte[] loadMixinClass(String mixinClassName, boolean runTransformers) throws ClassNotFoundException {
        byte[] mixinBytes = null;
        try {
            String restrictions;
            if (runTransformers && (restrictions = this.service.getClassRestrictions(mixinClassName)).length() > 0) {
                this.logger.error("Classloader restrictions [{}] encountered loading {}, name: {}", new Object[]{restrictions, this, mixinClassName});
            }
            mixinBytes = this.service.getBytecodeProvider().getClassBytes(mixinClassName, runTransformers);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(String.format("The specified mixin '%s' was not found", mixinClassName));
        }
        catch (IOException ex) {
            this.logger.warn("Failed to load mixin {}, the specified mixin will not be applied", new Object[]{mixinClassName});
            throw new InvalidMixinException(this, "An error was encountered whilst loading the mixin class", (Throwable)ex);
        }
        return mixinBytes;
    }

    public String toString() {
        return String.format("%s:%s", this.parent.getName(), this.name);
    }

    private State getState() {
        return this.state != null ? this.state : this.pendingState;
    }

    List<InterfaceInfo> getSoftImplements() {
        return Collections.unmodifiableList(this.getState().getSoftImplements());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    protected int readPriority(ClassNode classNode) {
        if (classNode == null) {
            return this.parent.getDefaultMixinPriority();
        }
        AnnotationNode mixin = Annotations.getInvisible(classNode, Mixin.class);
        if (mixin == null) {
            throw new InvalidMixinException((IMixinInfo)this, String.format("The mixin '%s' is missing an @Mixin annotation", this.className));
        }
        Integer priority = (Integer)Annotations.getValue(mixin, "priority");
        return priority == null ? this.parent.getDefaultMixinPriority() : priority.intValue();
    }

    private void handleTargetError(String message) {
        if (this.strict) {
            this.logger.error(message);
            throw new InvalidMixinException((IMixinInfo)this, message);
        }
        this.logger.warn(message);
    }

    public void preApply(String transformedName, ClassNode targetClass) {
        if (this.plugin != null) {
            Profiler.Section pluginTimer = this.profiler.begin("plugin");
            this.plugin.preApply(transformedName, targetClass, this.className, this);
            pluginTimer.end();
        }
    }

    List<ClassInfo> getTargets() {
        return Collections.unmodifiableList(this.targetClasses);
    }

    Set<String> getInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getInnerClasses());
    }

    @Override
    public int compareTo(MixinInfo other) {
        if (other == null) {
            return 0;
        }
        if (other.priority == this.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }

    static abstract class SubType {
        protected final boolean targetMustBeInterface;
        protected boolean detached;
        protected final MixinInfo mixin;
        protected final String annotationType;
        private static final NMSLException \u5934\u597d = new NMSLException("\u26c2\u26ec\u4dcf\u4dfa\u2796\u4dcc\u4dcd\ua691\u3f80\ua68b\u3772\u2746\u4df2\u4dd8\u4de0\u4de6\u263c\ua66a\u4def\ua687\u4de0\u2793\u483e\u47f1\u2686\u2726\u4dd7\u4dea\u2769\u4dc9\u266b\u4dda\u4df3\u3453\u274a\u267c\u4dd3\ua651\u4deb\u4de4\u4dd0\u4a43\u4dd5\u4df2\u4dd1");

        abstract MixinPreProcessorStandard createPreProcessor(MixinClassNode var1);

        abstract void validate(State var1, List<ClassInfo> var2);

        SubType(MixinInfo info, String annotationType, boolean targetMustBeInterface) {
            this.mixin = info;
            this.annotationType = annotationType;
            this.targetMustBeInterface = targetMustBeInterface;
        }

        static SubType getTypeFor(MixinInfo mixin) {
            if (!mixin.getClassInfo().isInterface()) {
                return new Standard(mixin);
            }
            boolean containsNonAccessorMethod = false;
            for (ClassInfo.Method method : mixin.getClassInfo().getMethods()) {
                containsNonAccessorMethod |= !method.isAccessor();
            }
            if (containsNonAccessorMethod) {
                return new Interface(mixin);
            }
            return new Accessor(mixin);
        }

        boolean isLoadable() {
            return false;
        }

        Collection<String> getInterfaces() {
            return Collections.emptyList();
        }

        void validateTarget(String targetName, ClassInfo targetInfo) {
            boolean targetIsInterface = targetInfo.isInterface();
            if (targetIsInterface != this.targetMustBeInterface) {
                String not = targetIsInterface ? "" : "not ";
                throw new InvalidMixinException((IMixinInfo)this.mixin, this.annotationType + " target type mismatch: " + targetName + " is " + not + "an interface in " + this);
            }
        }

        boolean isDetachedSuper() {
            return this.detached;
        }

        static class Accessor
        extends SubType {
            private final Collection<String> interfaces = new ArrayList<String>();
            private static final NMSLException \u4ec0 = new NMSLException("\u35da\u2788\u4dfb\u4dca\u276b\u276a\ua67d\u4ddb\u4ddc\u4de7\u4ddf\u4dce\u2757\u4de5\u4dc3\u266c\u261d\u4de8\u274c\u3fb5\u4dc2\u275c\ua679\u4dd7\u4de0\u4ddb\u2685\ua667\u4dec\u4df3\u27a7\u4d68\u4dca\ua646\u4de4\u4df4\u4dda\u4dc6\u4dfa\u275b\ua69d\u4dd9\u265b");

            @Override
            void validateTarget(String targetName, ClassInfo targetInfo) {
                boolean targetIsInterface = targetInfo.isInterface();
                if (targetIsInterface && !MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Accessor mixin targetting an interface is not supported in current enviromnment");
                }
            }

            @Override
            boolean isLoadable() {
                return true;
            }

            @Override
            Collection<String> getInterfaces() {
                return this.interfaces;
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorAccessor(this.mixin, classNode);
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                MixinClassNode classNode = state.getClassNode();
                if (!"java/lang/Object".equals(classNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
                }
            }

            Accessor(MixinInfo info) {
                super(info, "@Mixin", false);
                this.interfaces.add(info.getClassRef());
            }
        }

        static class Interface
        extends SubType {
            private static final NMSLException \u4ec0\u4e48\u65f6\u5019\u80fd\u7ed3\u675f = new NMSLException("\u268e\u4df1\u4dc6\ua670\u278b\u2756\u4dd3\u2746\ua688\u4df5\u4dcb\u4dd5\u4ddc\u4dcb\ua680\u4df8\u26d3\u40ac\u272f\u4deb\u4dd5\u2615\u4dfa\u4de0\u4dd8\u2795\u270d\u3639\u2762\u4dcd\u4de5\u2626\u4df9\u4df9\u2757\u2713\u4de1");

            Interface(MixinInfo info) {
                super(info, "@Mixin", true);
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorInterface(this.mixin, classNode);
            }

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                if (!MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Interface mixin not supported in current enviromnment");
                }
                MixinClassNode classNode = state.getClassNode();
                if (!"java/lang/Object".equals(classNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class of " + this + " is invalid, found " + classNode.superName.replace('/', '.'));
                }
            }
        }

        static class Standard
        extends SubType {
            private static final NMSLException \u4e0d\u8bb8\u6b3a\u8d1f\u5927\u5bb6 = new NMSLException("\u2762\u273e\ua646\u4dc4\u278c\u2673\u4df2\u4dff\u266f\u26fe\u4dce\ua698\u4dea\u4ddc\u4dff\u4dc0\u3b5c\u278b\u2669\u4df6\u494d\u4ded\ua68c\u4de9\u4def\u4c8b\u4dc0\u4dc6\u4dd5\u4dc6\u4dcb\ua650\ua67f\u27be\u2693\ua665\u2619\ua687\u4de4");

            @Override
            void validate(State state, List<ClassInfo> targetClasses) {
                MixinClassNode classNode = state.getClassNode();
                for (ClassInfo targetClass : targetClasses) {
                    if (classNode.superName.equals(targetClass.getSuperName())) continue;
                    if (!targetClass.hasSuperClass(classNode.superName, ClassInfo.Traversal.SUPER)) {
                        ClassInfo superClass = ClassInfo.forName(classNode.superName);
                        if (superClass.isMixin()) {
                            for (ClassInfo superTarget : superClass.getTargets()) {
                                if (!targetClasses.contains(superTarget)) continue;
                                throw new InvalidMixinException((IMixinInfo)this.mixin, "Illegal hierarchy detected. Derived mixin " + this + " targets the same class " + superTarget.getClassName() + " as its superclass " + superClass.getClassName());
                            }
                        }
                        throw new InvalidMixinException((IMixinInfo)this.mixin, "Super class '" + classNode.superName.replace('/', '.') + "' of " + this.mixin.getName() + " was not found in the hierarchy of target class '" + targetClass + "'");
                    }
                    this.detached = true;
                }
            }

            Standard(MixinInfo info) {
                super(info, "@Mixin", false);
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode classNode) {
                return new MixinPreProcessorStandard(this.mixin, classNode);
            }
        }
    }

    class Reloaded
    extends State {
        private final State previous;
        private static final NMSLException \u6211\u4eec\u4e58\u7740\u7a7f\u68ad\u5728\u7fc1\u6cd5\u7f57\u65af\u7684\u706b\u7b52 = new NMSLException("\u4dce\u4df6\u4dc8\u4dce\u27bd\ua641\u269c\u4ddd\ua660\u4c6f\ua660\u4df2\ua689\ua64f\u4dce\u4dfb\u4deb\u4dc5\u3fab\u2679\ua695\u4dc3\u4ded\ua69e\ua673\u4dd0\ua68a\u4df3\u4dd9\u4dd1");

        @Override
        protected void validateChanges(SubType type, List<ClassInfo> targetClasses) {
            if (!this.syntheticInnerClasses.equals(this.previous.syntheticInnerClasses)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change inner classes");
            }
            if (!this.interfaces.equals(this.previous.interfaces)) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change interfaces");
            }
            if (!new HashSet(this.softImplements).equals(new HashSet<InterfaceInfo>(this.previous.softImplements))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change soft interfaces");
            }
            List<ClassInfo> targets = MixinInfo.this.readTargetClasses(this.classNode, true);
            if (!new HashSet<ClassInfo>(targets).equals(new HashSet<ClassInfo>(targetClasses))) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change target classes");
            }
            int priority = MixinInfo.this.readPriority(this.classNode);
            if (priority != MixinInfo.this.getPriority()) {
                throw new MixinReloadException(MixinInfo.this, "Cannot change mixin priority");
            }
        }

        Reloaded(State previous, byte[] mixinBytes) {
            super(mixinBytes, previous.getClassInfo());
            this.previous = previous;
        }
    }

    class State {
        private final ClassInfo classInfo;
        private boolean detachedSuper;
        private boolean unique;
        protected final Set<String> innerClasses;
        protected final Set<String> syntheticInnerClasses;
        private byte[] mixinBytes;
        protected final Set<String> interfaces = new HashSet<String>();
        protected MixinClassNode classNode;
        protected final List<InterfaceInfo> softImplements = new ArrayList<InterfaceInfo>();
        private static final NMSLException \u558f = new NMSLException("\u4dc8\u4df4\u4dd3\ua644\u4dfc\u4dc2\u4dcb\ua68a\u262f\u26a6\u4dc4\u26a8\u49a8\u4dcc\u48f9\ua663\u275f\u4dd7\u4dd6\u4df4\u4de2\u4def\u3c8c\u4152\u4dd0\u2748\u4df7\u2627\u2772\u266d\ua68c\u4df2\u4ded\u2648\u4dd6\u4dcb\u26ae\u26e7\u2670\u4de9\u3db0\u4df4");

        boolean isDetachedSuper() {
            return this.detachedSuper;
        }

        void readInnerClasses() {
            for (InnerClassNode inner : this.classNode.innerClasses) {
                ClassInfo innerClass = ClassInfo.forName(inner.name);
                if ((inner.outerName == null || !inner.outerName.equals(this.classInfo.getName())) && !inner.name.startsWith(this.classNode.name + "$")) continue;
                if (innerClass.isProbablyStatic() && innerClass.isSynthetic()) {
                    this.syntheticInnerClasses.add(inner.name);
                    continue;
                }
                this.innerClasses.add(inner.name);
            }
        }

        Set<String> getInnerClasses() {
            return this.innerClasses;
        }

        void validate(SubType type, List<ClassInfo> targetClasses) {
            MixinPreProcessorStandard preProcessor = type.createPreProcessor(this.getClassNode()).prepare();
            for (ClassInfo target : targetClasses) {
                preProcessor.conform(target);
            }
            type.validate(this, targetClasses);
            this.detachedSuper = type.isDetachedSuper();
            this.unique = Annotations.getVisible(this.getClassNode(), Unique.class) != null;
            this.validateInner();
            this.validateClassVersion();
            this.validateRemappables(targetClasses);
            this.readImplementations(type);
            this.readInnerClasses();
            this.validateChanges(type, targetClasses);
            this.complete();
        }

        List<? extends InterfaceInfo> getSoftImplements() {
            return this.softImplements;
        }

        MixinClassNode getClassNode() {
            return this.classNode;
        }

        private void validateRemappables(List<ClassInfo> targetClasses) {
            if (targetClasses.size() > 1) {
                for (FieldNode field : this.classNode.fields) {
                    this.validateRemappable(Shadow.class, field.name, Annotations.getVisible(field, Shadow.class));
                }
                for (MethodNode method : this.classNode.methods) {
                    this.validateRemappable(Shadow.class, method.name, Annotations.getVisible(method, Shadow.class));
                    AnnotationNode overwrite = Annotations.getVisible(method, Overwrite.class);
                    if (overwrite == null || (method.access & 8) != 0 && (method.access & 1) != 0) continue;
                    throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Found @Overwrite annotation on " + method.name + " in " + MixinInfo.this);
                }
            }
        }

        ClassInfo getClassInfo() {
            return this.classInfo;
        }

        State(byte[] mixinBytes) {
            this(mixinBytes, null);
        }

        MixinClassNode createClassNode(int flags) {
            MixinClassNode classNode = new MixinClassNode(MixinInfo.this);
            ClassReader classReader = new ClassReader(this.mixinBytes);
            classReader.accept(classNode, flags);
            return classNode;
        }

        protected void validateChanges(SubType type, List<ClassInfo> targetClasses) {
            type.createPreProcessor(this.classNode).prepare();
        }

        private void validateInner() {
            if (!this.classInfo.isProbablyStatic()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Inner class mixin must be declared static");
            }
        }

        private void validateRemappable(Class<Shadow> annotationClass, String name, AnnotationNode annotation) {
            if (annotation != null && Annotations.getValue(annotation, "remap", Boolean.TRUE).booleanValue()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Found a remappable @" + annotationClass.getSimpleName() + " annotation on " + name + " in " + this);
            }
        }

        byte[] getClassBytes() {
            return this.mixinBytes;
        }

        boolean isUnique() {
            return this.unique;
        }

        Set<String> getSyntheticInnerClasses() {
            return this.syntheticInnerClasses;
        }

        Set<String> getInterfaces() {
            return this.interfaces;
        }

        private void connect() {
            this.classNode = this.createClassNode(0);
        }

        private void complete() {
            this.classNode = null;
        }

        private void validateClassVersion() {
            if (this.classNode.version > MixinEnvironment.getCompatibilityLevel().classVersion()) {
                String helpText = ".";
                for (MixinEnvironment.CompatibilityLevel level : MixinEnvironment.CompatibilityLevel.values()) {
                    if (level.classVersion() < this.classNode.version) continue;
                    helpText = String.format(". Mixin requires compatibility level %s or above.", level.name());
                }
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, "Unsupported mixin class version " + this.classNode.version + helpText);
            }
        }

        State(byte[] mixinBytes, ClassInfo classInfo) {
            this.syntheticInnerClasses = new HashSet<String>();
            this.innerClasses = new HashSet<String>();
            this.mixinBytes = mixinBytes;
            this.connect();
            this.classInfo = classInfo != null ? classInfo : ClassInfo.fromClassNode(this.getClassNode());
        }

        void readImplementations(SubType type) {
            this.interfaces.addAll(this.classNode.interfaces);
            this.interfaces.addAll(type.getInterfaces());
            AnnotationNode implementsAnnotation = Annotations.getInvisible(this.classNode, Implements.class);
            if (implementsAnnotation == null) {
                return;
            }
            List interfaces = (List)Annotations.getValue(implementsAnnotation);
            if (interfaces == null) {
                return;
            }
            for (AnnotationNode interfaceNode : interfaces) {
                InterfaceInfo interfaceInfo = InterfaceInfo.fromAnnotation(MixinInfo.this, interfaceNode);
                this.softImplements.add(interfaceInfo);
                this.interfaces.add(interfaceInfo.getInternalName());
                if (this instanceof Reloaded) continue;
                this.classInfo.addInterface(interfaceInfo.getInternalName());
            }
        }
    }

    class MixinClassNode
    extends ClassNode {
        public final List<MixinMethodNode> mixinMethods;
        private static final NMSLException \u5c31\u662f\u8fd9\u6837 = new NMSLException("\u2614\u4df5\u2636\u4dc0\u4dd9\u4dc2\u4df1\u4de4\u4537\u26dd\u4dc3\u4def\ua680\ua648\u4df5\u2614\u4dec\u2646\u4dfd\u4df7\u4de9\u262b\u26e2\u2704\u26f2\u4de9\u4dd5\u4b0f\ua674\u4df0\u47ad\ua665\u4dd9\u3ea0\u26f5\u4deb\u4ddc\u4de1\u4df1\u4dc9\u4786\u2718\u26d8\u4dc5\u262a\u4dcf\u37e7\u4de9\u26bc");

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MixinMethodNode method = new MixinMethodNode(access, name, desc, signature, exceptions);
            this.methods.add(method);
            return method;
        }

        public MixinInfo getMixin() {
            return MixinInfo.this;
        }

        public MixinClassNode(int api) {
            super(api);
            this.mixinMethods = this.methods;
        }

        public MixinClassNode(MixinInfo mixin) {
            this(327680);
        }
    }

    class MixinMethodNode
    extends MethodNode {
        private final String originalName;
        private static final NMSLException \u5927\u574f\u86cb = new NMSLException("\u4dce\u26f3\u3e6a\ua655\u26ed\u4651\ua689\u4de3\u2763\u4de2\u443f\ua69d\u4dfe\u27b3\u3836\u2654\u26a3\u4de5\u4dc9\u47fa\u4dd4\u4de7\u4dfa\u4df3\u4dcb\u4dd8\u4dfc\u4df8\ua69e\ua69d\u4df4\u38d8\ua68d\u2695\u4df5\u2771\u4dfb\u2687\ua66a\u4dea\u4485\u2668\ua691\u2757");

        public AnnotationNode getVisibleAnnotation(Class<? extends Annotation> annotationClass) {
            return Annotations.getVisible(this, annotationClass);
        }

        public String toString() {
            return String.format("%s%s", this.originalName, this.desc);
        }

        public boolean isSurrogate() {
            return this.getVisibleAnnotation(Surrogate.class) != null;
        }

        public MixinMethodNode(int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.originalName = name;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public AnnotationNode getInjectorAnnotation() {
            return InjectionInfo.getInjectorAnnotation(MixinInfo.this, this);
        }

        public IMixinInfo getOwner() {
            return MixinInfo.this;
        }

        public boolean isInjector() {
            return this.getInjectorAnnotation() != null || this.isSurrogate();
        }

        public boolean isSynthetic() {
            return Bytecode.hasFlag(this, 4096);
        }
    }
}

