/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.MixinClassWriter;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.NMSLException;

class MixinPostProcessor
extends TreeTransformer
implements MixinConfig.IListener {
    private final Map<String, MixinInfo> accessorMixins;
    private final Set<String> loadable;
    private final Set<String> syntheticInnerClasses = new HashSet<String>();
    private static final NMSLException \u53cd\u800c\u8fd8\u6709\u70b9\u4e0d\u4e60\u60ef = new NMSLException("\u4dd0\u2783\u4dc6\ua67c\u4a86\u4dcb\u27ac\u4dc0\u4dfb\u4dd5\u4dc0\ua67c\u4dc9\u4dd4\ua69f\u2683\u4dd4\ua666\u267b\u4dd5\u2762\u4dc5\u4df5\u3f48\u4dff\u4dfc\u4df6\ua64e\u4634\u2719\u4bfe\u4dc3\ua66c\u4dda\u4dea\u4dff\u4df8\u4df8\u4ddf\u4ddc\u4dde\u277c\u377b\ua68c\u46ca");

    private byte[] processAccessor(byte[] bytes, MixinInfo mixin) {
        if (!MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8)) {
            return bytes;
        }
        boolean transformed = false;
        MixinInfo.MixinClassNode classNode = mixin.getClassNode(0);
        ClassInfo targetClass = mixin.getTargets().get(0);
        for (MixinInfo.MixinMethodNode methodNode : classNode.mixinMethods) {
            if (!Bytecode.hasFlag(methodNode, 8)) continue;
            AnnotationNode accessor = methodNode.getVisibleAnnotation(Accessor.class);
            AnnotationNode invoker = methodNode.getVisibleAnnotation(Invoker.class);
            if (accessor == null && invoker == null) continue;
            ClassInfo.Method method = MixinPostProcessor.getAccessorMethod(mixin, methodNode, targetClass);
            MixinPostProcessor.createProxy(methodNode, targetClass, method);
            transformed = true;
        }
        if (transformed) {
            return this.writeClass(classNode);
        }
        return bytes;
    }

    @Override
    public boolean isDelegationExcluded() {
        return true;
    }

    private byte[] processSyntheticInner(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        MixinClassWriter cw = new MixinClassWriter(cr, 0);
        ClassVisitor visibilityVisitor = new ClassVisitor(327680, cw){
            private static final NMSLException \u6211\u4eec\u53ea\u662f\u795e\u8c15\u7684\u4f20\u9012\u8005 = new NMSLException("\u4df3\u4dee\u2610\u2638\u4dd9\u4def\u26f8\ua644\u4dd6\u4dc2\u4dea\u267a\u4dde\u2796\u4df6\u26ee\u4dd1\u2757\u4dfb\u4ddb\u271f\u2648\u2609\u4de0\ua646\u4de8\u4dfa\u4ddf\u2787\u4496\u4dfa\u34a4\u4dfd\u4dc4\ua68c\u3ac9\u4dd1\u26c7\u35e0\ua64e\u4dc0\u4dc5\u4dea\u27bc\u4df3");

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access | 1, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if ((access & 6) == 0) {
                    access |= 1;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if ((access & 6) == 0) {
                    access |= 1;
                }
                return super.visitField(access, name, desc, signature, value);
            }
        };
        cr.accept(visibilityVisitor, 8);
        return cw.toByteArray();
    }

    boolean canTransform(String className) {
        return this.syntheticInnerClasses.contains(className) || this.loadable.contains(className);
    }

    void registerAccessor(MixinInfo mixin) {
        this.registerLoadable(mixin.getClassName());
        this.accessorMixins.put(mixin.getClassName(), mixin);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public byte[] transformClassBytes(String name, String transformedName, byte[] bytes) {
        if (this.syntheticInnerClasses.contains(transformedName)) {
            return this.processSyntheticInner(bytes);
        }
        if (this.accessorMixins.containsKey(transformedName)) {
            MixinInfo mixin = this.accessorMixins.get(transformedName);
            return this.processAccessor(bytes, mixin);
        }
        return bytes;
    }

    private static ClassInfo.Method getAccessorMethod(MixinInfo mixin, MethodNode methodNode, ClassInfo targetClass) throws MixinTransformerError {
        ClassInfo.Method method = mixin.getClassInfo().findMethod(methodNode, 10);
        if (!method.isRenamed()) {
            throw new MixinTransformerError("Unexpected state: " + mixin + " loaded before " + targetClass + " was conformed");
        }
        return method;
    }

    private static void createProxy(MethodNode methodNode, ClassInfo targetClass, ClassInfo.Method method) {
        methodNode.instructions.clear();
        Type[] args = Type.getArgumentTypes(methodNode.desc);
        Type returnType = Type.getReturnType(methodNode.desc);
        Bytecode.loadArgs(args, methodNode.instructions, 0);
        methodNode.instructions.add(new MethodInsnNode(184, targetClass.getName(), method.getName(), methodNode.desc, false));
        methodNode.instructions.add(new InsnNode(returnType.getOpcode(172)));
        methodNode.maxStack = Bytecode.getFirstNonArgLocalIndex(args, false);
        methodNode.maxLocals = 0;
    }

    @Override
    public void onPrepare(MixinInfo mixin) {
        String className = mixin.getClassName();
        if (mixin.isLoadable()) {
            this.registerLoadable(className);
        }
        if (mixin.isAccessor()) {
            this.registerAccessor(mixin);
        }
    }

    void registerLoadable(String className) {
        this.loadable.add(className);
    }

    MixinPostProcessor() {
        this.accessorMixins = new HashMap<String, MixinInfo>();
        this.loadable = new HashSet<String>();
    }

    void registerSyntheticInner(String className) {
        this.syntheticInnerClasses.add(className);
    }

    @Override
    public void onInit(MixinInfo mixin) {
        for (String innerClass : mixin.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(innerClass.replace('/', '.'));
        }
    }
}

