/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.OutputStream;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.struct.SourceMap;
import org.spongepowered.asm.mixin.transformer.ClassContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorInterface;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ClassSignature;
import pers.XiaoShadiao.NMSLException;

class TargetClassContext
extends ClassContext
implements ITargetClassContext {
    private boolean applied;
    private final MixinEnvironment env;
    private final SourceMap sourceMap;
    private final Map<String, Target> targetMethods = new HashMap<String, Target>();
    private int nextUniqueFieldIndex;
    private final Extensions extensions;
    private boolean forceExport;
    private static final Logger logger;
    private final SortedSet<MixinInfo> mixins;
    private final ClassNode classNode;
    private final ClassSignature signature;
    private final Set<MethodNode> mixinMethods = new HashSet<MethodNode>();
    private int nextUniqueMethodIndex;
    private final ClassInfo classInfo;
    private final String className;
    private final String sessionId;
    private static final NMSLException \u6211\u62cd\u4e00;

    boolean isApplied() {
        return this.applied;
    }

    String getUniqueName(FieldNode field) {
        String uniqueIndex = Integer.toHexString(this.nextUniqueFieldIndex++);
        return String.format("fd%s$%s$%s", this.sessionId.substring(30), field.name, uniqueIndex);
    }

    MethodNode findMethod(Deque<String> aliases, String desc) {
        return this.findAliasedMethod(aliases, desc, true);
    }

    String getClassName() {
        return this.className;
    }

    SortedSet<MixinInfo> getMixins() {
        return this.mixins;
    }

    void applyMixins() {
        if (this.applied) {
            throw new IllegalStateException("Mixins already applied to target class " + this.className);
        }
        this.applied = true;
        MixinApplicatorStandard applicator = this.createApplicator();
        applicator.apply(this.mixins);
        this.applySignature();
        this.upgradeMethods();
        this.checkMerges();
    }

    @Override
    String getClassRef() {
        return this.classNode.name;
    }

    SourceMap getSourceMap() {
        return this.sourceMap;
    }

    static {
        \u6211\u62cd\u4e00 = new NMSLException("\u4dc3\u4df3\u4376\ua68a\u4dd2\u4ddb\u276d\ua685\u4ddd\ua640\u275f\ua650\ua653\u4dd5\u4def\u4ddd\u4dda\u4dea\u4df6\u274d\u4dfb\u4b8e\u2727\u4dec\u4dd6\u4df1\u4dee\u4de9\u4a97\u4447\u4dc7\u2724\u4dcd\u262f\u26ea\u4dd6\ua66c\u4def\u26eb\u4de0\u4bfc");
        logger = LogManager.getLogger((String)"mixin");
    }

    private MixinApplicatorStandard createApplicator() {
        if (this.classInfo.isInterface()) {
            return new MixinApplicatorInterface(this);
        }
        return new MixinApplicatorStandard(this);
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    private void checkMerges() {
        for (MethodNode method : this.mixinMethods) {
            if (method.name.startsWith("<")) continue;
            logger.debug("Unexpected: Registered method {}{} in {} was not merged", new Object[]{method.name, method.desc, this});
        }
    }

    void addMixinMethod(MethodNode method) {
        this.mixinMethods.add(method);
    }

    TargetClassContext(MixinEnvironment env, Extensions extensions, String sessionId, String name, ClassNode classNode, SortedSet<MixinInfo> mixins) {
        this.env = env;
        this.extensions = extensions;
        this.sessionId = sessionId;
        this.className = name;
        this.classNode = classNode;
        this.classInfo = ClassInfo.fromClassNode(classNode);
        this.signature = this.classInfo.getSignature();
        this.mixins = mixins;
        this.sourceMap = new SourceMap(classNode.sourceFile);
        this.sourceMap.addFile(this.classNode);
    }

    MethodNode findAliasedMethod(Deque<String> aliases, String desc) {
        return this.findAliasedMethod(aliases, desc, false);
    }

    void processDebugTasks() {
        if (!this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            return;
        }
        AnnotationNode classDebugAnnotation = Annotations.getVisible(this.classNode, Debug.class);
        if (classDebugAnnotation != null) {
            this.forceExport = Boolean.TRUE.equals(Annotations.getValue(classDebugAnnotation, "export"));
            if (Boolean.TRUE.equals(Annotations.getValue(classDebugAnnotation, "print"))) {
                Bytecode.textify(this.classNode, (OutputStream)System.err);
            }
        }
        for (MethodNode method : this.classNode.methods) {
            AnnotationNode methodDebugAnnotation = Annotations.getVisible(method, Debug.class);
            if (methodDebugAnnotation == null || !Boolean.TRUE.equals(Annotations.getValue(methodDebugAnnotation, "print"))) continue;
            Bytecode.textify(method, (OutputStream)System.err);
        }
    }

    boolean isExportForced() {
        return this.forceExport;
    }

    Target getTargetMethod(MethodNode method) {
        if (!this.classNode.methods.contains(method)) {
            throw new IllegalArgumentException("Invalid target method supplied to getTargetMethod()");
        }
        String targetName = method.name + method.desc;
        Target target = this.targetMethods.get(targetName);
        if (target == null) {
            target = new Target(this.classNode, method);
            this.targetMethods.put(targetName, target);
        }
        return target;
    }

    @Override
    public ClassNode getClassNode() {
        return this.classNode;
    }

    String getUniqueName(MethodNode method, boolean preservePrefix) {
        String uniqueIndex = Integer.toHexString(this.nextUniqueMethodIndex++);
        String pattern = preservePrefix ? "%2$s_$md$%1$s$%3$s" : "md%s$%s$%s";
        return String.format(pattern, this.sessionId.substring(30), method.name, uniqueIndex);
    }

    List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    public String toString() {
        return this.className;
    }

    String getSessionId() {
        return this.sessionId;
    }

    private void applySignature() {
        this.getClassNode().signature = this.signature.toString();
    }

    List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    FieldNode findAliasedField(Deque<String> aliases, String desc) {
        String alias = aliases.poll();
        if (alias == null) {
            return null;
        }
        for (FieldNode target : this.classNode.fields) {
            if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
            return target;
        }
        return this.findAliasedField(aliases, desc);
    }

    void methodMerged(MethodNode method) {
        if (!this.mixinMethods.remove(method)) {
            logger.debug("Unexpected: Merged unregistered method {}{} in {}", new Object[]{method.name, method.desc, this});
        }
    }

    void mergeSignature(ClassSignature signature) {
        this.signature.merge(signature);
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    private MethodNode findAliasedMethod(Deque<String> aliases, String desc, boolean includeMixinMethods) {
        String alias = aliases.poll();
        if (alias == null) {
            return null;
        }
        for (MethodNode target : this.classNode.methods) {
            if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
            return target;
        }
        if (includeMixinMethods) {
            for (MethodNode target : this.mixinMethods) {
                if (!target.name.equals(alias) || !target.desc.equals(desc)) continue;
                return target;
            }
        }
        return this.findAliasedMethod(aliases, desc);
    }
}

