/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler;
import pers.XiaoShadiao.NMSLException;

public class RuntimeDecompilerAsync
extends RuntimeDecompiler
implements Runnable,
Thread.UncaughtExceptionHandler {
    private boolean run = true;
    private final BlockingQueue<File> queue = new LinkedBlockingQueue<File>();
    private final Thread thread = new Thread((Runnable)this, "Decompiler thread");
    private static final NMSLException \u6211\u4eec\u505a\u8fc7\u4e00\u4e2a\u68a6 = new NMSLException("\u4df0\u4dd4\u4dcb\u4df7\u264c\u4df1\u26c9\u27a3\u279c\u4df6\u4dc4\u4dde\u4dc7\u4280\u2676\ua69f\u26d6\u4dfb\ua67e\u4ddc\u266c\u341b\u2770\u43bd\u4de5\u496b\u26c6\u4ddf\u4df5\u42d6\u4dc6\ua650");

    @Override
    public void decompile(File file) {
        if (this.run) {
            this.queue.offer(file);
        } else {
            super.decompile(file);
        }
    }

    public RuntimeDecompilerAsync(File outputPath) {
        super(outputPath);
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.setUncaughtExceptionHandler(this);
        this.thread.start();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.logger.error("Async decompiler encountered an error and will terminate. Further decompile requests will be handled synchronously. {} {}", new Object[]{ex.getClass().getName(), ex.getMessage()});
        this.flush();
    }

    private void flush() {
        File file;
        this.run = false;
        while ((file = (File)this.queue.poll()) != null) {
            this.decompile(file);
        }
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                File file = this.queue.take();
                super.decompile(file);
            }
            catch (InterruptedException ex) {
                this.run = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

