/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import pers.XiaoShadiao.NMSLException;

public final class Extensions {
    private final Map<Class<? extends IExtension>, IExtension> extensionMap;
    private final List<IClassGenerator> generatorsView;
    private final List<IExtension> extensions = new ArrayList<IExtension>();
    private final Map<Class<? extends IClassGenerator>, IClassGenerator> generatorMap;
    private List<IExtension> activeExtensions;
    private final List<IClassGenerator> generators;
    private final MixinTransformer transformer;
    private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b89 = new NMSLException("\u4df7\u275f\u4ddb\u4def\u2700\ua669\ua661\u3ddc\u3957\u3d90\u4dc9\u2709\u26dc\u4df0\u4ddd\u4de3\ua64e\u4dfd\u4dca\u278c\u4df6\ua69b\u4df9\u4dc7\u2797\ua651\ua68f\u2762\ua656\u4ddc");

    public Extensions(MixinTransformer transformer) {
        this.extensionMap = new HashMap<Class<? extends IExtension>, IExtension>();
        this.generators = new ArrayList<IClassGenerator>();
        this.generatorsView = Collections.unmodifiableList(this.generators);
        this.generatorMap = new HashMap<Class<? extends IClassGenerator>, IClassGenerator>();
        this.activeExtensions = Collections.emptyList();
        this.transformer = transformer;
    }

    public void export(MixinEnvironment env, String name, boolean force, byte[] bytes) {
        for (IExtension extension : this.activeExtensions) {
            extension.export(env, name, force, bytes);
        }
    }

    public List<IExtension> getActiveExtensions() {
        return this.activeExtensions;
    }

    public MixinTransformer getTransformer() {
        return this.transformer;
    }

    private static <T> T lookup(Class<? extends T> extensionClass, Map<Class<? extends T>, T> map, List<T> list) {
        T extension = map.get(extensionClass);
        if (extension == null) {
            for (T classGenerator : list) {
                if (!extensionClass.isAssignableFrom(classGenerator.getClass())) continue;
                extension = classGenerator;
                break;
            }
            if (extension == null) {
                throw new IllegalArgumentException("Extension for <" + extensionClass.getName() + "> could not be found");
            }
            map.put(extensionClass, extension);
        }
        return extension;
    }

    public <T extends IExtension> T getExtension(Class<? extends IExtension> extensionClass) {
        return (T)Extensions.lookup(extensionClass, this.extensionMap, this.extensions);
    }

    public void select(MixinEnvironment environment) {
        ImmutableList.Builder activeExtensions = ImmutableList.builder();
        for (IExtension extension : this.extensions) {
            if (!extension.checkActive(environment)) continue;
            activeExtensions.add((Object)extension);
        }
        this.activeExtensions = activeExtensions.build();
    }

    public void add(IExtension extension) {
        this.extensions.add(extension);
        this.extensionMap.put(extension.getClass(), extension);
    }

    public List<IExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public void preApply(ITargetClassContext context) {
        for (IExtension extension : this.activeExtensions) {
            extension.preApply(context);
        }
    }

    public List<IClassGenerator> getGenerators() {
        return this.generatorsView;
    }

    public void postApply(ITargetClassContext context) {
        for (IExtension extension : this.activeExtensions) {
            extension.postApply(context);
        }
    }

    public void add(IClassGenerator generator) {
        this.generators.add(generator);
        this.generatorMap.put(generator.getClass(), generator);
    }

    public <T extends IClassGenerator> T getGenerator(Class<? extends IClassGenerator> generatorClass) {
        return (T)Extensions.lookup(generatorClass, this.generatorMap, this.generators);
    }
}

