/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.obfuscation.mapping.common;

import com.google.common.base.Objects;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import pers.XiaoShadiao.NMSLException;

public class MappingMethod
implements IMapping<MappingMethod> {
    private final String desc;
    private final String owner;
    private final String name;
    private static final NMSLException \u522e\u8d77\u5927\u98ce\u7684\u65f6\u5019 = new NMSLException("\u2783\u45b6\u26a1\u4dc6\ua65f\u26ec\u4dec\ua687\u4df5\u26c9\u4deb\u4dcc\u2713\u4dcf\u26f3\u2729\u4dcb\u2629\u4df2\u26ae\u26fc\u4dd6\u4def\ua67a\u49c5\ua684\u4de6\u4dcb\u4dcb\u4dd3\u3df7\u4de6\u4df0\u4dee\u4df3\u4de3\u3597");

    public MappingMethod(String fullyQualifiedName, String desc) {
        this(MappingMethod.getOwnerFromName(fullyQualifiedName), MappingMethod.getBaseName(fullyQualifiedName), desc);
    }

    @Override
    public MappingMethod getSuper() {
        return null;
    }

    public MappingMethod(String owner, String simpleName, String desc) {
        this.owner = owner;
        this.name = simpleName;
        this.desc = desc;
    }

    public String toString() {
        String desc = this.getDesc();
        return String.format("%s%s%s", this.getName(), desc != null ? " " : "", desc != null ? desc : "");
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public MappingMethod addPrefix(String prefix) {
        String simpleName = this.getSimpleName();
        if (simpleName == null || simpleName.startsWith(prefix)) {
            return this;
        }
        return new MappingMethod(this.getOwner(), prefix + simpleName, this.getDesc());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getDesc()});
    }

    @Override
    public String serialise() {
        return this.toString();
    }

    @Override
    public MappingMethod remap(String newName) {
        return new MappingMethod(this.getOwner(), newName, this.getDesc());
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    private static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        return pos > -1 ? name.substring(pos + 1) : name;
    }

    @Override
    public MappingMethod transform(String newDesc) {
        return new MappingMethod(this.getOwner(), this.getSimpleName(), newDesc);
    }

    @Override
    public MappingMethod move(String newOwner) {
        return new MappingMethod(newOwner, this.getSimpleName(), this.getDesc());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MappingMethod) {
            return Objects.equal((Object)this.name, (Object)((MappingMethod)obj).name) && Objects.equal((Object)this.desc, (Object)((MappingMethod)obj).desc);
        }
        return false;
    }

    @Override
    public IMapping.Type getType() {
        return IMapping.Type.METHOD;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return null;
        }
        return (this.owner != null ? this.owner + "/" : "") + this.name;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private static String getOwnerFromName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        return pos > -1 ? name.substring(0, pos) : null;
    }

    @Override
    public MappingMethod copy() {
        return new MappingMethod(this.getOwner(), this.getSimpleName(), this.getDesc());
    }
}

