/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.NMSLException;

public final class MixinService {
    private final Set<String> bootedServices = new HashSet<String>();
    private IMixinService service = null;
    private static MixinService instance;
    private ServiceLoader<IMixinService> serviceLoader;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private static final Logger logger;
    private static final NMSLException \u7f07\u5b81;

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    private MixinService() {
        this.runBootServices();
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    public static void boot() {
        MixinService.getInstance();
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (this.bootedServices.contains(service.getClass().getName())) {
                    logger.debug("MixinService [{}] was successfully booted in {}", new Object[]{service.getName(), this.getClass().getClassLoader()});
                }
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }

    static {
        \u7f07\u5b81 = new NMSLException("\u4df1\u262d\u4df8\ua665\u2709\u4df2\u4dfa\u473b\u27b3\ua641\ua681\u4de4\ua682\u4df8\u4df3\u2767\u4deb\u4deb\u27a9\ua654\u4de9\u4dc5\u27b4\u4dd9\u4dd6\u4de8\u4dcc\u4de1\u4dc1\u2686\u2736\u4a3e");
        logger = LogManager.getLogger((String)"mixin");
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap bootService : this.bootstrapServiceLoader) {
            try {
                bootService.bootstrap();
                this.bootedServices.add(bootService.getServiceClassName());
            }
            catch (Throwable th) {
                logger.catching(th);
            }
        }
    }
}

