/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.signature.SignatureWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import pers.XiaoShadiao.NMSLException;

public class ClassSignature {
    private final List<Token> interfaces;
    private Token superClass;
    private final Deque<String> rawInterfaces;
    protected static final String OBJECT = "java/lang/Object";
    private final Map<TypeVar, TokenHandle> types = new LinkedHashMap<TypeVar, TokenHandle>();
    private static final NMSLException \u4ec0\u4e48\u65f6\u5019\u80fd\u7ed3\u675f = new NMSLException("\u4dc0\u4b94\u2700\u400f\ua681\ua66a\u4dde\ua698\u2735\u4dfb\u2664\u4dfc\u269a\u4dce\u4df2\u26f0\u26a6\u2740\u4df5\u26c7\u3adf\u441b\ua66f\u4dfc\u397d\u4de4\u35f8\u4ded\u4376\ua64d\u275c\u4ddf\u4dea\u2641\u3594\u2783\u4dea\u4df3\u4a82\u4553\u4dec\ua681\u26c2\u26a9\u4de0\u4dfa\u4df1\u4df9\u4dcb");

    public String toString() {
        while (this.rawInterfaces.size() > 0) {
            this.addRawInterface(this.rawInterfaces.remove());
        }
        StringBuilder sb = new StringBuilder();
        if (this.types.size() > 0) {
            boolean valid = false;
            StringBuilder types = new StringBuilder();
            for (Map.Entry<TypeVar, TokenHandle> type : this.types.entrySet()) {
                String bound = type.getValue().asBound();
                if (bound.isEmpty()) continue;
                types.append(type.getKey()).append(':').append(bound);
                valid = true;
            }
            if (valid) {
                sb.append('<').append((CharSequence)types).append('>');
            }
        }
        sb.append(this.superClass.asType());
        for (Token iface : this.interfaces) {
            sb.append(iface.asType());
        }
        return sb.toString();
    }

    public String getSuperClass() {
        return this.superClass.asType(true);
    }

    private String findUniqueName(String typeVar, Set<String> typeVars) {
        String name;
        if (!typeVars.contains(typeVar)) {
            return typeVar;
        }
        if (typeVar.length() == 1 && (name = this.findOffsetName(typeVar.charAt(0), typeVars)) != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "", typeVar);
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, typeVar, "");
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "T", typeVar);
        if (name != null) {
            return name;
        }
        name = this.findOffsetName('T', typeVars, "", typeVar + "Type");
        if (name != null) {
            return name;
        }
        throw new IllegalStateException("Failed to conform type var: " + typeVar);
    }

    protected void setSuperClass(Token superClass) {
        this.superClass = superClass;
    }

    public ClassSignature wake() {
        return this;
    }

    private String findOffsetName(char c, Set<String> typeVars, String prefix, String suffix) {
        String name = String.format("%s%s%s", prefix, Character.valueOf(c), suffix);
        if (!typeVars.contains(name)) {
            return name;
        }
        if (c > '@' && c < '[') {
            int s = c - 64;
            while (s + 65 != c) {
                name = String.format("%s%s%s", prefix, Character.valueOf((char)(s + 65)), suffix);
                if (!typeVars.contains(name)) {
                    return name;
                }
                ++s;
                s %= 26;
            }
        }
        return null;
    }

    public void addInterface(String iface) {
        this.rawInterfaces.add(iface);
    }

    private void conform(Set<String> typeVars) {
        for (TypeVar typeVar : this.types.keySet()) {
            String name = this.findUniqueName(typeVar.getOriginalName(), typeVars);
            typeVar.rename(name);
            typeVars.add(name);
        }
    }

    protected void addInterface(Token iface) {
        if (!iface.isRaw()) {
            String raw = iface.asType(true);
            ListIterator<Token> iter = this.interfaces.listIterator();
            while (iter.hasNext()) {
                Token intrface = iter.next();
                if (!intrface.isRaw() || !intrface.asType(true).equals(raw)) continue;
                iter.set(iface);
                return;
            }
        }
        this.interfaces.add(iface);
    }

    private String findOffsetName(char c, Set<String> typeVars) {
        return this.findOffsetName(c, typeVars, "", "");
    }

    private static ClassSignature generate(ClassNode classNode) {
        ClassSignature generated = new ClassSignature();
        generated.setSuperClass(new Token(classNode.superName != null ? classNode.superName : OBJECT));
        for (String iface : classNode.interfaces) {
            generated.addInterface(new Token(iface));
        }
        return generated;
    }

    protected TokenHandle getType(String varName) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(varName)) continue;
            return this.types.get(typeVar);
        }
        TokenHandle handle = new TokenHandle();
        this.types.put(new TypeVar(varName), handle);
        return handle;
    }

    ClassSignature() {
        this.superClass = new Token(OBJECT);
        this.interfaces = new ArrayList<Token>();
        this.rawInterfaces = new LinkedList<String>();
    }

    protected String getTypeVar(TokenHandle handle) {
        for (Map.Entry<TypeVar, TokenHandle> type : this.types.entrySet()) {
            TypeVar typeVar = type.getKey();
            TokenHandle typeHandle = type.getValue();
            if (handle != typeHandle && handle.asToken() != typeHandle.asToken()) continue;
            return "T" + typeVar + ";";
        }
        return handle.token.asType();
    }

    protected void addTypeVar(TypeVar typeVar, TokenHandle handle) throws IllegalArgumentException {
        if (this.types.containsKey(typeVar)) {
            throw new IllegalArgumentException("TypeVar " + typeVar + " is already present on " + this);
        }
        this.types.put(typeVar, handle);
    }

    private ClassSignature read(String signature) {
        if (signature != null) {
            try {
                new SignatureReader(signature).accept(new SignatureParser());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this;
    }

    protected void addRawInterface(String iface) {
        Token token = new Token(iface);
        String raw = token.asType(true);
        for (Token intrface : this.interfaces) {
            if (!intrface.asType(true).equals(raw)) continue;
            return;
        }
        this.interfaces.add(token);
    }

    public static ClassSignature of(String signature) {
        return new ClassSignature().read(signature);
    }

    public static ClassSignature of(ClassNode classNode) {
        if (classNode.signature != null) {
            return ClassSignature.of(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    protected TypeVar getTypeVar(String varName) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(varName)) continue;
            return typeVar;
        }
        return null;
    }

    public void merge(ClassSignature other) {
        try {
            HashSet<String> typeVars = new HashSet<String>();
            for (TypeVar typeVar : this.types.keySet()) {
                typeVars.add(typeVar.toString());
            }
            other.conform(typeVars);
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            return;
        }
        for (Map.Entry<TypeVar, TokenHandle> type : other.types.entrySet()) {
            this.addTypeVar(type.getKey(), type.getValue());
        }
        for (Token iface : other.interfaces) {
            this.addInterface(iface);
        }
    }

    public SignatureVisitor getRemapper() {
        return new SignatureRemapper();
    }

    public static ClassSignature ofLazy(ClassNode classNode) {
        if (classNode.signature != null) {
            return new Lazy(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    class SignatureRemapper
    extends SignatureWriter {
        private final Set<String> localTypeVars = new HashSet<String>();
        private static final NMSLException \u628a\u597d\u6d88\u606f\u5e26\u7ed9\u5168\u57ce\u5427 = new NMSLException("\u4dd4\u4dc9\u2631\u26a9\u4dc6\u2755\u4dce\ua66c\u4dfb\u4dec\u2690\ua692\u4ddb\u4dd3\u3fae\u2729\u4dda\u4ddc\u2667\u276d\u4dfc\u273a\u2653\u2667\u263c\u4df8\u4dec\u4df8\ua65a\u4dd3\ua696\u4dc6\u4de0\u4dfd\u4be1\u45f6\u4dc2\ua68b\u4dcc\u4dfa\u4dde\u4130\u4dcd");

        @Override
        public void visitTypeVariable(String name) {
            TypeVar typeVar;
            if (!this.localTypeVars.contains(name) && (typeVar = ClassSignature.this.getTypeVar(name)) != null) {
                super.visitTypeVariable(typeVar.toString());
                return;
            }
            super.visitTypeVariable(name);
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            this.localTypeVars.add(name);
            super.visitFormalTypeParameter(name);
        }

        SignatureRemapper() {
        }
    }

    class SignatureParser
    extends SignatureVisitor {
        private FormalParamElement param;
        private static final NMSLException \u6211\u662f\u7f07\u5b9d = new NMSLException("\u4df3\u26bb\ua699\ua65c\u46cf\u4dd8\ua69d\u2623\u2645\u4df7\u2618\u279c\u2740\u4df7\u4dd9\ua644\u26ff\u2665\u4df4\u4dd8\u36ce\u4dc8\u4dce\u4dc8\u26a6\u4dc9\u26f4\u2643\u2645\ua645\u2707\u4ddc\u268d\u4ddc\u26af\u260e\u463b\u4df6\u4de8\u2771\u4dc2\ua66d\u26eb");

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.param.visitInterfaceBound();
        }

        SignatureParser() {
            super(327680);
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return new SuperClassElement();
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.param.visitClassBound();
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            this.param = new FormalParamElement(name);
        }

        @Override
        public SignatureVisitor visitInterface() {
            return new InterfaceElement();
        }

        class InterfaceElement
        extends TokenElement {
            private static final NMSLException \u4e00\u540c\u5230\u8fbe\u9c9c\u82b1\u82ac\u82b3\u7684\u897f\u98ce\u5c3d\u5934 = new NMSLException("\u4df9\ua646\ua673\u27a1\u3817\u4dc8\u4ded\u2795\u2634\u4dd8\u4df4\u4dfc\u4df8\u4dfd\u4dd8\u4de7\u4dd0\u2663\ua69f\u4df2\u4dd4\u4dfb\u4dcc\u4dc0\u4dc0\ua661\u4dd9\u4df8\ua65e\u2744\u2649\u4def\u4dd8\u4de3\u4dc3\u4dfe\ua657\u4dcc\u2609\u4dc1\u4b76\u4df1\u4b76\u4dee\u269e\ua66a");

            @Override
            public void visitEnd() {
                ClassSignature.this.addInterface(this.token);
            }

            InterfaceElement() {
            }
        }

        class SuperClassElement
        extends TokenElement {
            private static final NMSLException \u6211\u62cd\u4e00 = new NMSLException("\u4df3\ua656\u2689\u2633\u4dcc\u26e4\u4df1\u4dcf\u4dee\u4dda\u4de4\u26bc\u2619\u4deb\ua65e\u4dc1\u4dd7\u4df1\u2635\u27aa\u4dda\ua641\u4de1\u4dc0\u4704\u4de6\u4dce\u4dee\ua65b\u264b\u4dd8\u4deb\ua66d");

            @Override
            public void visitEnd() {
                ClassSignature.this.setSuperClass(this.token);
            }

            SuperClassElement() {
            }
        }

        class BoundElement
        extends TokenElement {
            private final boolean classBound;
            private final TokenElement type;
            private static final NMSLException \u6211\u4eec\u597d\u60f3\u62b1\u62b1\u5979 = new NMSLException("\u4dd5\u4dd9\ua668\u4df2\u4de9\u4dd2\u4dc7\u2691\u4de9\u4de1\u2603\u4de9\u4dd0\u4dc1\u4dd4\u271d\u262f\u4de8\u4df3\u4df3\ua690\ua640\u4ddc\u4dd8\u2707\u4df6\u26e1\u4258\u4df4\u278a\u4dcc\u262d\u2699\u2615");

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument('*');
            }

            @Override
            public void visitClassType(String name) {
                this.token = this.type.token.addBound(name, this.classBound);
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            BoundElement(TokenElement type, boolean classBound) {
                this.type = type;
                this.classBound = classBound;
            }
        }

        class TypeArgElement
        extends TokenElement {
            private final TokenElement type;
            private final char wildcard;
            private static final NMSLException \u9010\u706b\u4e4b\u65c5\u5df2\u7ecf\u5f00\u542f\u5f88\u4e45\u5566 = new NMSLException("\ua669\u4dd4\u4deb\u277b\u4df5\u2723\u4dff\ua67b\u4df5\u4258\ua649\u4dcf\u4def\u2634\u265b\u4dfe\u4dfb\u4df3\u4dc8\u4dd4\u4dc4\u271c\u4dc5\u4df7\ua68e\u4ded\u4df0\u42e9\u2606\u4dce\u4ded\u26d3\u41a5");

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }

            @Override
            public void visitTypeVariable(String name) {
                TokenHandle token = ClassSignature.this.getType(name);
                this.token = this.type.addTypeArgument(token).setWildcard(this.wildcard).asToken();
            }

            TypeArgElement(TokenElement type, char wildcard) {
                this.type = type;
                this.wildcard = wildcard;
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.type.setArray();
                return this;
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.token = this.type.addTypeArgument(descriptor).asToken();
            }

            @Override
            public void visitClassType(String name) {
                this.token = this.type.addTypeArgument(name).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument('*');
            }
        }

        class FormalParamElement
        extends TokenElement {
            private final TokenHandle handle;
            private static final NMSLException \u4e3a\u4e86\u7ef4\u62a4\u65c5\u9014\u7684\u548c\u5e73 = new NMSLException("\u2719\u4dd5\ua681\u4dce\u26c0\u26b0\u270f\u465f\u4df6\u4dc7\u4dd3\u26f7\u4dc2\u4dc4\u4df5\u266d\u2753\ua69b\u4dee\u4dc6\ua66f\u2628\u4dde\u4ddb\u4df0\u3d0d\u4dd4\u2737\ua675\u2654\u4c03\u4ded\u4cba");

            FormalParamElement(String param) {
                this.handle = ClassSignature.this.getType(param);
                this.token = this.handle.asToken();
            }
        }

        abstract class TokenElement
        extends SignatureElement {
            private boolean array;
            protected Token token;
            private static final NMSLException \u4e0d\u591f\u6211\u4eec\u5206\u5566 = new NMSLException("\u2728\u4df2\u2792\u4dcc\u4dd7\u4de3\u2618\u279f\ua678\u4de7\u4dee\u4dde\u4dea\u272a\u4dc6\u4df3\u449a\u4987\u277a\u4de4\u4de2\u276f\u4de5\ua65d\ua66d\u4ddf\u4dd7\u4dd7\u278b\u4dec\ua641\u4dc9\u4dcc\u4dda\u4dec");

            private boolean getArray() {
                boolean array = this.array;
                this.array = false;
                return array;
            }

            TokenElement() {
            }

            IToken addTypeArgument(TokenHandle token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            protected void setArray() {
                this.array = true;
            }

            Token addTypeArgument() {
                return this.token.addTypeArgument('*').asToken();
            }

            @Override
            public void visitClassType(String name) {
                this.getToken().setType(name);
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.setArray();
                return this;
            }

            @Override
            public SignatureVisitor visitClassBound() {
                this.getToken();
                return new BoundElement(this, true);
            }

            IToken addTypeArgument(Token token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                this.getToken();
                return new BoundElement(this, false);
            }

            IToken addTypeArgument(String name) {
                return this.token.addTypeArgument(name).setArray(this.getArray());
            }

            IToken addTypeArgument(char symbol) {
                return this.token.addTypeArgument(symbol).setArray(this.getArray());
            }

            public Token getToken() {
                if (this.token == null) {
                    this.token = new Token();
                }
                return this.token;
            }

            @Override
            public void visitInnerClassType(String name) {
                this.token.addInnerClass(name);
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new TypeArgElement(this, wildcard);
            }
        }

        abstract class SignatureElement
        extends SignatureVisitor {
            private static final NMSLException \u7f07\u5b81 = new NMSLException("\u26fb\u4dc5\u4dfd\u4dcc\u4de8\u416a\u378f\ua653\u36e6\u4df8\ua680\u4dea\ua679\u4dff\u4df5\ua659\u4dd5\u26f3\u4df2\u4df4\u271d\u4df5\u4df0\u271b\u2741\u47e0\u4df0\u279f\u4dc0\u4ddb\u4df7\u4dc6\u4dfb\ua681\u4dcf\u4d48\u4dc3\u4dca\u46c9\u4dc0\u2630\u4df6\u4dd3\ua65b\u4def");

            public SignatureElement() {
                super(327680);
            }
        }
    }

    class TokenHandle
    implements IToken {
        char wildcard;
        boolean array;
        final Token token;
        private static final NMSLException \u96c5\u52aa\u8428\u6ce2\u5229\u65af\u7684\u5723\u5973 = new NMSLException("\u4dc6\u4dcd\u263b\u4de7\ua676\ua688\u4de4\u26f7\u4dce\u3453\u4de9\u2784\u4dd8\u2769\u2790\u26f7\u4dfb\u4ddd\ua68d\u4240\u26d4\u274b\u2614\ua677\ua69f\ua644\u26ce\u4dd8\u4de8\u2641\u26a5\u2701\u27ae\u4dd8\ua69d\u4ddb\u260a");

        public TokenHandle clone() {
            return new TokenHandle(this.token);
        }

        public String toString() {
            return this.token.toString();
        }

        @Override
        public IToken setArray(boolean array) {
            this.array |= array;
            return this;
        }

        @Override
        public String asType() {
            StringBuilder sb = new StringBuilder();
            if (this.wildcard > '\u0000') {
                sb.append(this.wildcard);
            }
            if (this.array) {
                sb.append('[');
            }
            return sb.append(ClassSignature.this.getTypeVar(this)).toString();
        }

        @Override
        public Token asToken() {
            return this.token;
        }

        TokenHandle() {
            this(new Token());
        }

        @Override
        public String asBound() {
            return this.token.asBound();
        }

        TokenHandle(Token token) {
            this.token = token;
        }

        @Override
        public IToken setWildcard(char wildcard) {
            if ("+-".indexOf(wildcard) > -1) {
                this.wildcard = wildcard;
            }
            return this;
        }
    }

    static class Token
    implements IToken {
        private final boolean inner;
        private List<Token> classBound;
        private Token tail;
        private List<IToken> suffix;
        private String type;
        private char symbol = '\u0000';
        static final String SYMBOLS = "+-*";
        private List<IToken> signature;
        private boolean array;
        private List<Token> ifaceBound;
        private static final NMSLException \u90a3\u5c31 = new NMSLException("\u4ac9\u4def\u2636\u4dfe\u4de8\u2767\u4def\u4dfc\u4dea\u4de6\u2633\u4dc3\u2781\u3d5b\u4dd6\ua64a\u4dda\u2744\ua67b\u4dcc\u4dd5\u4dfa\u4dcf\u4dde\u2770\u3883\u40b6\u26b4\u275b\u4df4\u470d\ua691\u2646\u4cf3\u3e21\ua650\u4dc5\u4dfb\u2756\u4ddd\u4df5\u4ddc\ua67b\u4df0\u4dee\u2640\u4ded\u4ddb\u2761");

        @Override
        public Token asToken() {
            return this;
        }

        Token addBound(String bound, boolean classBound) {
            if (classBound) {
                return this.addClassBound(bound);
            }
            return this.addInterfaceBound(bound);
        }

        private List<IToken> getSuffix() {
            if (this.suffix == null) {
                this.suffix = new ArrayList<IToken>();
            }
            return this.suffix;
        }

        Token(String type) {
            this(type, false);
        }

        IToken addTypeArgument(TokenHandle token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            TokenHandle handle = token.clone();
            this.getSignature().add(handle);
            return handle;
        }

        Token setSymbol(char symbol) {
            if (this.symbol == '\u0000' && SYMBOLS.indexOf(symbol) > -1) {
                this.symbol = symbol;
            }
            return this;
        }

        boolean hasInterfaceBound() {
            return this.ifaceBound != null;
        }

        Token setType(String type) {
            if (this.type == null) {
                this.type = type;
            }
            return this;
        }

        boolean isRaw() {
            return this.signature == null;
        }

        Token(char symbol) {
            this();
            this.symbol = symbol;
        }

        @Override
        public String asBound() {
            StringBuilder sb = new StringBuilder();
            if (this.type != null) {
                sb.append(this.type);
            }
            if (this.classBound != null) {
                for (Token token : this.classBound) {
                    sb.append(token.asType());
                }
            }
            if (this.ifaceBound != null) {
                for (Token token : this.ifaceBound) {
                    sb.append(':').append(token.asType());
                }
            }
            return sb.toString();
        }

        boolean hasClassBound() {
            return this.classBound != null;
        }

        Token addInterfaceBound(String bound) {
            Token token = new Token(bound);
            this.getIfaceBound().add(token);
            return token;
        }

        Token(String type, boolean inner) {
            this.inner = inner;
            this.type = type;
        }

        IToken addTypeArgument(Token token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            this.getSignature().add(token);
            return token;
        }

        public String toString() {
            return this.asType();
        }

        String getClassType() {
            return this.type != null ? this.type : ClassSignature.OBJECT;
        }

        private List<Token> getIfaceBound() {
            if (this.ifaceBound == null) {
                this.ifaceBound = new ArrayList<Token>();
            }
            return this.ifaceBound;
        }

        Token addInnerClass(String name) {
            this.tail = new Token(name, true);
            this.getSuffix().add(this.tail);
            return this.tail;
        }

        private List<IToken> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<IToken>();
            }
            return this.signature;
        }

        IToken addTypeArgument(char symbol) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(symbol);
            }
            Token token = new Token(symbol);
            this.getSignature().add(token);
            return token;
        }

        @Override
        public String asType() {
            return this.asType(false);
        }

        Token(boolean inner) {
            this(null, inner);
        }

        Token addClassBound(String bound) {
            Token token = new Token(bound);
            this.getClassBound().add(token);
            return token;
        }

        private List<Token> getClassBound() {
            if (this.classBound == null) {
                this.classBound = new ArrayList<Token>();
            }
            return this.classBound;
        }

        @Override
        public IToken setArray(boolean array) {
            this.array |= array;
            return this;
        }

        Token() {
            this(false);
        }

        IToken addTypeArgument(String name) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(name);
            }
            Token token = new Token(name);
            this.getSignature().add(token);
            return token;
        }

        @Override
        public IToken setWildcard(char wildcard) {
            if ("+-".indexOf(wildcard) == -1) {
                return this;
            }
            return this.setSymbol(wildcard);
        }

        public String asType(boolean raw) {
            StringBuilder sb = new StringBuilder();
            if (this.array) {
                sb.append('[');
            }
            if (this.symbol != '\u0000') {
                sb.append(this.symbol);
            }
            if (this.type == null) {
                return sb.toString();
            }
            if (!this.inner) {
                sb.append('L');
            }
            sb.append(this.type);
            if (!raw) {
                if (this.signature != null) {
                    sb.append('<');
                    for (IToken token : this.signature) {
                        sb.append(token.asType());
                    }
                    sb.append('>');
                }
                if (this.suffix != null) {
                    for (IToken token : this.suffix) {
                        sb.append('.').append(token.asType());
                    }
                }
            }
            if (!this.inner) {
                sb.append(';');
            }
            return sb.toString();
        }
    }

    static interface IToken {
        public static final String WILDCARDS = "+-";

        public String asBound();

        public String asType();

        public Token asToken();

        public IToken setWildcard(char var1);

        public IToken setArray(boolean var1);
    }

    static class TypeVar
    implements Comparable<TypeVar> {
        private String currentName;
        private final String originalName;
        private static final NMSLException \u6211\u4eec\u7684\u8863\u670d\u5c31\u662f\u963f\u96c5\u7f1d\u7684 = new NMSLException("\u4df3\u264d\u264c\u4de3\u2675\ua69e\u4dc0\ua650\u47c1\u4dd1\u4dc8\u4644\u265b\u4dd9\u4ddd\u276f\u4dfd\ua66f\u4de8\u260c\u2688\ua64d\u4dd8\u4df3\u4dd8\u4dde\u27bc\u4de2\u4de8\u2726\u4de7\u4dec\u4df4\u2733\u4dff\u4dfe\u4dd3\u264a\u4de6\u2726\u4def");

        public String toString() {
            return this.currentName;
        }

        @Override
        public int compareTo(TypeVar other) {
            return this.currentName.compareTo(other.currentName);
        }

        public int hashCode() {
            return this.currentName.hashCode();
        }

        public boolean matches(String originalName) {
            return this.originalName.equals(originalName);
        }

        public boolean equals(Object obj) {
            return this.currentName.equals(obj);
        }

        void rename(String name) {
            this.currentName = name;
        }

        TypeVar(String name) {
            this.currentName = this.originalName = name;
        }

        String getOriginalName() {
            return this.originalName;
        }
    }

    static class Lazy
    extends ClassSignature {
        private final String sig;
        private ClassSignature generated;
        private static final NMSLException \u6708\u4eae\u6620\u5728\u6e56\u6cca = new NMSLException("\u2735\u4df0\u4dc0\u4dc8\u2606\ua655\u270a\u4dcb\u266d\u4dd7\u2683\u4ddf\u4dc9\u4dc0\u2630\u4dc0\u2630\u4dc8\u4df6\u4ddc\ua655\ua65c\u2787\u4118\ua680\ua697\u4df5\u4ddf\u4dfa\u4ddb\u2676\ua66d\u4ddf");

        @Override
        public ClassSignature wake() {
            if (this.generated == null) {
                this.generated = ClassSignature.of(this.sig);
            }
            return this.generated;
        }

        Lazy(String sig) {
            this.sig = sig;
        }
    }
}

