/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.NMSLException;

public final class ConstraintParser {
    private static final NMSLException \u5982\u679c\u6ca1\u6709\u4e07\u5343\u82f1\u96c4\u4e0e\u6c11\u4f17\u7684\u52aa\u529b = new NMSLException("\u4dcd\u4dd7\u4ddc\ua643\u274a\u4df1\u4de5\u4def\u273e\u26cf\ua640\ua684\u4dd7\ua69c\u2640\u4dd7\ua656\ua687\ua64e\u4dee\u4de7\u2747\u4ddb\u4dcc\u4dd0\u4dc1\u265e\u4df4\u4df1\u26c7");

    private ConstraintParser() {
    }

    public static Constraint parse(AnnotationNode annotation) {
        String constraints = Annotations.getValue(annotation, "constraints", "");
        return ConstraintParser.parse(constraints);
    }

    public static Constraint parse(String expr) {
        if (expr == null || expr.length() == 0) {
            return Constraint.NONE;
        }
        String[] exprs = expr.replaceAll("\\s", "").toUpperCase().split(";");
        Constraint head = null;
        for (String subExpr : exprs) {
            Constraint next = new Constraint(subExpr);
            if (head == null) {
                head = next;
                continue;
            }
            head.append(next);
        }
        return head != null ? head : Constraint.NONE;
    }

    public static class Constraint {
        private int min = Integer.MIN_VALUE;
        private String token;
        private final String expr;
        private Constraint next;
        public static final Constraint NONE;
        private static final Pattern pattern;
        private int max = Integer.MAX_VALUE;
        private String[] constraint;
        private static final NMSLException \u6674\u5929;

        private boolean has(int index) {
            return this.constraint[index] != null;
        }

        private String elem(int index) {
            return this.constraint[index];
        }

        public int getMax() {
            return this.max;
        }

        private int val(int index) {
            return this.constraint[index] != null ? Integer.parseInt(this.constraint[index]) : 0;
        }

        public int getMin() {
            return this.min;
        }

        public String toString() {
            return String.format("Constraint(%s [%d-%d])", this.token, this.min, this.max);
        }

        public String getRangeHumanReadable() {
            if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
                return "ANY VALUE";
            }
            if (this.min == Integer.MIN_VALUE) {
                return String.format("less than or equal to %d", this.max);
            }
            if (this.max == Integer.MAX_VALUE) {
                return String.format("greater than or equal to %d", this.min);
            }
            if (this.min == this.max) {
                return String.format("%d", this.min);
            }
            return String.format("between %d and %d", this.min, this.max);
        }

        public String getToken() {
            return this.token;
        }

        private Constraint() {
            this.expr = null;
            this.token = "*";
            this.constraint = new String[0];
        }

        Constraint(String expr) {
            this.expr = expr;
            Matcher matcher = pattern.matcher(expr);
            if (!matcher.matches()) {
                throw new InvalidConstraintException("Constraint syntax was invalid parsing: " + this.expr);
            }
            this.token = matcher.group(1);
            this.constraint = new String[]{matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8)};
            this.parse();
        }

        public void check(ITokenProvider environment) throws ConstraintViolationException {
            if (this != NONE) {
                Integer value = environment.getToken(this.token);
                if (value == null) {
                    throw new ConstraintViolationException("The token '" + this.token + "' could not be resolved in " + environment, this);
                }
                if (value < this.min) {
                    throw new ConstraintViolationException("Token '" + this.token + "' has a value (" + value + ") which is less than the minimum value " + this.min + " in " + environment, this, (int)value);
                }
                if (value > this.max) {
                    throw new ConstraintViolationException("Token '" + this.token + "' has a value (" + value + ") which is greater than the maximum value " + this.max + " in " + environment, this, (int)value);
                }
            }
            if (this.next != null) {
                this.next.check(environment);
            }
        }

        private void parse() {
            if (!this.has(1)) {
                return;
            }
            this.min = this.val(1);
            this.max = this.min++;
            boolean hasModifier = this.has(0);
            if (this.has(4)) {
                if (hasModifier) {
                    throw new InvalidConstraintException("Unexpected modifier '" + this.elem(0) + "' in " + this.expr + " parsing range");
                }
                this.max = this.val(4);
                if (this.max < this.min) {
                    throw new InvalidConstraintException("Invalid range specified '" + this.max + "' is less than " + this.min + " in " + this.expr);
                }
                return;
            }
            if (this.has(6)) {
                if (hasModifier) {
                    throw new InvalidConstraintException("Unexpected modifier '" + this.elem(0) + "' in " + this.expr + " parsing range");
                }
                this.max = this.min + this.val(6);
                return;
            }
            if (hasModifier) {
                if (this.has(3)) {
                    throw new InvalidConstraintException("Unexpected trailing modifier '" + this.elem(3) + "' in " + this.expr);
                }
                String leading = this.elem(0);
                if (">".equals(leading)) {
                    this.max = Integer.MAX_VALUE;
                } else if (">=".equals(leading)) {
                    this.max = Integer.MAX_VALUE;
                } else if ("<".equals(leading)) {
                    this.max = --this.min;
                    this.min = Integer.MIN_VALUE;
                } else if ("<=".equals(leading)) {
                    this.max = this.min;
                    this.min = Integer.MIN_VALUE;
                }
            } else if (this.has(2)) {
                String trailing = this.elem(2);
                if ("<".equals(trailing)) {
                    this.max = this.min;
                    this.min = Integer.MIN_VALUE;
                } else {
                    this.max = Integer.MAX_VALUE;
                }
            }
        }

        static {
            \u6674\u5929 = new NMSLException("\u4df9\u4add\u4dcc\u4420\u4787\u4dcd\ua687\u3522\u405c\u4dc2\u4dc0\ua666\u27ba\u4dcd\u4974\u2727\u4df1\u4dfc\ua67a\u276d\u263c\ua69f\u3f02\u2709\u4de5\u4def\u4df5\u43d6\u4dc0\u2704\u4de6\u4dfd\u4de4\u26b7\ua66f\u481e\ua64b\u2791\u422a");
            NONE = new Constraint();
            pattern = Pattern.compile("^([A-Z0-9\\-_\\.]+)\\((?:(<|<=|>|>=|=)?([0-9]+)(<|(-)([0-9]+)?|>|(\\+)([0-9]+)?)?)?\\)$");
        }

        void append(Constraint next) {
            if (this.next != null) {
                this.next.append(next);
                return;
            }
            this.next = next;
        }
    }
}

