/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pers.XiaoShadiao.NMSLException;

public class PrettyPrinter {
    private boolean recalcWidth = false;
    private final List<Object> lines;
    protected String kvFormat;
    protected int kvKeyWidth = 10;
    private Table table;
    private final HorizontalRule horizontalRule = new HorizontalRule('*');
    protected int wrapWidth = 80;
    protected int width = 100;
    private static final NMSLException \u6211\u4eec\u597d\u60f3\u62b1\u62b1\u5979 = new NMSLException("\u263e\u278f\u264a\u4ddc\u4dd5\u276f\u4a40\u4dc2\u4df6\u3597\u26e1\u266d\u3c84\u2788\u26b1\u4dc0\u263d\u4df7\u2710\u2783\u4ded\u3b3a\u4dce\u3a6c\ua67f\u27b0\u4dd5\u4df2\u4dc5\u2696\u27bf\u2645\ua66e\u409e\u263a\ua66f\ua67b\u2787");

    public int wrapTo() {
        return this.wrapWidth;
    }

    public PrettyPrinter table(String ... titles) {
        this.table = new Table();
        for (String title : titles) {
            this.table.addColumn(title);
        }
        return this;
    }

    public PrettyPrinter add(Throwable th) {
        return this.add(th, 4);
    }

    public static void print(Throwable th) {
        new PrettyPrinter().add(th).print(System.err);
    }

    public PrettyPrinter add(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey() == null ? "null" : entry.getKey().toString();
            this.kv(key, entry.getValue());
        }
        return this;
    }

    public PrettyPrinter addIndexed(Object[] array) {
        int indexWidth = String.valueOf(array.length - 1).length();
        String format = "[%" + indexWidth + "d] %s";
        for (int index = 0; index < array.length; ++index) {
            this.add(format, index, array[index]);
        }
        return this;
    }

    public PrettyPrinter tr(Object ... args) {
        this.th(true);
        this.addLine(this.table.addRow(args));
        this.recalcWidth = true;
        return this;
    }

    public PrettyPrinter add(Object object, int indent) {
        String margin = Strings.repeat((String)" ", (int)indent);
        return this.append(object, indent, margin);
    }

    public PrettyPrinter hr() {
        return this.hr('*');
    }

    public PrettyPrinter kv(String key, String format, Object ... args) {
        return this.kv(key, String.format(format, args));
    }

    public PrettyPrinter add(Object[] array, String format) {
        for (Object element : array) {
            this.add(format, element);
        }
        return this;
    }

    public PrettyPrinter addWithIndices(Collection<?> c) {
        return this.addIndexed(c.toArray());
    }

    private static String makeKvFormat(int keyWidth) {
        return String.format("%%%ds : %%s", keyWidth);
    }

    public PrettyPrinter trace(PrintStream stream) {
        return this.trace(stream, PrettyPrinter.getDefaultLoggerName());
    }

    private void printString(PrintStream stream, String string) {
        if (string != null) {
            stream.printf("/* %-" + this.width + "s */\n", string);
        }
    }

    public PrettyPrinter() {
        this(100);
    }

    public PrettyPrinter wrapTo(int wrapWidth) {
        this.wrapWidth = wrapWidth;
        return this;
    }

    public PrettyPrinter trace(Level level) {
        return this.trace(PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(PrintStream stream, String logger, Level level) {
        return this.trace(stream, LogManager.getLogger((String)logger), level);
    }

    public PrettyPrinter trace(PrintStream stream, Level level) {
        return this.trace(stream, PrettyPrinter.getDefaultLoggerName(), level);
    }

    private PrettyPrinter append(Object object, int indent, String margin) {
        if (object instanceof String) {
            return this.add("%s%s", margin, object);
        }
        if (object instanceof Iterable) {
            for (Object entry : (Iterable)object) {
                this.append(entry, indent, margin);
            }
            return this;
        }
        if (object instanceof Map) {
            this.kvWidth(indent);
            return this.add((Map)object);
        }
        if (object instanceof IPrettyPrintable) {
            return this.add((IPrettyPrintable)object);
        }
        if (object instanceof Throwable) {
            return this.add((Throwable)object, indent);
        }
        if (object.getClass().isArray()) {
            return this.add((Object[])object, indent + "%s");
        }
        return this.add("%s%s", margin, object);
    }

    private void logSpecial(Logger logger, Level level, ISpecialEntry line) {
        logger.log(level, "/*{}*/", new Object[]{line.toString()});
    }

    public PrettyPrinter trace(String logger, Level level) {
        return this.trace(System.err, LogManager.getLogger((String)logger), level);
    }

    public PrettyPrinter add(String format, Object ... args) {
        String line = String.format(format, args);
        this.addLine(line);
        this.width = Math.max(this.width, line.length());
        return this;
    }

    public PrettyPrinter trace(Logger logger, Level level) {
        return this.trace(System.err, logger, level);
    }

    public PrettyPrinter kv(String key, Object value) {
        this.addLine(new KeyValue(key, value));
        return this.kvWidth(key.length());
    }

    public PrettyPrinter spacing(int spacing) {
        if (this.table == null) {
            this.table = new Table();
        }
        this.table.setColSpacing(spacing);
        return this;
    }

    public PrettyPrinter trace(String logger) {
        return this.trace(System.err, LogManager.getLogger((String)logger));
    }

    public PrettyPrinter trace(Logger logger) {
        return this.trace(System.err, logger);
    }

    public PrettyPrinter trace(PrintStream stream, String logger) {
        return this.trace(stream, LogManager.getLogger((String)logger));
    }

    public PrettyPrinter print() {
        return this.print(System.err);
    }

    public PrettyPrinter table(Object ... format) {
        this.table = new Table();
        Column column = null;
        for (Object entry : format) {
            if (entry instanceof String) {
                column = this.table.addColumn((String)entry);
                continue;
            }
            if (entry instanceof Integer && column != null) {
                int width = (Integer)entry;
                if (width > 0) {
                    column.setWidth(width);
                    continue;
                }
                if (width >= 0) continue;
                column.setMaxWidth(-width);
                continue;
            }
            if (entry instanceof Alignment && column != null) {
                column.setAlignment((Alignment)((Object)entry));
                continue;
            }
            if (entry == null) continue;
            column = this.table.addColumn(entry.toString());
        }
        return this;
    }

    public PrettyPrinter(int width) {
        this.lines = new ArrayList<Object>();
        this.kvFormat = PrettyPrinter.makeKvFormat(this.kvKeyWidth);
        this.width = width;
    }

    public PrettyPrinter trace(PrintStream stream, Logger logger) {
        return this.trace(stream, logger, Level.DEBUG);
    }

    public PrettyPrinter centre() {
        Object lastLine;
        if (!this.lines.isEmpty() && (lastLine = this.lines.get(this.lines.size() - 1)) instanceof String) {
            this.addLine(new CentredText(this.lines.remove(this.lines.size() - 1)));
        }
        return this;
    }

    public PrettyPrinter add(String string) {
        this.addLine(string);
        this.width = Math.max(this.width, string.length());
        return this;
    }

    private void addLine(Object line) {
        if (line == null) {
            return;
        }
        this.lines.add(line);
        this.recalcWidth |= line instanceof IVariableWidthEntry;
    }

    private void logString(Logger logger, Level level, String line) {
        if (line != null) {
            logger.log(level, String.format("/* %-" + this.width + "s */", line));
        }
    }

    public PrettyPrinter log(Logger logger) {
        return this.log(logger, Level.INFO);
    }

    public PrettyPrinter add(Object[] array) {
        return this.add(array, "%s");
    }

    public PrettyPrinter hr(char ruleChar) {
        this.addLine(new HorizontalRule(ruleChar));
        return this;
    }

    public PrettyPrinter print(PrintStream stream) {
        this.updateWidth();
        this.printSpecial(stream, this.horizontalRule);
        for (Object line : this.lines) {
            if (line instanceof ISpecialEntry) {
                this.printSpecial(stream, (ISpecialEntry)line);
                continue;
            }
            this.printString(stream, line.toString());
        }
        this.printSpecial(stream, this.horizontalRule);
        return this;
    }

    public PrettyPrinter add() {
        this.addLine("");
        return this;
    }

    public PrettyPrinter trace(PrintStream stream, Logger logger, Level level) {
        this.log(logger, level);
        this.print(stream);
        return this;
    }

    public PrettyPrinter add(Throwable th, int indent) {
        while (th != null) {
            this.add("%s: %s", th.getClass().getName(), th.getMessage());
            this.add(th.getStackTrace(), indent);
            th = th.getCause();
        }
        return this;
    }

    public PrettyPrinter table() {
        this.table = new Table();
        return this;
    }

    public PrettyPrinter add(Object object) {
        return this.add(object, 0);
    }

    public PrettyPrinter add(IPrettyPrintable printable) {
        if (printable != null) {
            printable.print(this);
        }
        return this;
    }

    private PrettyPrinter th(boolean onlyIfNeeded) {
        if (this.table == null) {
            this.table = new Table();
        }
        if (!onlyIfNeeded || this.table.addHeader) {
            this.table.headerAdded();
            this.addLine(this.table);
        }
        return this;
    }

    private void updateWidth() {
        if (this.recalcWidth) {
            this.recalcWidth = false;
            for (Object line : this.lines) {
                if (!(line instanceof IVariableWidthEntry)) continue;
                this.width = Math.min(4096, Math.max(this.width, ((IVariableWidthEntry)line).getWidth()));
            }
        }
    }

    public PrettyPrinter addWrapped(String format, Object ... args) {
        return this.addWrapped(this.wrapWidth, format, args);
    }

    public static void dumpStack() {
        new PrettyPrinter().add(new Exception("Stack trace")).print(System.err);
    }

    private void printSpecial(PrintStream stream, ISpecialEntry line) {
        stream.printf("/*%s*/\n", line.toString());
    }

    private List<String> getWrapped(int width, String line, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        while (line.length() > width) {
            int wrapPoint = line.lastIndexOf(32, width);
            if (wrapPoint < 10) {
                wrapPoint = width;
            }
            String head = line.substring(0, wrapPoint);
            lines.add(head);
            line = indent + line.substring(wrapPoint + 1);
        }
        if (line.length() > 0) {
            lines.add(line);
        }
        return lines;
    }

    public PrettyPrinter kvWidth(int width) {
        if (width > this.kvKeyWidth) {
            this.kvKeyWidth = width;
            this.kvFormat = PrettyPrinter.makeKvFormat(width);
        }
        this.recalcWidth = true;
        return this;
    }

    public PrettyPrinter add(StackTraceElement[] stackTrace, int indent) {
        String margin = Strings.repeat((String)" ", (int)indent);
        for (StackTraceElement st : stackTrace) {
            this.add("%s%s", margin, st);
        }
        return this;
    }

    private static String getDefaultLoggerName() {
        String name = new Throwable().getStackTrace()[2].getClassName();
        int pos = name.lastIndexOf(46);
        return pos == -1 ? name : name.substring(pos + 1);
    }

    public PrettyPrinter addWrapped(int width, String format, Object ... args) {
        String indent = "";
        String line = String.format(format, args).replace("\t", "    ");
        Matcher indentMatcher = Pattern.compile("^(\\s+)(.*)$").matcher(line);
        if (indentMatcher.matches()) {
            indent = indentMatcher.group(1);
        }
        try {
            for (String wrappedLine : this.getWrapped(width, line, indent)) {
                this.addLine(wrappedLine);
            }
        }
        catch (Exception ex) {
            this.add(line);
        }
        return this;
    }

    public PrettyPrinter log(Logger logger, Level level) {
        this.updateWidth();
        this.logSpecial(logger, level, this.horizontalRule);
        for (Object line : this.lines) {
            if (line instanceof ISpecialEntry) {
                this.logSpecial(logger, level, (ISpecialEntry)line);
                continue;
            }
            this.logString(logger, level, line.toString());
        }
        this.logSpecial(logger, level, this.horizontalRule);
        return this;
    }

    public PrettyPrinter trace() {
        return this.trace(PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter th() {
        return this.th(false);
    }

    static class Row
    implements IVariableWidthEntry {
        final Table table;
        final String[] args;
        private static final NMSLException \u6709\u6211\u4eec\u5728 = new NMSLException("\u4dc1\u4dc9\u4df3\ua689\u4dcb\u4dff\u4dcf\u26c0\u4dc3\u4dd1\u2750\u4dfc\u3a75\u264a\u26de\u4df6\u2795\u2729\u4dca\u4dc5\u4dfa\u4de7\u4172\u4de6\ua68f\u4de1\u3ce5\u4dca\u4dcb\u261a\u44e2\u27b8\u2620\u4dcd");

        public Row(Table table, Object ... args) {
            this.table = table.grow(args.length);
            this.args = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.args[i] = args[i].toString();
                this.table.columns.get(i).setMinWidth(this.args[i].length());
            }
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }

        public String toString() {
            Object[] args = new Object[this.table.columns.size()];
            for (int col = 0; col < args.length; ++col) {
                Column column = this.table.columns.get(col);
                args[col] = col >= this.args.length ? "" : (this.args[col].length() > column.getMaxWidth() ? this.args[col].substring(0, column.getMaxWidth()) : this.args[col]);
            }
            return String.format(this.table.format, args);
        }
    }

    static class Column {
        private Alignment align = Alignment.LEFT;
        private int size = 0;
        private String title = "";
        private int maxWidth = Integer.MAX_VALUE;
        private final Table table;
        private String format = "%s";
        private int minWidth = 1;
        private static final NMSLException \u8fd8\u6709\u4ec7\u6068\u4e0e\u522b\u4eba\u7684\u4ec7\u6068 = new NMSLException("\u4dee\u4dce\u26a2\u4dfc\u4dce\u26ac\u4de3\ua68d\u4dcb\u4dfd\ua68a\ua69d\ua649\u4dc2\u2786\ua682\u2760\u4dfa\u4dc4\u4dd3\u4df8\u4dd8\u4de0\u2771\ua664\u27ac\u4dc2\u4dc1\u4ddb\ua676\u4dc0\u4dda\u4de7\u2765\ua653\u4dda");

        void setWidth(int width) {
            if (width > this.size) {
                this.size = width;
                this.updateFormat();
            }
        }

        int getMaxWidth() {
            return this.maxWidth;
        }

        void setTitle(String title) {
            this.title = title;
            this.setWidth(title.length());
        }

        Column(Table table, Alignment align, int size, String title) {
            this(table, title);
            this.align = align;
            this.size = size;
        }

        private void updateFormat() {
            int width = Math.min(this.maxWidth, this.size == 0 ? this.minWidth : this.size);
            this.format = "%" + (this.align == Alignment.RIGHT ? "" : "-") + width + "s";
            this.table.updateFormat();
        }

        void setMinWidth(int width) {
            if (width > this.minWidth) {
                this.minWidth = width;
                this.updateFormat();
            }
        }

        public String toString() {
            if (this.title.length() > this.maxWidth) {
                return this.title.substring(0, this.maxWidth);
            }
            return this.title;
        }

        Column(Table table) {
            this.table = table;
        }

        Column(Table table, String title) {
            this(table);
            this.title = title;
            this.minWidth = title.length();
            this.updateFormat();
        }

        void setAlignment(Alignment align) {
            this.align = align;
            this.updateFormat();
        }

        String getFormat() {
            return this.format;
        }

        String getTitle() {
            return this.title;
        }

        void setMaxWidth(int width) {
            this.size = Math.min(this.size, this.maxWidth);
            this.maxWidth = Math.max(1, width);
            this.updateFormat();
        }
    }

    static class Table
    implements IVariableWidthEntry {
        final List<Row> rows;
        String format = "%s";
        boolean addHeader = true;
        int colSpacing = 2;
        final List<Column> columns = new ArrayList<Column>();
        private static final NMSLException \u4f60\u62cd\u516d = new NMSLException("\u4def\ua643\u2791\u4dc6\u4df9\u4dc3\u274d\u4ddc\u4dcd\u4dfd\u2657\u4ddb\u4de6\u4dd2\u4de3\u4ced\u4dd9\u2695\u4dec\u2690\u4d22\u4dfa\u453c\u40f0\u4dc7\u4dd7\u4df3\u4df6\u4dfa\u3cc2\u48de");

        Column add(Column column) {
            this.columns.add(column);
            return column;
        }

        void updateFormat() {
            String spacing = Strings.repeat((String)" ", (int)this.colSpacing);
            StringBuilder format = new StringBuilder();
            boolean addSpacing = false;
            for (Column column : this.columns) {
                if (addSpacing) {
                    format.append(spacing);
                }
                addSpacing = true;
                format.append(column.getFormat());
            }
            this.format = format.toString();
        }

        Column addColumn(Alignment align, int size, String title) {
            return this.add(new Column(this, align, size, title));
        }

        Table() {
            this.rows = new ArrayList<Row>();
        }

        @Override
        public int getWidth() {
            String str = this.toString();
            return str != null ? str.length() : 0;
        }

        Row addRow(Object ... args) {
            return this.add(new Row(this, args));
        }

        void setColSpacing(int spacing) {
            this.colSpacing = Math.max(0, spacing);
            this.updateFormat();
        }

        Row add(Row row) {
            this.rows.add(row);
            return row;
        }

        Column addColumn(String title) {
            return this.add(new Column(this, title));
        }

        void headerAdded() {
            this.addHeader = false;
        }

        Object[] getTitles() {
            ArrayList<String> titles = new ArrayList<String>();
            for (Column column : this.columns) {
                titles.add(column.getTitle());
            }
            return titles.toArray();
        }

        public String toString() {
            boolean nonEmpty = false;
            String[] titles = new String[this.columns.size()];
            for (int col = 0; col < this.columns.size(); ++col) {
                titles[col] = this.columns.get(col).toString();
                nonEmpty |= !titles[col].isEmpty();
            }
            return nonEmpty ? String.format(this.format, titles) : null;
        }

        String getFormat() {
            return this.format;
        }

        Table grow(int size) {
            while (this.columns.size() < size) {
                this.columns.add(new Column(this));
            }
            this.updateFormat();
            return this;
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }

    class CentredText {
        private final Object centred;
        private static final NMSLException \u6211\u662f\u7f07\u5b9d = new NMSLException("\u4dec\u4dcc\u4de8\u4b1d\ua651\ua670\u4dea\u2758\u4de5\ua68a\u453f\u4dd9\u4dd3\u44ed\u4dc2\u4dd1\u4dd8\ua660\u2785\u4dee\u44e8\u275f\u4dc1\u4dd5\u272c\u4de7\u36dd\u4df8\u4dcc\u4060\ua68d\u263a\ua671\u4dfc\ua677");

        public String toString() {
            String text = this.centred.toString();
            return String.format("%" + ((PrettyPrinter.this.width - text.length()) / 2 + text.length()) + "s", text);
        }

        public CentredText(Object centred) {
            this.centred = centred;
        }
    }

    class HorizontalRule
    implements ISpecialEntry {
        private final char[] hrChars;
        private static final NMSLException \u4f60\u62cd\u4e5d = new NMSLException("\ua68a\u4d9f\u26fb\u4dcc\u2662\u4df2\u4ded\u4df7\u4dfe\ua68e\u4de7\u2728\u4dca\ua685\u4df6\u2644\u2781\u4dc8\u2795\u4dca\u27b1\u4deb\u4dc1\u2709\u2626\u4de4\ua663\u2795\ua642\u4dd8\u4dc5\u27ab\u4def\u26de\u403c\u4de9\u474c\u4ded\u4df3\u4dd6\ua67b\u4de6\u4ded\u4ba1\ua648");

        public HorizontalRule(char ... hrChars) {
            this.hrChars = hrChars;
        }

        public String toString() {
            return Strings.repeat((String)new String(this.hrChars), (int)(PrettyPrinter.this.width + 2));
        }
    }

    class KeyValue
    implements IVariableWidthEntry {
        private final Object value;
        private final String key;
        private static final NMSLException \u96ea\u5929\u597d = new NMSLException("\u4ddc\u4dd0\u26d9\u275e\u2607\u4de8\u4dce\u4dea\u272a\ua657\u4dd8\u4ced\u279f\u26e9\u4dd7\u4dc3\u4df8\u4dcd\u48c0\u4dd4\u2636\u26e8\u4dd5\u2778\ua646\u36e5\u2760\u3eb3\u4dea\u2632\u2689\u271a\u2663\u263a");

        public String toString() {
            return String.format(PrettyPrinter.this.kvFormat, this.key, this.value);
        }

        public KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static interface ISpecialEntry {
    }

    static interface IVariableWidthEntry {
        public int getWidth();
    }

    public static interface IPrettyPrintable {
        public void print(PrettyPrinter var1);
    }
}

