/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.NMSLException;

public final class Profiler {
    private final List<String> phases;
    private final Deque<Section> stack;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    public static final int ROOT = 1;
    private boolean active;
    public static final int FINE = 2;
    private static final NMSLException \u5c11\u8bf4\u5947\u602a\u7684\u8bdd\u5566 = new NMSLException("\u4dd4\u27bf\u4de7\ua65c\ua679\u46c0\u4df3\u4dfb\u26ce\u2763\u426f\u261c\u4dd2\u279d\u26be\u270c\u4dde\ua67e\u4dcc\u4dcf\u4d2a\u4dc0\u4df4\u4dd5\ua65f\u2774\u4de7\ua67d\u4df3\u2729\u4dfb\u4df1");

    public Section begin(String name) {
        return this.begin(0, name);
    }

    public Section begin(String ... path) {
        return this.begin(0, path);
    }

    public Section get(String name) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = this.active ? new LiveSection(name, this.phases.size() - 1) : new Section(name);
            this.sections.put(name, section);
        }
        return section;
    }

    public void setActive(boolean active) {
        if (!this.active && active || !active) {
            this.reset();
        }
        this.active = active;
    }

    public PrettyPrinter printer(boolean includeFine, boolean group) {
        PrettyPrinter printer = new PrettyPrinter();
        int colCount = this.phases.size() + 4;
        int[] columns = new int[]{0, 1, 2, colCount - 2, colCount - 1};
        Object[] headers = new Object[colCount * 2];
        int col = 0;
        int pos = 0;
        while (col < colCount) {
            headers[pos + 1] = PrettyPrinter.Alignment.RIGHT;
            if (col == columns[0]) {
                headers[pos] = (group ? "" : "  ") + "Section";
                headers[pos + 1] = PrettyPrinter.Alignment.LEFT;
            } else {
                headers[pos] = col == columns[1] ? "    TOTAL" : (col == columns[3] ? "    Count" : (col == columns[4] ? "Avg. " : (col - columns[2] < this.phases.size() ? this.phases.get(col - columns[2]) : "")));
            }
            pos = ++col * 2;
        }
        printer.table(headers).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !includeFine || group && section.getDelegate() != section) continue;
            this.printSectionRow(printer, colCount, columns, section, group);
            if (!group) continue;
            for (Section subSection : this.sections.values()) {
                Section delegate = subSection.getDelegate();
                if (subSection.isFine() && !includeFine || delegate != section || delegate == subSection) continue;
                this.printSectionRow(printer, colCount, columns, subSection, group);
            }
        }
        return printer.add();
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public Section begin(int flags, String ... path) {
        return this.begin(flags, Joiner.on((char)'.').join((Object[])path));
    }

    private Section getSubSection(String name, String baseName, Section root) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = new SubSection(name, this.phases.size() - 1, baseName, root);
            this.sections.put(name, section);
        }
        return section;
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add("Initial");
        this.stack.clear();
    }

    public Profiler() {
        this.phases = new ArrayList<String>();
        this.stack = new LinkedList<Section>();
        this.phases.add("Initial");
    }

    public Section begin(int flags, String name) {
        boolean root = (flags & 1) != 0;
        boolean fine = (flags & 2) != 0;
        String path = name;
        Section head = this.stack.peek();
        if (head != null) {
            path = head.getName() + (root ? " -> " : ".") + path;
            if (head.isRoot() && !root) {
                int pos = head.getName().lastIndexOf(" -> ");
                name = (pos > -1 ? head.getName().substring(pos + 4) : head.getName()) + "." + name;
                root = true;
            }
        }
        Section section = this.get(root ? name : path);
        if (root && head != null && this.active) {
            section = this.getSubSection(path, head.getName(), section);
        }
        section.setFine(fine).setRoot(root);
        this.stack.push(section);
        return section.start();
    }

    boolean isHead(Section section) {
        return this.stack.peek() == section;
    }

    void end(Section section) {
        block5: {
            try {
                Section head;
                Section next = head = this.stack.pop();
                while (next != section) {
                    if (next == null && this.active) {
                        if (head == null) {
                            throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
                        }
                        throw new IllegalStateException("Attempted to pop " + section + " which was not in the stack, head was " + head);
                    }
                    next = this.stack.pop();
                }
            }
            catch (NoSuchElementException ex) {
                if (!this.active) break block5;
                throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
            }
        }
    }

    public void mark(String phase) {
        long currentPhaseTime = 0L;
        for (Section section : this.sections.values()) {
            currentPhaseTime += section.getTime();
        }
        if (currentPhaseTime == 0L) {
            int size = this.phases.size();
            this.phases.set(size - 1, phase);
            return;
        }
        this.phases.add(phase);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    private void printSectionRow(PrettyPrinter printer, int colCount, int[] columns, Section section, boolean group) {
        long[] times;
        boolean isDelegate = section.getDelegate() != section;
        Object[] values = new Object[colCount];
        int col = 1;
        values[0] = group ? (isDelegate ? "  > " + section.getBaseName() : section.getName()) : (isDelegate ? "+ " : "  ") + section.getName();
        for (long time : times = section.getTimes()) {
            if (col == columns[1]) {
                values[col++] = section.getTotalTime() + " ms";
            }
            if (col < columns[2] || col >= values.length) continue;
            values[col++] = time + " ms";
        }
        values[columns[3]] = section.getTotalCount();
        values[columns[4]] = new DecimalFormat("   ###0.000 ms").format(section.getTotalAverageTime());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            values[i] = "-";
        }
        printer.tr(values);
    }

    class SubSection
    extends LiveSection {
        private final Section root;
        private final String baseName;
        private static final NMSLException \u53ef\u662f = new NMSLException("\u4ddc\u4dc5\u26be\u4dca\u4de1\ua695\u4dd1\u4df4\u4de4\u4dc3\u4de9\ua685\ua696\ua65f\u4dfc\u275e\u4b6e\u4df6\ua66a\u4dc8\u4542\u4dda\ua689\u3dc3\u4de8\u4dc3\u3f0d\u2761\ua674\u4dd9\u4dcd\u45ee\u4de9\u4ddd\u4dc8\u4de0\u4447\u35dc\u4dec\u26e3\u4dd4\u263d\u4de2\u3790");

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public Section next(String name) {
            super.stop();
            return this.root.next(name);
        }

        @Override
        public void setInfo(String info) {
            this.root.setInfo(info);
            super.setInfo(info);
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        SubSection(String name, int cursor, String baseName, Section root) {
            super(name, cursor);
            this.baseName = baseName;
            this.root = root;
        }
    }

    class LiveSection
    extends Section {
        private int count;
        private long time;
        private long start;
        private long markedTime;
        private long[] times;
        private int markedCount;
        private int cursor;
        private static final NMSLException \u4f46\u8fd8\u662f\u5f88\u62c5\u5fc3 = new NMSLException("\u26a5\u3952\u4dc4\u4dfb\ua69b\u4dd1\u4dfb\ua657\u4dde\u2788\u278c\ua641\u262b\u4de0\u4dfd\u264b\u274b\u2621\u3e66\u272d\u4dc8\u4de5\u4df3\u4dd4\u34ab\u2665\u27b5\u4dd2\u4dca\ua65c\u4dce\u4dcf\u4ded\u4dc9\u4de3\u279e");

        LiveSection(String name, int cursor) {
            super(name);
            this.cursor = 0;
            this.times = new long[0];
            this.start = 0L;
            this.cursor = cursor;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + 4);
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0L;
            this.count = 0;
            ++this.cursor;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        protected Section stop() {
            if (this.start > 0L) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0L;
            ++this.count;
            return this;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public long[] getTimes() {
            long[] times = new long[this.cursor + 1];
            System.arraycopy(this.times, 0, times, 0, Math.min(this.times.length, this.cursor));
            times[this.cursor] = this.time;
            return times;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        private boolean root;
        private String info;
        private boolean fine;
        private final String name;
        static final String SEPARATOR_CHILD = ".";
        protected boolean invalidated;
        private static final NMSLException \u96e8\u5929 = new NMSLException("\u479c\u4dc3\u269f\u4df1\u4dc1\ua68d\u4dda\u380a\u4df5\u4cae\u26ca\u44d4\u4de4\ua673\u4dc4\u4de0\u4ddd\ua641\u4dde\u4df9\u4ddd\u2788\u4df7\u4dcd\u4dde\u41ff\u4dce\u4de0\u4dc6\u4dda\u4dda\u271b\ua64e\u3f56\u4dd0\u4dfd\u4df3\u4df4\u274b\u4dc0\u4dcb\ua674\u27ac\u27a6\u2766\u2624\u4df0");

        public String getInfo() {
            return this.info;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public Section next(String name) {
            this.end();
            return Profiler.this.begin(name);
        }

        public boolean isRoot() {
            return this.root;
        }

        Section start() {
            return this;
        }

        public String getBaseName() {
            return this.name;
        }

        public long getTime() {
            return 0L;
        }

        public double getAverageTime() {
            return 0.0;
        }

        Section setRoot(boolean root) {
            this.root = root;
            return this;
        }

        void mark() {
        }

        public long getTotalTime() {
            return 0L;
        }

        Section setFine(boolean fine) {
            this.fine = fine;
            return this;
        }

        public long[] getTimes() {
            return new long[1];
        }

        Section getDelegate() {
            return this;
        }

        public boolean isFine() {
            return this.fine;
        }

        public int getCount() {
            return 0;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        Section invalidate() {
            this.invalidated = true;
            return this;
        }

        public int getTotalCount() {
            return 0;
        }

        public double getSeconds() {
            return 0.0;
        }

        public String getName() {
            return this.name;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        protected Section stop() {
            return this;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }

        Section(String name) {
            this.name = name;
            this.info = name;
        }
    }
}

