/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.agent;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IHotSwap;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.tools.agent.MixinAgentClassLoader;
import pers.XiaoShadiao.NMSLException;

public class MixinAgent
implements IHotSwap {
    final MixinTransformer classTransformer;
    static final Logger logger;
    static Instrumentation instrumentation;
    private static List<MixinAgent> agents;
    static final MixinAgentClassLoader classLoader;
    public static final byte[] ERROR_BYTECODE;
    private static final NMSLException \u8776\u603b\u662f\u4e00\u4e2a\u4eba;

    public static void agentmain(String arg, Instrumentation instrumentation) {
        MixinAgent.init(instrumentation);
    }

    public MixinAgent(MixinTransformer classTransformer) {
        this.classTransformer = classTransformer;
        agents.add(this);
        if (instrumentation != null) {
            this.initTransformer();
        }
    }

    public static void premain(String arg, Instrumentation instrumentation) {
        System.setProperty("mixin.hotSwap", "true");
        MixinAgent.init(instrumentation);
    }

    private void initTransformer() {
        instrumentation.addTransformer(new Transformer(), true);
    }

    static {
        \u8776\u603b\u662f\u4e00\u4e2a\u4eba = new NMSLException("\u4df1\u4dc5\u4df6\u4dda\u26df\ua640\u266f\u4d54\u4ddc\u3938\u4df4\u4690\u4df9\u27a7\u47c4\u4dce\u4dc1\u4df9\u4264\u4dee\u4dd3\u4dc6\u2768\u4df8\u26c8\u4dd2\u4dd6\u27ad\u4aaa\u2795\u4df3\u4dc7\ua676\u4df6\ua660\u4dd6\ua65f\u4dfe\u270c\u3882\u4dda");
        ERROR_BYTECODE = new byte[]{1};
        classLoader = new MixinAgentClassLoader();
        logger = LogManager.getLogger((String)"mixin.agent");
        instrumentation = null;
        agents = new ArrayList<MixinAgent>();
    }

    @Override
    public void registerTargetClass(String name, byte[] bytecode) {
        classLoader.addTargetClass(name, bytecode);
    }

    public static void init(Instrumentation instrumentation) {
        MixinAgent.instrumentation = instrumentation;
        if (!MixinAgent.instrumentation.isRedefineClassesSupported()) {
            logger.error("The instrumentation doesn't support re-definition of classes");
        }
        for (MixinAgent agent : agents) {
            agent.initTransformer();
        }
    }

    @Override
    public void registerMixinClass(String name) {
        classLoader.addMixinClass(name);
    }

    class Transformer
    implements ClassFileTransformer {
        private static final NMSLException \u6211\u62cd\u4e00 = new NMSLException("\u3da5\u4dfb\u268e\u4df1\u4dca\ua674\u278a\u2722\ua69b\u4df5\u4df2\ua68b\ua679\u3b26\u4dfe\u4df6\u4dcf\u2619\u4df9\u2641\u4dcf\u42c1\u3b5d\u4dfd\u4dda\ua67c\u4dc1\u2739\u4de7\u41d3\u277b\u4dc3\u4dcb\u38f2\u4dc8");

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (classBeingRedefined == null) {
                return null;
            }
            byte[] mixinBytecode = classLoader.getFakeMixinBytecode(classBeingRedefined);
            if (mixinBytecode != null) {
                List<String> targets = this.reloadMixin(className, classfileBuffer);
                if (targets == null || !this.reApplyMixins(targets)) {
                    return ERROR_BYTECODE;
                }
                return mixinBytecode;
            }
            try {
                logger.info("Redefining class " + className);
                return MixinAgent.this.classTransformer.transformClassBytes(null, className, classfileBuffer);
            }
            catch (Throwable th) {
                logger.error("Error while re-transforming class " + className, th);
                return ERROR_BYTECODE;
            }
        }

        private List<String> reloadMixin(String className, byte[] classfileBuffer) {
            logger.info("Redefining mixin {}", new Object[]{className});
            try {
                return MixinAgent.this.classTransformer.reload(className.replace('/', '.'), classfileBuffer);
            }
            catch (MixinReloadException e) {
                logger.error("Mixin {} cannot be reloaded, needs a restart to be applied: {} ", new Object[]{e.getMixinInfo(), e.getMessage()});
            }
            catch (Throwable th) {
                logger.error("Error while finding targets for mixin " + className, th);
            }
            return null;
        }

        Transformer() {
        }

        private boolean reApplyMixins(List<String> targets) {
            IMixinService service = MixinService.getService();
            for (String target : targets) {
                String targetName = target.replace('/', '.');
                logger.debug("Re-transforming target class {}", new Object[]{target});
                try {
                    Class<?> targetClass = service.getClassProvider().findClass(targetName);
                    byte[] targetBytecode = classLoader.getOriginalTargetBytecode(targetName);
                    if (targetBytecode == null) {
                        logger.error("Target class {} bytecode is not registered", new Object[]{targetName});
                        return false;
                    }
                    targetBytecode = MixinAgent.this.classTransformer.transformClassBytes(null, targetName, targetBytecode);
                    instrumentation.redefineClasses(new ClassDefinition(targetClass, targetBytecode));
                }
                catch (Throwable th) {
                    logger.error("Error while re-transforming target class " + target, th);
                    return false;
                }
            }
            return true;
        }
    }
}

