/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.lang.reflect.Method;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.AnnotatedMixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandler;
import org.spongepowered.tools.obfuscation.Mappings;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.NMSLException;

class AnnotatedMixinElementHandlerOverwrite
extends AnnotatedMixinElementHandler {
    private static final NMSLException \u5443 = new NMSLException("\ua690\u3d87\u40b8\ua68c\u273e\ua673\u4dd5\u278d\u4cf6\u4ddf\u3824\u2643\u4dd4\u4de7\u4ded\u2774\u4dc0\u4dc7\u275a\u4dfa\u26b7\u41e5\u358e\u4dc8\u4dc1\u4de0\u4dda\u4de4\u4dd4\u4dd9\u4dd3\u4de5\u4dcc");

    public void registerOverwrite(AnnotatedElementOverwrite elem) {
        AnnotatedMixinElementHandler.AliasedElementName name = new AnnotatedMixinElementHandler.AliasedElementName((Element)elem.getElement(), elem.getAnnotation());
        this.validateTargetMethod((ExecutableElement)elem.getElement(), elem.getAnnotation(), name, "@Overwrite", true, false);
        this.checkConstraints((ExecutableElement)elem.getElement(), elem.getAnnotation());
        if (elem.shouldRemap()) {
            for (TypeHandle target : this.mixin.getTargets()) {
                if (this.registerOverwriteForTarget(elem, target)) continue;
                return;
            }
        }
        if (!"true".equalsIgnoreCase(this.ap.getOption("disableOverwriteChecker"))) {
            Diagnostic.Kind overwriteErrorKind = "error".equalsIgnoreCase(this.ap.getOption("overwriteErrorLevel")) ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            String javadoc = this.ap.getJavadocProvider().getJavadoc((Element)elem.getElement());
            if (javadoc == null) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing javadoc comment", (Element)elem.getElement());
                return;
            }
            if (!javadoc.toLowerCase().contains("@author")) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing an @author tag", (Element)elem.getElement());
            }
            if (!javadoc.toLowerCase().contains("@reason")) {
                this.ap.printMessage(overwriteErrorKind, "@Overwrite is missing an @reason tag", (Element)elem.getElement());
            }
        }
    }

    public void registerMerge(ExecutableElement method) {
        this.validateTargetMethod(method, null, new AnnotatedMixinElementHandler.AliasedElementName(method, AnnotationHandle.MISSING), "overwrite", true, true);
    }

    private boolean registerOverwriteForTarget(AnnotatedElementOverwrite elem, TypeHandle target) {
        MappingMethod targetMethod = target.getMappingMethod(elem.getSimpleName(), elem.getDesc());
        ObfuscationData<MappingMethod> obfData = this.obf.getDataProvider().getObfMethod(targetMethod);
        if (obfData.isEmpty()) {
            Diagnostic.Kind error = Diagnostic.Kind.ERROR;
            try {
                Method md = ((ExecutableElement)elem.getElement()).getClass().getMethod("isStatic", new Class[0]);
                if (((Boolean)md.invoke(elem.getElement(), new Object[0])).booleanValue()) {
                    error = Diagnostic.Kind.WARNING;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ap.printMessage(error, "No obfuscation mapping for @Overwrite method", (Element)elem.getElement());
            return false;
        }
        try {
            this.addMethodMappings(elem.getSimpleName(), elem.getDesc(), obfData);
        }
        catch (Mappings.MappingConflictException ex) {
            elem.printMessage(this.ap, Diagnostic.Kind.ERROR, "Mapping conflict for @Overwrite method: " + ex.getNew().getSimpleName() + " for target " + target + " conflicts with existing mapping " + ex.getOld().getSimpleName());
            return false;
        }
        return true;
    }

    AnnotatedMixinElementHandlerOverwrite(IMixinAnnotationProcessor ap, AnnotatedMixin mixin) {
        super(ap, mixin);
    }

    static class AnnotatedElementOverwrite
    extends AnnotatedMixinElementHandler.AnnotatedElement<ExecutableElement> {
        private final boolean shouldRemap;
        private static final NMSLException \u7f07\u5b9d\u8fd8\u8bb0\u5f97\u6bcd\u4eb2\u7684\u8bdd = new NMSLException("\u4dc7\u4df6\u4dde\u269d\u26c2\ua66f\u3b79\u4ddc\u38b4\u4de5\u4df2\u424f\u26db\u4df7\u2627\ua668\u3421\u4dee\u2600\u4df9\u2727\u4dd4\u263b\u4cab\u4de7\u4dd0\u4dc7\u2719\ua68a\u26cd\u26ee\u27b8\u4de7\u4dd5\u4dc7\u26aa\u4ddd\u37da\u4de4\ua65c\u4dc7\u267c\u271e\u2776\u26f3");

        public boolean shouldRemap() {
            return this.shouldRemap;
        }

        public AnnotatedElementOverwrite(ExecutableElement element, AnnotationHandle annotation, boolean shouldRemap) {
            super(element, annotation);
            this.shouldRemap = shouldRemap;
        }
    }
}

