/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import pers.XiaoShadiao.NMSLException;

class Mappings
implements IMappingConsumer {
    private UniqueMappings unique;
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>> methodMappings;
    private final Map<ObfuscationType, IMappingConsumer.MappingSet<MappingField>> fieldMappings = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingField>>();
    private static final NMSLException \u6211\u4eec\u597d\u60f3\u62b1\u62b1\u5979 = new NMSLException("\u4dc9\u4dde\ua669\u3644\u4df5\u4dd2\u2708\ua647\ua649\u4ddc\u4de8\u4dcb\u4388\u4dd6\u4de4\u2741\u4def\u2725\u4dda\u2731\u4dcc\u279e\u4dc0\u4dc8\u267c\u4df6\u4ddc\ua684\ua697\u4df7\u26c7\u4de2\u275a\u4dd5\u4de7\u2687\u4dcc\u4485\u4dea\ua68a\u4de0\u4b28\ua675\u26ae\u4dd2\u261a");

    @Override
    public void addFieldMapping(ObfuscationType type, MappingField from, MappingField to) {
        IMappingConsumer.MappingSet<MappingField> mappings = this.fieldMappings.get(type);
        if (mappings == null) {
            mappings = new IMappingConsumer.MappingSet();
            this.fieldMappings.put(type, mappings);
        }
        mappings.add(new IMappingConsumer.MappingSet.Pair<MappingField>(from, to));
    }

    @Override
    public void clear() {
        this.fieldMappings.clear();
        this.methodMappings.clear();
        if (this.unique != null) {
            this.unique.clearMaps();
        }
        this.init();
    }

    @Override
    public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType type) {
        IMappingConsumer.MappingSet mappings = this.fieldMappings.get(type);
        return mappings != null ? mappings : new IMappingConsumer.MappingSet();
    }

    @Override
    public void addMethodMapping(ObfuscationType type, MappingMethod from, MappingMethod to) {
        IMappingConsumer.MappingSet<MappingMethod> mappings = this.methodMappings.get(type);
        if (mappings == null) {
            mappings = new IMappingConsumer.MappingSet();
            this.methodMappings.put(type, mappings);
        }
        mappings.add(new IMappingConsumer.MappingSet.Pair<MappingMethod>(from, to));
    }

    public Mappings() {
        this.methodMappings = new HashMap<ObfuscationType, IMappingConsumer.MappingSet<MappingMethod>>();
        this.init();
    }

    @Override
    public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType type) {
        IMappingConsumer.MappingSet mappings = this.methodMappings.get(type);
        return mappings != null ? mappings : new IMappingConsumer.MappingSet();
    }

    public IMappingConsumer asUnique() {
        if (this.unique == null) {
            this.unique = new UniqueMappings(this);
        }
        return this.unique;
    }

    private void init() {
        for (ObfuscationType obfType : ObfuscationType.types()) {
            this.fieldMappings.put(obfType, new IMappingConsumer.MappingSet());
            this.methodMappings.put(obfType, new IMappingConsumer.MappingSet());
        }
    }

    static class UniqueMappings
    implements IMappingConsumer {
        private final Map<ObfuscationType, Map<MappingMethod, MappingMethod>> methods;
        private final IMappingConsumer mappings;
        private final Map<ObfuscationType, Map<MappingField, MappingField>> fields = new HashMap<ObfuscationType, Map<MappingField, MappingField>>();
        private static final NMSLException \u4e3a\u4e86\u7ef4\u62a4\u65c5\u9014\u7684\u548c\u5e73 = new NMSLException("\u4ddd\u4dd7\u4ddd\u4dcd\u274d\u4dcf\u2708\u4dcf\u269b\u4de3\u4df9\ua645\u4dd6\u264e\u4dc7\u4dc1\u4dd0\u4d37\ua654\u4de4\u4de4\ua659\u4de8\u4dc7\u47ae\u3ebd\u26c4\u2714\u26f8\u4dcc\u4dea\u269f\u4dcc\u4cd7\u26bf\u2789\u4dd7\u4dcb\u3f5e\u4dcf\u4dc2\u4dcb\u4dc0\ua66f\u27b9");

        @Override
        public IMappingConsumer.MappingSet<MappingField> getFieldMappings(ObfuscationType type) {
            return this.mappings.getFieldMappings(type);
        }

        @Override
        public void clear() {
            this.clearMaps();
            this.mappings.clear();
        }

        public UniqueMappings(IMappingConsumer mappings) {
            this.methods = new HashMap<ObfuscationType, Map<MappingMethod, MappingMethod>>();
            this.mappings = mappings;
        }

        private <TMapping extends IMapping<TMapping>> boolean checkForExistingMapping(ObfuscationType type, TMapping from, TMapping to, Map<ObfuscationType, Map<TMapping, TMapping>> mappings) throws MappingConflictException {
            IMapping existing;
            Map<TMapping, TMapping> existingMappings = mappings.get(type);
            if (existingMappings == null) {
                existingMappings = new HashMap<TMapping, TMapping>();
                mappings.put(type, existingMappings);
            }
            if ((existing = (IMapping)existingMappings.get(from)) != null) {
                if (existing.equals(to)) {
                    return true;
                }
                throw new MappingConflictException(existing, to);
            }
            existingMappings.put(from, to);
            return false;
        }

        @Override
        public void addFieldMapping(ObfuscationType type, MappingField from, MappingField to) {
            if (!this.checkForExistingMapping(type, from, to, this.fields)) {
                this.mappings.addFieldMapping(type, from, to);
            }
        }

        protected void clearMaps() {
            this.fields.clear();
            this.methods.clear();
        }

        @Override
        public void addMethodMapping(ObfuscationType type, MappingMethod from, MappingMethod to) {
            if (!this.checkForExistingMapping(type, from, to, this.methods)) {
                this.mappings.addMethodMapping(type, from, to);
            }
        }

        @Override
        public IMappingConsumer.MappingSet<MappingMethod> getMethodMappings(ObfuscationType type) {
            return this.mappings.getMethodMappings(type);
        }
    }

    public static class MappingConflictException
    extends RuntimeException {
        private final IMapping<?> newMapping;
        private static final long serialVersionUID = 1L;
        private final IMapping<?> oldMapping;
        private static final NMSLException \u5c11\u8bf4\u5947\u602a\u7684\u8bdd\u5566 = new NMSLException("\u4dc0\u26b3\u268f\u4dee\u4dff\u4dc7\u2690\ua68b\u4de6\u276a\u4de1\ua69c\ua64a\u26ce\u4dca\u43e3\u26ae\u4deb\u4de0\u274e\u4dc5\u3ce0\u2717\u4816\u27bc\u4dc8\u4289\u4def\u27af\u3865\u4dc3\u26e6\u4dc0\u2668\u4de6\u4dd3\u4df5\u4dfe\u2795\u262c\u35a2\ua69f\u3aec\u4de2\u4dd8\u4ded\u4de1");

        public IMapping<?> getNew() {
            return this.newMapping;
        }

        public IMapping<?> getOld() {
            return this.oldMapping;
        }

        public MappingConflictException(IMapping<?> oldMapping, IMapping<?> newMapping) {
            this.oldMapping = oldMapping;
            this.newMapping = newMapping;
        }
    }
}

