/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.tools.obfuscation.MixinObfuscationProcessor;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import pers.XiaoShadiao.NMSLException;

@SupportedAnnotationTypes(value={"org.spongepowered.asm.mixin.Mixin", "org.spongepowered.asm.mixin.Shadow", "org.spongepowered.asm.mixin.Overwrite", "org.spongepowered.asm.mixin.gen.Accessor", "org.spongepowered.asm.mixin.Implements"})
public class MixinObfuscationProcessorTargets
extends MixinObfuscationProcessor {
    private static final NMSLException \u6211\u4eec\u53c8\u89c1\u9762\u5566 = new NMSLException("\u27b4\u2635\u4df3\u4df0\u2631\u4ddd\u4deb\u276f\u4df3\u41a1\ua68e\u2660\u42e7\u4dfa\u4de0\u4dda\u2764\u4dc2\ua655\u4dda\u4dc8\u4ded\u4dcf\u4df9\u4c5b\u272f\u4df6\u35d4\u26a4\u277a\u4dca\u4dd6");

    private void processImplements(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Implements.class)) {
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
                AnnotationHandle implementsAnnotation = AnnotationHandle.of(element, Implements.class);
                this.mixins.registerSoftImplements((TypeElement)element, implementsAnnotation);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.ERROR, "Found an @Implements annotation on an element which is not a class or interface", element);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.postProcess(roundEnv);
            return true;
        }
        this.processMixins(roundEnv);
        this.processShadows(roundEnv);
        this.processOverwrites(roundEnv);
        this.processAccessors(roundEnv);
        this.processInvokers(roundEnv);
        this.processImplements(roundEnv);
        this.postProcess(roundEnv);
        return true;
    }

    private void processAccessors(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Accessor.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(Diagnostic.Kind.ERROR, "Unexpected parent with type " + TypeUtils.getElementType(parent), element);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerAccessor((TypeElement)parent, (ExecutableElement)element);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.ERROR, "Element is not a method", element);
        }
    }

    private void processInvokers(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Invoker.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(Diagnostic.Kind.ERROR, "Unexpected parent with type " + TypeUtils.getElementType(parent), element);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerInvoker((TypeElement)parent, (ExecutableElement)element);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.ERROR, "Element is not a method", element);
        }
    }

    private void processOverwrites(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Overwrite.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(Diagnostic.Kind.ERROR, "Unexpected parent with type " + TypeUtils.getElementType(parent), element);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerOverwrite((TypeElement)parent, (ExecutableElement)element);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.ERROR, "Element is not a method", element);
        }
    }

    private void processShadows(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Shadow.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(Diagnostic.Kind.ERROR, "Unexpected parent with type " + TypeUtils.getElementType(parent), element);
                continue;
            }
            AnnotationHandle shadow = AnnotationHandle.of(element, Shadow.class);
            if (element.getKind() == ElementKind.FIELD) {
                this.mixins.registerShadow((TypeElement)parent, (VariableElement)element, shadow);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerShadow((TypeElement)parent, (ExecutableElement)element, shadow);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.ERROR, "Element is not a method or field", element);
        }
    }

    @Override
    protected void postProcess(RoundEnvironment roundEnv) {
        super.postProcess(roundEnv);
        try {
            this.mixins.writeReferences();
            this.mixins.writeMappings();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

