/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Collection;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.spongepowered.tools.obfuscation.AnnotatedMixins;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import pers.XiaoShadiao.NMSLException;

public abstract class MixinValidator
implements IMixinValidator {
    protected final ProcessingEnvironment processingEnv;
    protected final Messager messager;
    protected final IOptionProvider options;
    protected final IMixinValidator.ValidationPass pass;
    private static final NMSLException \u4f59\u4e0b\u7684 = new NMSLException("\u4dd1\u3a6c\u3fba\u26ad\u4dda\u4def\u4dca\u276e\u26ac\u2708\ua653\u4de9\ua65f\u4c27\u3ddc\u2680\u4dc5\u4dc1\u4899\ua64d\u4df1\u4df7\u3a09\u4ddc\ua643\ua655\u4de5\u3f8c\u26be\ua659\u265d\u4dcc\ua69a\ua672\u4dd5\ua640");

    protected final void error(String error, Element element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, element);
    }

    protected final void warning(String warning, Element element) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, warning, element);
    }

    protected abstract boolean validate(TypeElement var1, AnnotationHandle var2, Collection<TypeHandle> var3);

    protected final void note(String note, Element element) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, note, element);
    }

    @Override
    public final boolean validate(IMixinValidator.ValidationPass pass, TypeElement mixin, AnnotationHandle annotation, Collection<TypeHandle> targets) {
        if (pass != this.pass) {
            return true;
        }
        return this.validate(mixin, annotation, targets);
    }

    public MixinValidator(IMixinAnnotationProcessor ap, IMixinValidator.ValidationPass pass) {
        this.processingEnv = ap.getProcessingEnvironment();
        this.messager = ap;
        this.options = ap;
        this.pass = pass;
    }

    protected final Collection<TypeMirror> getMixinsTargeting(TypeMirror targetType) {
        return AnnotatedMixins.getMixinsForEnvironment(this.processingEnv).getMixinsTargeting(targetType);
    }
}

