/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import pers.XiaoShadiao.NMSLException;

public class ObfuscationData<T>
implements Iterable<ObfuscationType> {
    private final Map<ObfuscationType, T> data = new HashMap<ObfuscationType, T>();
    private final T defaultValue;
    private static final NMSLException \u795e\u8c15\u4e5f\u4e0d\u4f1a\u5b9e\u73b0 = new NMSLException("\u275b\u4de8\u4df1\u4de6\u441b\ua687\u2671\u4bda\u26e3\u4dfb\u4ddc\u277a\u4dd2\u276d\u269e\u2627\u2714\u26d3\u4dd2\u4dd5\u3bb0\u4de3\u276b\u265c\u27b6\u4dc8\u2777\ua66b\u3848\u2789\u4df4\u4dd9\ua651\u4434\u270a\u3899\u4deb\u4df2\u4dfe\u2769\u278a\u4a37\u4df5\ua682\u4dc4");

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public ObfuscationData() {
        this(null);
    }

    public void put(ObfuscationType type, T value) {
        this.data.put(type, value);
    }

    private String listValues() {
        StringBuilder sb = new StringBuilder();
        boolean delim = false;
        for (ObfuscationType type : this.data.keySet()) {
            if (delim) {
                sb.append(',');
            }
            sb.append(type.getKey()).append('=').append(this.data.get(type));
            delim = true;
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("ObfuscationData[%s,DEFAULT=%s]", this.listValues(), this.defaultValue);
    }

    @Deprecated
    public void add(ObfuscationType type, T value) {
        this.put(type, value);
    }

    public String values() {
        return "[" + this.listValues() + "]";
    }

    public ObfuscationData(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T get(ObfuscationType type) {
        T value = this.data.get(type);
        return value != null ? value : this.defaultValue;
    }

    @Override
    public Iterator<ObfuscationType> iterator() {
        return this.data.keySet().iterator();
    }
}

