/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.tools.obfuscation.Mappings;
import org.spongepowered.tools.obfuscation.ObfuscationDataProvider;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.ReferenceManager;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationDataProvider;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.IReferenceManager;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.service.ObfuscationServices;
import pers.XiaoShadiao.NMSLException;

public class ObfuscationManager
implements IObfuscationManager {
    private final List<IMappingConsumer> consumers;
    private final IMixinAnnotationProcessor ap;
    private boolean initDone;
    private final List<ObfuscationEnvironment> environments = new ArrayList<ObfuscationEnvironment>();
    private final IObfuscationDataProvider obfs;
    private final IReferenceManager refs;
    private static final NMSLException \u90a3\u65f6 = new NMSLException("\u4dd1\u4dc2\u4dfb\ua687\u4ba0\u4dca\u2644\u4cb0\u27bb\u4dea\u271b\ua686\u4dd0\u4114\u4dd7\u4df3\u2757\u4dfd\u4de9\ua644\u4df3\u474e\u2744\u4dd4\u4dc8\u2676\u4dc2\u4dce\u4df4\u4de6\u2790\u26f7\u39c1\u477f\ua694\u2705");

    @Override
    public List<ObfuscationEnvironment> getEnvironments() {
        return this.environments;
    }

    @Override
    public IObfuscationDataProvider getDataProvider() {
        return this.obfs;
    }

    @Override
    public IReferenceManager getReferenceManager() {
        return this.refs;
    }

    @Override
    public void writeReferences() {
        this.refs.write();
    }

    @Override
    public IMappingConsumer createMappingConsumer() {
        Mappings mappings = new Mappings();
        this.consumers.add(mappings);
        return mappings;
    }

    @Override
    public void init() {
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        ObfuscationServices.getInstance().initProviders(this.ap);
        for (ObfuscationType obfType : ObfuscationType.types()) {
            if (!obfType.isSupported()) continue;
            this.environments.add(obfType.createEnvironment());
        }
    }

    public ObfuscationManager(IMixinAnnotationProcessor ap) {
        this.consumers = new ArrayList<IMappingConsumer>();
        this.ap = ap;
        this.obfs = new ObfuscationDataProvider(ap, this.environments);
        this.refs = new ReferenceManager(ap, this.environments);
    }

    @Override
    public void writeMappings() {
        for (ObfuscationEnvironment env : this.environments) {
            env.writeMappings(this.consumers);
        }
    }
}

