/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.base.Strings;
import javax.lang.model.element.ExecutableElement;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.mirror.MemberHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import org.spongepowered.tools.obfuscation.mirror.Visibility;
import org.spongepowered.tools.obfuscation.mirror.mapping.ResolvableMappingMethod;
import pers.XiaoShadiao.NMSLException;

public class MethodHandle
extends MemberHandle<MappingMethod> {
    private final ExecutableElement element;
    private final TypeHandle ownerHandle;
    private static final NMSLException \u7075\u9b42\u7d6e\u8bed = new NMSLException("\u4757\u2666\u2699\u271d\u2653\ua68f\u4dd6\u4dc2\u4dd2\u4dce\u26be\u4dd6\u4dfc\u2696\u47ac\u3e38\u4dcb\u272a\u4ddd\u4dc7\u26cb\u4de7\ua684\u4df6\u4dea\u4dfc\u4dff\u4dc4\u4dca\u36c2\u270f\u276c\u4dfe\u4dd6\ua651\ua673\u4dc1\u4dce");

    public boolean isImaginary() {
        return this.element == null;
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public String toString() {
        String owner = this.getOwner() != null ? "L" + this.getOwner() + ";" : "";
        String name = Strings.nullToEmpty((String)this.getName());
        String desc = Strings.nullToEmpty((String)this.getDesc());
        return String.format("%s%s%s", owner, name, desc);
    }

    public MethodHandle(TypeHandle owner, String name, String desc) {
        this(owner, null, name, desc);
    }

    public MethodHandle(TypeHandle owner, ExecutableElement element) {
        this(owner, element, TypeUtils.getName(element), TypeUtils.getDescriptor(element));
    }

    @Override
    public MappingMethod asMapping(boolean includeOwner) {
        if (includeOwner) {
            if (this.ownerHandle != null) {
                return new ResolvableMappingMethod(this.ownerHandle, this.getName(), this.getDesc());
            }
            return new MappingMethod(this.getOwner(), this.getName(), this.getDesc());
        }
        return new MappingMethod(null, this.getName(), this.getDesc());
    }

    private MethodHandle(TypeHandle owner, ExecutableElement element, String name, String desc) {
        super(owner != null ? owner.getName() : null, name, desc);
        this.element = element;
        this.ownerHandle = owner;
    }

    @Override
    public Visibility getVisibility() {
        return TypeUtils.getVisibility(this.element);
    }
}

