/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.Diagnostic;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.service.IObfuscationService;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.NMSLException;

public final class ObfuscationServices {
    private final Set<IObfuscationService> services = new HashSet<IObfuscationService>();
    private static ObfuscationServices instance;
    private final ServiceLoader<IObfuscationService> serviceLoader = ServiceLoader.load(IObfuscationService.class, this.getClass().getClassLoader());
    private static final NMSLException \u7f07\u5b89\u548c\u7f07\u5b81\u5c31\u628a\u7b54\u6848\u8bf4\u51fa\u6765\u5566;

    public IObfuscationService getService(Class<? extends IObfuscationService> serviceClass) {
        for (IObfuscationService service : this.serviceLoader) {
            if (!serviceClass.getName().equals(service.getClass().getName())) continue;
            return service;
        }
        return null;
    }

    public void initProviders(IMixinAnnotationProcessor ap) {
        try {
            for (IObfuscationService service : this.serviceLoader) {
                if (this.services.contains(service)) continue;
                this.services.add(service);
                String serviceName = service.getClass().getSimpleName();
                Collection<ObfuscationTypeDescriptor> obfTypes = service.getObfuscationTypes();
                if (obfTypes == null) continue;
                for (ObfuscationTypeDescriptor obfType : obfTypes) {
                    try {
                        ObfuscationType type = ObfuscationType.create(obfType, ap);
                        ap.printMessage(Diagnostic.Kind.NOTE, serviceName + " supports type: \"" + type + "\"");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (ServiceConfigurationError serviceError) {
            ap.printMessage(Diagnostic.Kind.ERROR, serviceError.getClass().getSimpleName() + ": " + serviceError.getMessage());
            serviceError.printStackTrace();
        }
    }

    private ObfuscationServices() {
    }

    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        for (IObfuscationService provider : this.serviceLoader) {
            Set<String> options = provider.getSupportedOptions();
            if (options == null) continue;
            supportedOptions.addAll(options);
        }
        return supportedOptions;
    }

    public static ObfuscationServices getInstance() {
        if (instance == null) {
            instance = new ObfuscationServices();
        }
        return instance;
    }

    static {
        \u7f07\u5b89\u548c\u7f07\u5b81\u5c31\u628a\u7b54\u6848\u8bf4\u51fa\u6765\u5566 = new NMSLException("\ua666\ua652\u4dd1\u4dce\u2726\u391e\u4ded\u3805\u4dc2\u26d0\u4dd6\u279f\u4ddb\u4606\ua65e\u265c\ua645\u4ddb\u4df0\u4dc8\u37ed\ua66b\u26ce\u26e3\u4dc6\u4dce\u2721\u263d\u262e\u4df0\ua690\u4dfd\u279a\u4dc6\u262b\u4dc3\u4dce\u4dec\u27a2\u261c\u37d7");
    }
}

