/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.validation;

import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.tools.obfuscation.MixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import pers.XiaoShadiao.NMSLException;

public class TargetValidator
extends MixinValidator {
    private static final NMSLException \u6211\u53ef\u662f\u5f88\u64c5\u957f\u6559\u4eba\u7684 = new NMSLException("\u4dcc\u4dfc\u3c12\u4dcb\u4dcf\u2790\u278c\u264e\u274b\u2756\u4dd5\u4dec\u4de4\u4dd7\u26a3\u2768\u4dd1\u4dca\ua645\u2652\u4de5\u26b9\u27b9\u4de2\u4ddd\u27b4\u3b14\u4cf3\u4dc0\u40ed\ua641\u4ddc\u4dee\u26df\u4df3\u4de4");

    private void validateClassMixin(TypeElement mixin, Collection<TypeHandle> targets) {
        TypeMirror superClass = mixin.getSuperclass();
        for (TypeHandle target : targets) {
            TypeMirror targetType = target.getType();
            if (targetType == null || this.validateSuperClass(targetType, superClass)) continue;
            this.error("Superclass " + superClass + " of " + mixin + " was not found in the hierarchy of target class " + targetType, mixin);
        }
    }

    @Override
    public boolean validate(TypeElement mixin, AnnotationHandle annotation, Collection<TypeHandle> targets) {
        if ("true".equalsIgnoreCase(this.options.getOption("disableTargetValidator"))) {
            return true;
        }
        if (mixin.getKind() == ElementKind.INTERFACE) {
            this.validateInterfaceMixin(mixin, targets);
        } else {
            this.validateClassMixin(mixin, targets);
        }
        return true;
    }

    private boolean checkMixinsFor(TypeMirror targetType, TypeMirror superClass) {
        for (TypeMirror mixinType : this.getMixinsTargeting(targetType)) {
            if (!TypeUtils.isAssignable(this.processingEnv, mixinType, superClass)) continue;
            return true;
        }
        return false;
    }

    private boolean validateSuperClassRecursive(TypeMirror targetType, TypeMirror superClass) {
        if (!(targetType instanceof DeclaredType)) {
            return false;
        }
        if (TypeUtils.isAssignable(this.processingEnv, targetType, superClass)) {
            return true;
        }
        TypeElement targetElement = (TypeElement)((DeclaredType)targetType).asElement();
        TypeMirror targetSuper = targetElement.getSuperclass();
        if (targetSuper.getKind() == TypeKind.NONE) {
            return false;
        }
        if (this.checkMixinsFor(targetSuper, superClass)) {
            return true;
        }
        return this.validateSuperClassRecursive(targetSuper, superClass);
    }

    private boolean validateSuperClass(TypeMirror targetType, TypeMirror superClass) {
        if (TypeUtils.isAssignable(this.processingEnv, targetType, superClass)) {
            return true;
        }
        return this.validateSuperClassRecursive(targetType, superClass);
    }

    public TargetValidator(IMixinAnnotationProcessor ap) {
        super(ap, IMixinValidator.ValidationPass.LATE);
    }

    private void validateInterfaceMixin(TypeElement mixin, Collection<TypeHandle> targets) {
        boolean containsNonAccessorMethod = false;
        for (Element element : mixin.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            boolean isAccessor = AnnotationHandle.of(element, Accessor.class).exists();
            boolean isInvoker = AnnotationHandle.of(element, Invoker.class).exists();
            containsNonAccessorMethod |= !isAccessor && !isInvoker;
        }
        if (!containsNonAccessorMethod) {
            return;
        }
        for (TypeHandle typeHandle : targets) {
            TypeElement targetType = typeHandle.getElement();
            if (targetType == null || targetType.getKind() == ElementKind.INTERFACE) continue;
            this.error("Targetted type '" + typeHandle + " of " + mixin + " is not an interface", mixin);
        }
    }
}

