/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javazoom.jl.converter.WaveFileObuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;
import pers.XiaoShadiao.NMSLException;

public class Converter {
    private static final NMSLException \u795e\u8c15\u4e5f\u4e0d\u4f1a\u5b9e\u73b0 = new NMSLException("\u2717\u4ddf\u2714\u4df9\u4dc8\u4df8\u2655\ua644\u42ec\u4dec\u4dfc\ua67b\u4df8\u4dd5\u4dfb\u4dd0\u4de4\u2797\u2764\u422c\u4df8\u274d\u4df5\u4df2\u4de8\u2728\u4de3\u4dd3\u4dc3\ua658\u4dd3\u4de8\u27a9\u3605");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(InputStream sourceStream, String destName, ProgressListener progressListener, Decoder.Params decoderParams) throws JavaLayerException {
        if (progressListener == null) {
            progressListener = PrintWriterProgressListener.newStdOut(0);
        }
        try {
            int frame;
            if (!(sourceStream instanceof BufferedInputStream)) {
                sourceStream = new BufferedInputStream(sourceStream);
            }
            int frameCount = -1;
            if (sourceStream.markSupported()) {
                sourceStream.mark(-1);
                frameCount = this.countFrames(sourceStream);
                sourceStream.reset();
            }
            progressListener.converterUpdate(1, frameCount, 0);
            Obuffer output = null;
            Decoder decoder = new Decoder(decoderParams);
            Bitstream stream = new Bitstream(sourceStream);
            if (frameCount == -1) {
                frameCount = Integer.MAX_VALUE;
            }
            long startTime = System.currentTimeMillis();
            try {
                for (frame = 0; frame < frameCount; ++frame) {
                    try {
                        Obuffer decoderOutput;
                        Header header = stream.readFrame();
                        if (header == null) {
                            break;
                        }
                        progressListener.readFrame(frame, header);
                        if (output == null) {
                            int channels = header.mode() == 3 ? 1 : 2;
                            int freq = header.frequency();
                            output = new WaveFileObuffer(channels, freq, destName);
                            decoder.setOutputBuffer(output);
                        }
                        if ((decoderOutput = decoder.decodeFrame(header, stream)) != output) {
                            throw new InternalError("Output buffers are different.");
                        }
                        progressListener.decodedFrame(frame, header, output);
                        stream.closeFrame();
                        continue;
                    }
                    catch (Exception ex) {
                        boolean stop;
                        boolean bl = stop = !progressListener.converterException(ex);
                        if (!stop) continue;
                        throw new JavaLayerException(ex.getLocalizedMessage(), ex);
                    }
                }
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
            int time = (int)(System.currentTimeMillis() - startTime);
            progressListener.converterUpdate(2, time, frame);
        }
        catch (IOException ex) {
            throw new JavaLayerException(ex.getLocalizedMessage(), ex);
        }
    }

    public synchronized void convert(String sourceName, String destName) throws JavaLayerException {
        this.convert(sourceName, destName, null, null);
    }

    public void convert(String sourceName, String destName, ProgressListener progressListener, Decoder.Params decoderParams) throws JavaLayerException {
        if (destName.length() == 0) {
            destName = null;
        }
        try {
            InputStream in = this.openInput(sourceName);
            this.convert(in, destName, progressListener, decoderParams);
            in.close();
        }
        catch (IOException ioe) {
            throw new JavaLayerException(ioe.getLocalizedMessage(), ioe);
        }
    }

    protected InputStream openInput(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream fileIn = new FileInputStream(file);
        BufferedInputStream bufIn = new BufferedInputStream(fileIn);
        return bufIn;
    }

    public synchronized void convert(String sourceName, String destName, ProgressListener progressListener) throws JavaLayerException {
        this.convert(sourceName, destName, progressListener, null);
    }

    protected int countFrames(InputStream in) {
        return -1;
    }

    public static class PrintWriterProgressListener
    implements ProgressListener {
        public static final int NO_DETAIL = 0;
        public static final int VERBOSE_DETAIL = 2;
        private PrintWriter pw;
        private int detailLevel;
        public static final int MAX_DETAIL = 10;
        public static final int EXPERT_DETAIL = 1;
        public static final int DEBUG_DETAIL = 7;
        private static final NMSLException \u4e58\u7740\u897f\u98ce = new NMSLException("\u4dd2\ua65d\u3fef\u46a1\u4dd5\u26bd\u4c1d\u4dc6\u4ddd\u273a\u26de\u4dc2\u4dcc\u3ee0\u4dd9\u4de9\u4dfc\ua690\u4de5\u4de7\ua69c\u2766\u4dd0\u4569\u26af\u26c3\u4dfd\u4de7\ua696\u2799\ua678\u4dfb\u2654\u4de9\u26aa\u2681\u4dd3\u4dca\u2793\u4dfc\u4de2\u2750\u2753");

        @Override
        public void decodedFrame(int frameNo, Header header, Obuffer o) {
            if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Decoded frame " + frameNo + ": " + headerString);
                this.pw.println("Output: " + o);
            } else if (this.isDetail(2)) {
                if (frameNo == 0) {
                    this.pw.print("Converting.");
                    this.pw.flush();
                }
                if (frameNo % 10 == 0) {
                    this.pw.print('.');
                    this.pw.flush();
                }
            }
        }

        public PrintWriterProgressListener(PrintWriter writer, int detailLevel) {
            this.pw = writer;
            this.detailLevel = detailLevel;
        }

        @Override
        public void parsedFrame(int frameNo, Header header) {
            if (frameNo == 0 && this.isDetail(2)) {
                String headerString = header.toString();
                this.pw.println("File is a " + headerString);
            } else if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Prased frame " + frameNo + ": " + headerString);
            }
        }

        @Override
        public void readFrame(int frameNo, Header header) {
            if (frameNo == 0 && this.isDetail(2)) {
                String headerString = header.toString();
                this.pw.println("File is a " + headerString);
            } else if (this.isDetail(10)) {
                String headerString = header.toString();
                this.pw.println("Read frame " + frameNo + ": " + headerString);
            }
        }

        public static PrintWriterProgressListener newStdOut(int detail) {
            return new PrintWriterProgressListener(new PrintWriter(System.out, true), detail);
        }

        @Override
        public boolean converterException(Throwable t) {
            if (this.detailLevel > 0) {
                t.printStackTrace(this.pw);
                this.pw.flush();
            }
            return false;
        }

        public boolean isDetail(int detail) {
            return this.detailLevel >= detail;
        }

        @Override
        public void converterUpdate(int updateID, int param1, int param2) {
            if (this.isDetail(2)) {
                switch (updateID) {
                    case 2: {
                        if (param2 == 0) {
                            param2 = 1;
                        }
                        this.pw.println();
                        this.pw.println("Converted " + param2 + " frames in " + param1 + " ms (" + param1 / param2 + " ms per frame.)");
                    }
                }
            }
        }
    }

    public static interface ProgressListener {
        public static final int UPDATE_CONVERT_COMPLETE = 2;
        public static final int UPDATE_FRAME_COUNT = 1;

        public void parsedFrame(int var1, Header var2);

        public void decodedFrame(int var1, Header var2, Obuffer var3);

        public void converterUpdate(int var1, int var2, int var3);

        public void readFrame(int var1, Header var2);

        public boolean converterException(Throwable var1);
    }
}

