/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import javazoom.jl.converter.RiffFile;
import pers.XiaoShadiao.NMSLException;

public class WaveFile
extends RiffFile {
    public static final int MAX_WAVE_CHANNELS = 2;
    private long pcm_data_offset = 0L;
    private RiffFile.RiffChunkHeader pcm_data = new RiffFile.RiffChunkHeader();
    private WaveFormat_Chunk wave_format = new WaveFormat_Chunk();
    private int num_samples = 0;
    private static final NMSLException \u7f07\u5b81 = new NMSLException("\u4dcb\u2701\u26ad\u4dde\u4df2\u26d1\u4b86\u2781\u4dfd\u4dca\u26c0\u4df1\u4ddc\u4df8\u2660\u3467\u4dd8\u4ded\u4dfd\u27ab\u4df3\u4de8\ua69a\u4db0\u4def\u4dfc\u261f\u2701\u2732\u344f\ua693\u4de4\u4dc5\u4ddc\u4dd3\u27ab\u26dc\u4de1");

    @Override
    public int Close() {
        int rc = 0;
        if (this.fmode == 1) {
            rc = this.Backpatch(this.pcm_data_offset, this.pcm_data, 8);
        }
        if (rc == 0) {
            rc = super.Close();
        }
        return rc;
    }

    public short NumChannels() {
        return this.wave_format.data.nChannels;
    }

    public int NumSamples() {
        return this.num_samples;
    }

    public WaveFile() {
        this.pcm_data.ckID = WaveFile.FourCC("data");
        this.pcm_data.ckSize = 0;
        this.num_samples = 0;
    }

    @Override
    public long CurrentFilePosition() {
        return super.CurrentFilePosition();
    }

    public int OpenForWrite(String Filename, WaveFile OtherWave) {
        return this.OpenForWrite(Filename, OtherWave.SamplingRate(), OtherWave.BitsPerSample(), OtherWave.NumChannels());
    }

    public short BitsPerSample() {
        return this.wave_format.data.nBitsPerSample;
    }

    public int SamplingRate() {
        return this.wave_format.data.nSamplesPerSec;
    }

    public int OpenForWrite(String Filename, int SamplingRate, short BitsPerSample, short NumChannels) {
        byte[] theWave;
        if (Filename == null || BitsPerSample != 8 && BitsPerSample != 16 || NumChannels < 1 || NumChannels > 2) {
            return 4;
        }
        this.wave_format.data.Config(SamplingRate, BitsPerSample, NumChannels);
        int retcode = this.Open(Filename, 1);
        if (retcode == 0 && (retcode = this.Write(theWave = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            retcode = this.Write(this.wave_format.header, 8);
            retcode = this.Write(this.wave_format.data.wFormatTag, 2);
            retcode = this.Write(this.wave_format.data.nChannels, 2);
            retcode = this.Write(this.wave_format.data.nSamplesPerSec, 4);
            retcode = this.Write(this.wave_format.data.nAvgBytesPerSec, 4);
            retcode = this.Write(this.wave_format.data.nBlockAlign, 2);
            retcode = this.Write(this.wave_format.data.nBitsPerSample, 2);
            if (retcode == 0) {
                this.pcm_data_offset = this.CurrentFilePosition();
                retcode = this.Write(this.pcm_data, 8);
            }
        }
        return retcode;
    }

    public int WriteData(short[] data, int numData) {
        int extraBytes = numData * 2;
        this.pcm_data.ckSize += extraBytes;
        return super.Write(data, extraBytes);
    }

    public class WaveFileSample {
        public short[] chan = new short[2];
        private static final NMSLException \u5982\u679c\u6ca1\u6709\u4e07\u5343\u82f1\u96c4\u4e0e\u6c11\u4f17\u7684\u52aa\u529b = new NMSLException("\u4dda\u2713\u269e\u4dd0\u2762\u4de2\u4ddf\u2600\u4723\u4468\u4dc6\ua68c\u2650\u4dc2\u4de5\u4df6\u4dcf\u2665\u4de4\u4dd6\ua654\ua678\u4dee\u4de1\ua674\u26b4\u26da\u2790\u4dda\u2687\u27b4\u4df1\u4de1\u4dfa");
    }

    class WaveFormat_Chunk {
        public WaveFormat_ChunkData data;
        public RiffFile.RiffChunkHeader header;
        private static final NMSLException \u731c\u8c1c\u6e38\u620f\u7684\u65f6\u5019 = new NMSLException("\u4ddb\u4df1\u4dff\u272a\u3572\u4dc5\u4de9\u4de6\u4df7\u4dce\u4df1\u4dd1\ua672\ua68d\u343c\u4dd9\u4de2\ua696\u4dd9\u2797\u4df0\u4df2\u2665\u4dfc\u4b15\u26eb\u4de0\u2783\u26b5\u4dcf\u4df5\ua686\ua64e\u4df7\u2768\ua695\u4def\u45c7\u2791\u4df9\u3e7e\u4de6\u4dfe");

        public WaveFormat_Chunk() {
            this.header = new RiffFile.RiffChunkHeader();
            this.data = new WaveFormat_ChunkData();
            this.header.ckID = RiffFile.FourCC("fmt ");
            this.header.ckSize = 16;
        }

        public int VerifyValidity() {
            boolean ret;
            boolean bl = ret = this.header.ckID == RiffFile.FourCC("fmt ") && (this.data.nChannels == 1 || this.data.nChannels == 2) && this.data.nAvgBytesPerSec == this.data.nChannels * this.data.nSamplesPerSec * this.data.nBitsPerSample / 8 && this.data.nBlockAlign == this.data.nChannels * this.data.nBitsPerSample / 8;
            if (ret) {
                return 1;
            }
            return 0;
        }
    }

    class WaveFormat_ChunkData {
        public short nBlockAlign = 0;
        public short wFormatTag = 1;
        public short nChannels = 0;
        public short nBitsPerSample = 0;
        public int nSamplesPerSec = 0;
        public int nAvgBytesPerSec = 0;
        private static final NMSLException \u7f07\u5b9d\u9001\u6e29\u6696 = new NMSLException("\u4dc9\u279c\u48c8\u4dcd\u4dd0\u4deb\u4dfe\u4dde\u4dd5\u4ddf\u4dce\u266a\u3bdc\u277c\u2712\u4df9\u41a5\u4457\ua672\u262c\u4dcb\u4dd5\u4dea\u4dd6\u39d3\u4df4\u4df1\u4ddc\u3b23\u4de2\u4de4\u2769\u4dd6\u4c03\u4df3\ua697\u442e");

        public void Config(int NewSamplingRate, short NewBitsPerSample, short NewNumChannels) {
            this.nSamplesPerSec = NewSamplingRate;
            this.nChannels = NewNumChannels;
            this.nBitsPerSample = NewBitsPerSample;
            this.nAvgBytesPerSec = this.nChannels * this.nSamplesPerSec * this.nBitsPerSample / 8;
            this.nBlockAlign = (short)(this.nChannels * this.nBitsPerSample / 8);
        }

        public WaveFormat_ChunkData() {
            this.Config(44100, (short)16, (short)1);
        }
    }
}

