/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.DecoderErrors;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder;
import javazoom.jl.decoder.LayerIIIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.OutputChannels;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

public class Decoder
implements DecoderErrors {
    private Obuffer output;
    private Params params;
    private LayerIIDecoder l2decoder;
    private SynthesisFilter filter2;
    private static final Params DEFAULT_PARAMS;
    private int outputChannels;
    private boolean initialized;
    private Equalizer equalizer = new Equalizer();
    private LayerIIIDecoder l3decoder;
    private int outputFrequency;
    private LayerIDecoder l1decoder;
    private SynthesisFilter filter1;
    private static final NMSLException \u6342\u8033\u6735;

    public Decoder(Params params0) {
        if (params0 == null) {
            params0 = DEFAULT_PARAMS;
        }
        this.params = params0;
        Equalizer eq = this.params.getInitialEqualizerSettings();
        if (eq != null) {
            this.equalizer.setFrom(eq);
        }
    }

    protected DecoderException newDecoderException(int errorcode) {
        return new DecoderException(errorcode, null);
    }

    public void setEqualizer(Equalizer eq) {
        if (eq == null) {
            eq = Equalizer.PASS_THRU_EQ;
        }
        this.equalizer.setFrom(eq);
        float[] factors = this.equalizer.getBandFactors();
        if (this.filter1 != null) {
            this.filter1.setEQ(factors);
        }
        if (this.filter2 != null) {
            this.filter2.setEQ(factors);
        }
    }

    public void setOutputBuffer(Obuffer out) {
        this.output = out;
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException(513, null);
        }
        return decoder;
    }

    public Obuffer decodeFrame(Header header, Bitstream stream) throws DecoderException {
        if (!this.initialized) {
            this.initialize(header);
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, stream, layer);
        decoder.decodeFrame();
        this.output.write_buffer(1);
        return this.output;
    }

    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    static {
        \u6342\u8033\u6735 = new NMSLException("\ua68a\u4de3\u4dc0\u4de4\u4dc0\u4dc7\u4dd3\u2654\u267f\u3c37\u275f\u4df2\u4dd0\u4dd3\u26f6\u4dfc\u4de9\u272b\u4de7\u26da\u4def\u4dc4\u26e5\u277c\ua64d\u4dfa\u4dd6\u27a6\u2781\u4def\u4de3\u4de3\u4df3\u2662\u4df5\u4c74\ua685\u4dfb\u26a9\ua679\u4dd4\ua67c\u4df7\u4dd0\u266b\u49a6\u2789\u4dde\u4dd5");
        DEFAULT_PARAMS = new Params();
    }

    public int getOutputBlockSize() {
        return 2304;
    }

    public int getOutputChannels() {
        return this.outputChannels;
    }

    protected DecoderException newDecoderException(int errorcode, Throwable throwable) {
        return new DecoderException(errorcode, throwable);
    }

    public Decoder() {
        this(null);
    }

    private void initialize(Header header) throws DecoderException {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int layer = header.layer();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(header.frequency(), channels);
        }
        float[] factors = this.equalizer.getBandFactors();
        this.filter1 = new SynthesisFilter(0, scalefactor, factors);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor, factors);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    public static Params getDefaultParams() {
        return (Params)DEFAULT_PARAMS.clone();
    }

    public static class Params
    implements Cloneable {
        private OutputChannels outputChannels = OutputChannels.BOTH;
        private Equalizer equalizer = new Equalizer();
        private static final NMSLException \u7ed9\u4f60\u4e00\u4e2a\u5927\u62c7\u6307 = new NMSLException("\ua650\ua688\u4dfa\u27bf\u4dd7\u270e\u4dc8\u4deb\u4df3\u4dce\u4ddf\ua644\u274b\u4dd6\u276d\u4dcc\u260e\u4dfc\u4df1\u4dd0\u3d47\u4dc0\u273b\u4dea\u4ddc\ua687\u4dd3\u4dc3\u274d\u4712\u4ded\u4dfc\ua65a\u4dc3\u2747\u37a4\u4de3\u4dc4\u2786");

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(this + ": " + ex);
            }
        }

        public void setOutputChannels(OutputChannels out) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.outputChannels = out;
        }

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }
    }
}

