/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import pers.XiaoShadiao.NMSLException;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private static final int BANDS = 32;
    private final float[] settings = new float[32];
    public static final Equalizer PASS_THRU_EQ;
    private static final NMSLException \u9010\u706b\u4e4b\u65c5\u5df2\u7ecf\u5f00\u542f\u5f88\u4e45\u5566;

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        int max = 32;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    float getBandFactor(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f = (float)Math.pow(2.0, eq);
        return f;
    }

    static {
        \u9010\u706b\u4e4b\u65c5\u5df2\u7ecf\u5f00\u542f\u5f88\u4e45\u5566 = new NMSLException("\u462e\u4de1\u4df0\u4dc5\u4de8\u2766\u4dda\u4dc8\u4dd3\ua687\u4de1\u2797\ua698\u4dd3\u27a3\u2629\u4dce\u4a04\u4ddf\ua672\u4dc3\u4ded\u4b09\u46d4\u4de6\u4de2\u4dc3\u4dd0\u4de3\u4dc1\ua64c\u4dc2\u262f");
        PASS_THRU_EQ = new Equalizer();
    }

    public Equalizer() {
    }

    public int getBandCount() {
        return this.settings.length;
    }

    public float setBand(int band, float neweq) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
            this.settings[band] = this.limit(neweq);
        }
        return eq;
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        if (eq < -1.0f) {
            return -1.0f;
        }
        return eq;
    }

    public Equalizer(EQFunction eq) {
        this.setFrom(eq);
    }

    public void setFrom(float[] eq) {
        this.reset();
        int max = eq.length > 32 ? 32 : eq.length;
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public float getBand(int band) {
        float eq = 0.0f;
        if (band >= 0 && band < 32) {
            eq = this.settings[band];
        }
        return eq;
    }

    float[] getBandFactors() {
        float[] factors = new float[32];
        int maxCount = 32;
        for (int i = 0; i < maxCount; ++i) {
            factors[i] = this.getBandFactor(this.settings[i]);
        }
        return factors;
    }

    public Equalizer(float[] settings) {
        this.setFrom(settings);
    }

    public static abstract class EQFunction {
        private static final NMSLException \u4e0d\u6015\u4e0d\u6015 = new NMSLException("\u4dd3\u4df5\u4dfc\ua697\u26c8\u3993\u2622\u26e6\u278c\u4dd8\u2608\u4dcc\u4df3\u27b5\u4dcf\u26aa\u2670\ua691\u2687\u27b4\u2676\u485e\u4de6\u4df3\ua640\u4ddd\u4dea\u4de3\u4dfa\u279f\u4dca\u274f\u4a8c");

        public float getBand(int band) {
            return 0.0f;
        }
    }
}

