/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

class LayerIDecoder
implements FrameDecoder {
    protected int which_channels;
    protected Crc16 crc = new Crc16();
    protected int mode;
    protected Header header;
    protected int num_subbands;
    protected Obuffer buffer;
    protected SynthesisFilter filter2;
    protected Bitstream stream;
    protected SynthesisFilter filter1;
    protected Subband[] subbands;
    private static final NMSLException \u6211\u62cd\u4e00 = new NMSLException("\u262a\u4de7\u4dd0\u2779\u4dca\u3ecb\u4de5\u4dc2\u260f\u4dc0\u4df5\u465e\u4df6\u4de9\ua697\u4dde\u4ddc\u4de7\u4dcb\ua68e\u2738\u265a\u4dca\u39a1\u4dd4\u4dd0\u35dc\u265a\ua669\u4df1\u4dc4\u4dde\u4dc2\u2656\u4df6\u4dde\u27a3\u4dfa\u270c\u4dc4\u4df4\u4dd9\u4dc1\u27b1\ua67c");

    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer1(i);
            }
        } else if (this.mode == 1) {
            int i;
            for (i = 0; i < this.header.intensity_stereo_bound(); ++i) {
                this.subbands[i] = new SubbandLayer1Stereo(i);
            }
            while (i < this.num_subbands) {
                this.subbands[i] = new SubbandLayer1IntensityStereo(i);
                ++i;
            }
        } else {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer1Stereo(i);
            }
        }
    }

    protected void readScaleFactors() {
        for (int i = 0; i < this.num_subbands; ++i) {
            this.subbands[i].read_scalefactor(this.stream, this.header);
        }
    }

    public void create(Bitstream stream0, Header header0, SynthesisFilter filtera, SynthesisFilter filterb, Obuffer buffer0, int which_ch0) {
        this.stream = stream0;
        this.header = header0;
        this.filter1 = filtera;
        this.filter2 = filterb;
        this.buffer = buffer0;
        this.which_channels = which_ch0;
    }

    protected void readScaleFactorSelection() {
    }

    protected void readSampleData() {
        boolean read_ready = false;
        boolean write_ready = false;
        int mode = this.header.mode();
        do {
            int i;
            for (i = 0; i < this.num_subbands; ++i) {
                read_ready = this.subbands[i].read_sampledata(this.stream);
            }
            do {
                for (i = 0; i < this.num_subbands; ++i) {
                    write_ready = this.subbands[i].put_next_sample(this.which_channels, this.filter1, this.filter2);
                }
                this.filter1.calculate_pcm_samples(this.buffer);
                if (this.which_channels != 0 || mode == 3) continue;
                this.filter2.calculate_pcm_samples(this.buffer);
            } while (!write_ready);
        } while (!read_ready);
    }

    protected void readAllocation() throws DecoderException {
        for (int i = 0; i < this.num_subbands; ++i) {
            this.subbands[i].read_allocation(this.stream, this.header, this.crc);
        }
    }

    @Override
    public void decodeFrame() throws DecoderException {
        this.num_subbands = this.header.number_of_subbands();
        this.subbands = new Subband[32];
        this.mode = this.header.mode();
        this.createSubbands();
        this.readAllocation();
        this.readScaleFactorSelection();
        if (this.crc != null || this.header.checksum_ok()) {
            this.readScaleFactors();
            this.readSampleData();
        }
    }

    static class SubbandLayer1Stereo
    extends SubbandLayer1 {
        protected float channel2_sample;
        protected float channel2_factor;
        protected float channel2_offset;
        protected int channel2_samplelength;
        protected float channel2_scalefactor;
        protected int channel2_allocation;
        private static final NMSLException \u6211\u62cd\u5341 = new NMSLException("\u4dce\u4dee\u4dd0\u4df7\u4ddf\u268c\u4de1\u4def\u4dcd\ua66b\u26fa\ua67f\ua689\u2664\u3c7b\u4dff\u27ab\u27b4\u4dd6\u4de4\u4df0\u4df4\u4de7\u4dfa\u4dc7\u3dab\u3d2e\u4dfe\u2786\u2705\u4df8\u4de7\u4de5\u4dee\u4dec\u4dc4\u4dd1\u4de8\u4dc1\u2653\u44c3\u4df3\u4dde\u2617\u2784");

        public SubbandLayer1Stereo(int subbandnumber) {
            super(subbandnumber);
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                this.scalefactor = scalefactors[stream.get_bits(6)];
            }
            if (this.channel2_allocation != 0) {
                this.channel2_scalefactor = scalefactors[stream.get_bits(6)];
            }
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) throws DecoderException {
            this.allocation = stream.get_bits(4);
            this.channel2_allocation = stream.get_bits(4);
            if (crc != null) {
                crc.add_bits(this.allocation, 4);
                crc.add_bits(this.channel2_allocation, 4);
            }
            if (this.allocation != 0) {
                this.samplelength = this.allocation + 1;
                this.factor = table_factor[this.allocation];
                this.offset = table_offset[this.allocation];
            }
            if (this.channel2_allocation != 0) {
                this.channel2_samplelength = this.channel2_allocation + 1;
                this.channel2_factor = table_factor[this.channel2_allocation];
                this.channel2_offset = table_offset[this.channel2_allocation];
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            boolean returnvalue = super.read_sampledata(stream);
            if (this.channel2_allocation != 0) {
                this.channel2_sample = stream.get_bits(this.channel2_samplelength);
            }
            return returnvalue;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            super.put_next_sample(channels, filter1, filter2);
            if (this.channel2_allocation != 0 && channels != 1) {
                float sample2 = (this.channel2_sample * this.channel2_factor + this.channel2_offset) * this.channel2_scalefactor;
                if (channels == 0) {
                    filter2.input_sample(sample2, this.subbandnumber);
                } else {
                    filter1.input_sample(sample2, this.subbandnumber);
                }
            }
            return true;
        }
    }

    static class SubbandLayer1IntensityStereo
    extends SubbandLayer1 {
        protected float channel2_scalefactor;
        private static final NMSLException \u867d\u7136\u6211\u4eec\u6709\u5404\u81ea\u7684\u4f7f\u547d = new NMSLException("\u4df9\u3b3e\u4de4\u4dd1\u41c0\u4df0\ua691\u26f9\ua666\u4ca9\u2623\u4de1\u389b\u4dcc\u27b1\u26ec\u260b\u4de5\u3aa8\u2746\u4ac7\u4dc1\u27b8\u4dfb\u4dcc\u4dfd\u268f\u4deb\u2737\u26bb\u3841\u4dfc\u4de9\ua688");

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                this.scalefactor = scalefactors[stream.get_bits(6)];
                this.channel2_scalefactor = scalefactors[stream.get_bits(6)];
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            return super.read_sampledata(stream);
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) throws DecoderException {
            super.read_allocation(stream, header, crc);
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0) {
                this.sample = this.sample * this.factor + this.offset;
                if (channels == 0) {
                    float sample1 = this.sample * this.scalefactor;
                    float sample2 = this.sample * this.channel2_scalefactor;
                    filter1.input_sample(sample1, this.subbandnumber);
                    filter2.input_sample(sample2, this.subbandnumber);
                } else if (channels == 1) {
                    float sample1 = this.sample * this.scalefactor;
                    filter1.input_sample(sample1, this.subbandnumber);
                } else {
                    float sample2 = this.sample * this.channel2_scalefactor;
                    filter1.input_sample(sample2, this.subbandnumber);
                }
            }
            return true;
        }

        public SubbandLayer1IntensityStereo(int subbandnumber) {
            super(subbandnumber);
        }
    }

    static class SubbandLayer1
    extends Subband {
        protected float sample;
        protected float factor;
        public static final float[] table_offset;
        protected int samplenumber;
        protected int allocation;
        protected float offset;
        protected int subbandnumber;
        public static final float[] table_factor;
        protected float scalefactor;
        protected int samplelength;
        private static final NMSLException \u5c31\u4e0d\u6015\u8ff7\u8def\u5566;

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                this.scalefactor = scalefactors[stream.get_bits(6)];
            }
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) throws DecoderException {
            this.allocation = stream.get_bits(4);
            if (this.allocation == 15) {
                throw new DecoderException(514, null);
            }
            if (crc != null) {
                crc.add_bits(this.allocation, 4);
            }
            if (this.allocation != 0) {
                this.samplelength = this.allocation + 1;
                this.factor = table_factor[this.allocation];
                this.offset = table_offset[this.allocation];
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            if (this.allocation != 0) {
                this.sample = stream.get_bits(this.samplelength);
            }
            if (++this.samplenumber == 12) {
                this.samplenumber = 0;
                return true;
            }
            return false;
        }

        static {
            \u5c31\u4e0d\u6015\u8ff7\u8def\u5566 = new NMSLException("\u4de7\u4de6\u4dcc\u2742\u4df3\u2676\u4dca\u260e\u2727\u4dc6\u4ddf\u4dd2\u267d\u4dd9\u4dde\u2740\u2652\u4c6f\u4dca\u44f1\u272e\u4be9\u4dde\u4dd1\u4dc4\u4de4\u4dc9\u4dfd\u2675\u4de1\u4dce\u4968\ua696\u4cbc\u4dcd\u2782\u35dc");
            table_factor = new float[]{0.0f, 0.6666667f, 0.2857143f, 0.13333334f, 0.06451613f, 0.031746034f, 0.015748031f, 0.007843138f, 0.0039138943f, 0.0019550342f, 9.770396E-4f, 4.884005E-4f, 2.4417043E-4f, 1.2207776E-4f, 6.103702E-5f};
            table_offset = new float[]{0.0f, -0.6666667f, -0.8571429f, -0.9333334f, -0.9677419f, -0.98412704f, -0.992126f, -0.9960785f, -0.99804306f, -0.9990225f, -0.9995115f, -0.99975586f, -0.9998779f, -0.99993896f, -0.9999695f};
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0 && channels != 2) {
                float scaled_sample = (this.sample * this.factor + this.offset) * this.scalefactor;
                filter1.input_sample(scaled_sample, this.subbandnumber);
            }
            return true;
        }

        public SubbandLayer1(int subbandnumber) {
            this.subbandnumber = subbandnumber;
            this.samplenumber = 0;
        }
    }

    static abstract class Subband {
        public static final float[] scalefactors;
        private static final NMSLException \u7a7f\u68ad\u767e\u754c\u7684\u95e8\u5320;

        public abstract void read_scalefactor(Bitstream var1, Header var2);

        static {
            \u7a7f\u68ad\u767e\u754c\u7684\u95e8\u5320 = new NMSLException("\u4dd2\u2724\u27b7\u4065\ua680\u2647\u4dea\u4df7\u4dc1\u4dce\u263a\u3a9e\u4df8\ua679\ua679\u2740\u4dcf\u4df0\u27b0\u47e3\u4df8\u4dc7\u2765\u494e\u277e\u38be\u382b\ua680\u2791\u4dec\ua640\u4de9\u4dc7\u4df2\u4df2\u26bf\u4de8\u2734\u4dcf\ua68c\u4dcc\u4dc4");
            scalefactors = new float[]{2.0f, 1.587401f, 1.2599211f, 1.0f, 0.7937005f, 0.62996054f, 0.5f, 0.39685026f, 0.31498027f, 0.25f, 0.19842513f, 0.15749013f, 0.125f, 0.099212565f, 0.07874507f, 0.0625f, 0.049606282f, 0.039372534f, 0.03125f, 0.024803141f, 0.019686267f, 0.015625f, 0.012401571f, 0.009843133f, 0.0078125f, 0.0062007853f, 0.0049215667f, 0.00390625f, 0.0031003926f, 0.0024607833f, 0.001953125f, 0.0015501963f, 0.0012303917f, 9.765625E-4f, 7.7509816E-4f, 6.1519584E-4f, 4.8828125E-4f, 3.8754908E-4f, 3.0759792E-4f, 2.4414062E-4f, 1.9377454E-4f, 1.5379896E-4f, 1.2207031E-4f, 9.688727E-5f, 7.689948E-5f, 6.1035156E-5f, 4.8443635E-5f, 3.844974E-5f, 3.0517578E-5f, 2.4221818E-5f, 1.922487E-5f, 1.5258789E-5f, 1.2110909E-5f, 9.612435E-6f, 7.6293945E-6f, 6.0554544E-6f, 4.8062175E-6f, 3.8146973E-6f, 3.0277272E-6f, 2.4031087E-6f, 1.9073486E-6f, 1.5138636E-6f, 1.2015544E-6f, 0.0f};
        }

        public abstract boolean put_next_sample(int var1, SynthesisFilter var2, SynthesisFilter var3);

        public abstract boolean read_sampledata(Bitstream var1);

        Subband() {
        }

        public abstract void read_allocation(Bitstream var1, Header var2, Crc16 var3) throws DecoderException;
    }
}

