/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.SynthesisFilter;
import pers.XiaoShadiao.NMSLException;

class LayerIIDecoder
extends LayerIDecoder
implements FrameDecoder {
    private static final NMSLException \u8be5\u627e\u8c01\u5e2e\u5fd9\u597d = new NMSLException("\u4df8\ua652\u44c1\u4dff\u4dff\u26bf\u266e\u4dc5\u4dfe\u4de4\u4de5\u454e\u4dd6\ua653\u4bad\u276d\u4df9\ua69e\u4dca\ua69d\u2674\u4dc1\u2719\u4dc1\u4df2\u4590\u4df5\u4de0\u3dd1\u3dfd\u4de5\u4dd4\u4dfb\u260c\ua683");

    @Override
    protected void readScaleFactorSelection() {
        for (int i = 0; i < this.num_subbands; ++i) {
            ((SubbandLayer2)this.subbands[i]).read_scalefactor_selection(this.stream, this.crc);
        }
    }

    @Override
    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer2(i);
            }
        } else if (this.mode == 1) {
            int i;
            for (i = 0; i < this.header.intensity_stereo_bound(); ++i) {
                this.subbands[i] = new SubbandLayer2Stereo(i);
            }
            while (i < this.num_subbands) {
                this.subbands[i] = new SubbandLayer2IntensityStereo(i);
                ++i;
            }
        } else {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer2Stereo(i);
            }
        }
    }

    static class SubbandLayer2Stereo
    extends SubbandLayer2 {
        protected int channel2_allocation;
        protected float[] channel2_factor;
        protected float[] channel2_c;
        protected int[] channel2_codelength = new int[]{0};
        protected float channel2_scalefactor3;
        protected float[] channel2_samples;
        protected float[] channel2_d;
        protected int channel2_scfsi;
        protected float channel2_scalefactor2;
        protected float channel2_scalefactor1;
        private static final NMSLException \u6f02\u5440\u6f02\u5440 = new NMSLException("\u4dfa\u27b4\u4def\u271e\u4dd2\u35c5\u4ddb\u4dc7\u4dcf\u262b\u4dcb\u278f\u4def\u2615\u4df5\u4dc4\u4deb\u4df3\u4df6\u4dfa\u279c\u40e8\u4dc5\ua696\ua675\u4ddd\u4de7\u45ef\u37b1\u4deb\u49c5\u26ff\u2715\u4dff\u270b\u4dc8\u4df9\ua653\u4deb\u2758\u4dc7\u4dc0\u4dc0");

        @Override
        public boolean read_sampledata(Bitstream stream) {
            boolean returnvalue = super.read_sampledata(stream);
            if (this.channel2_allocation != 0) {
                if (this.groupingtable[1] != null) {
                    int samplecode = stream.get_bits(this.channel2_codelength[0]);
                    samplecode += samplecode << 1;
                    float[] target = this.channel2_samples;
                    float[] source = this.groupingtable[1];
                    int tmp = 0;
                    int temp = samplecode;
                    target[tmp] = source[temp];
                    target[++tmp] = source[++temp];
                    target[++tmp] = source[++temp];
                } else {
                    this.channel2_samples[0] = (float)((double)((float)stream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                    this.channel2_samples[1] = (float)((double)((float)stream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                    this.channel2_samples[2] = (float)((double)((float)stream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                }
            }
            return returnvalue;
        }

        @Override
        public void read_scalefactor_selection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.scfsi, 2);
                }
            }
            if (this.channel2_allocation != 0) {
                this.channel2_scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.channel2_scfsi, 2);
                }
            }
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) {
            int length = this.get_allocationlength(header);
            this.allocation = stream.get_bits(length);
            this.channel2_allocation = stream.get_bits(length);
            if (crc != null) {
                crc.add_bits(this.allocation, length);
                crc.add_bits(this.channel2_allocation, length);
            }
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            boolean returnvalue = super.put_next_sample(channels, filter1, filter2);
            if (this.channel2_allocation != 0 && channels != 1) {
                float sample = this.channel2_samples[this.samplenumber - 1];
                if (this.groupingtable[1] == null) {
                    sample = (sample + this.channel2_d[0]) * this.channel2_c[0];
                }
                sample = this.groupnumber <= 4 ? (sample *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.channel2_scalefactor2) : (sample *= this.channel2_scalefactor3));
                if (channels == 0) {
                    filter2.input_sample(sample, this.subbandnumber);
                } else {
                    filter1.input_sample(sample, this.subbandnumber);
                }
            }
            return returnvalue;
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            super.read_scalefactor(stream, header);
            if (this.channel2_allocation != 0) {
                switch (this.channel2_scfsi) {
                    case 0: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2_scalefactor1 = this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor1 = this.channel2_scalefactor3;
                        break;
                    }
                    case 3: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.channel2_allocation, 1, this.channel2_factor, this.channel2_codelength, this.channel2_c, this.channel2_d);
            }
        }

        public SubbandLayer2Stereo(int subbandnumber) {
            super(subbandnumber);
            this.channel2_factor = new float[]{0.0f};
            this.channel2_c = new float[]{0.0f};
            this.channel2_d = new float[]{0.0f};
            this.channel2_samples = new float[3];
        }
    }

    static class SubbandLayer2IntensityStereo
    extends SubbandLayer2 {
        protected float channel2_scalefactor1;
        protected int channel2_scfsi;
        protected float channel2_scalefactor2;
        protected float channel2_scalefactor3;
        private static final NMSLException \u8fd9\u4e2a\u5f52\u7f07\u5b9d = new NMSLException("\ua69d\u4ded\u27a4\u4dc0\ua67d\ua68c\u4df8\u4df7\ua687\u4df2\u43f4\u2747\ua65c\u4dd2\u4dda\u26b4\u2654\u4ddc\u2657\u41e4\u4dd3\u4df6\u4dd3\u278b\u4de9\u26a7\u4dec\u275a\u2755\u4dd3\u42be\ua65c\ua661\u4dec");

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0) {
                float sample = this.samples[this.samplenumber];
                if (this.groupingtable[0] == null) {
                    sample = (sample + this.d[0]) * this.c[0];
                }
                if (channels == 0) {
                    float sample2 = sample;
                    if (this.groupnumber <= 4) {
                        sample *= this.scalefactor1;
                        sample2 *= this.channel2_scalefactor1;
                    } else if (this.groupnumber <= 8) {
                        sample *= this.scalefactor2;
                        sample2 *= this.channel2_scalefactor2;
                    } else {
                        sample *= this.scalefactor3;
                        sample2 *= this.channel2_scalefactor3;
                    }
                    filter1.input_sample(sample, this.subbandnumber);
                    filter2.input_sample(sample2, this.subbandnumber);
                } else if (channels == 1) {
                    sample = this.groupnumber <= 4 ? (sample *= this.scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.scalefactor2) : (sample *= this.scalefactor3));
                    filter1.input_sample(sample, this.subbandnumber);
                } else {
                    sample = this.groupnumber <= 4 ? (sample *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.channel2_scalefactor2) : (sample *= this.channel2_scalefactor3));
                    filter1.input_sample(sample, this.subbandnumber);
                }
            }
            return ++this.samplenumber == 3;
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                super.read_scalefactor(stream, header);
                switch (this.channel2_scfsi) {
                    case 0: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2_scalefactor1 = this.channel2_scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor1 = this.channel2_scalefactor3;
                        break;
                    }
                    case 3: {
                        this.channel2_scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[stream.get_bits(6)];
                    }
                }
            }
        }

        public SubbandLayer2IntensityStereo(int subbandnumber) {
            super(subbandnumber);
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) {
            super.read_allocation(stream, header, crc);
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            return super.read_sampledata(stream);
        }

        @Override
        public void read_scalefactor_selection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.get_bits(2);
                this.channel2_scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.scfsi, 2);
                    crc.add_bits(this.channel2_scfsi, 2);
                }
            }
        }
    }

    static class SubbandLayer2
    extends LayerIDecoder.Subband {
        protected float scalefactor3;
        public static final float[] grouping_10bits;
        protected float scalefactor1;
        public static final float[] table_cd_d;
        protected float scalefactor2;
        protected float[] factor;
        public static final float[][] table_ab234_groupingtables;
        public static final float[] table_ab4_factor;
        public static final float[] table_ab3_c;
        public static final float[] table_ab1_c;
        protected float[][] groupingtable;
        public static final float[] table_ab4_c;
        public static final float[] table_ab3_d;
        protected float[] d;
        protected int samplenumber;
        public static final int[] table_cd_codelength;
        public static final int[] table_ab2_codelength;
        protected int[] codelength = new int[]{0};
        public static final float[] table_ab2_c;
        public static final int[] table_ab1_codelength;
        protected int allocation;
        public static final float[] table_ab1_d;
        public static final float[] grouping_5bits;
        public static final float[] table_ab2_factor;
        public static final int[] table_ab3_codelength;
        public static final int[] table_ab4_codelength;
        public static final float[] table_ab2_d;
        public static final float[][] table_ab1_groupingtables;
        public static final float[] table_cd_factor;
        protected float[] c;
        protected int groupnumber;
        public static final float[] grouping_7bits;
        protected int subbandnumber;
        public static final float[][] table_cd_groupingtables;
        protected int scfsi;
        public static final float[] table_ab1_factor;
        protected float[] samples;
        public static final float[] table_cd_c;
        public static final float[] table_ab3_factor;
        public static final float[] table_ab4_d;
        private static final NMSLException \u770b\u597d\u7f07\u5b9d\u8001\u5e08\u7684\u52a8\u4f5c;

        public void read_scalefactor_selection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.get_bits(2);
                if (crc != null) {
                    crc.add_bits(this.scfsi, 2);
                }
            }
        }

        static {
            \u770b\u597d\u7f07\u5b9d\u8001\u5e08\u7684\u52a8\u4f5c = new NMSLException("\u274b\u4de2\u2643\u4dfe\u4dd8\u4df0\u26d0\u26f7\u4dd3\u4dc7\u279c\u4ddc\u4dc7\u26de\u2764\u4dc9\u4dd0\u2718\u4de4\u4deb\u2701\u4dc1\u26db\ua685\u262d\u276d\u261e\u2775\u4dc4\ua644\u4977\u4dc8\u4de4\u4df2\u4dd1\u4ddf");
            grouping_5bits = new float[]{-0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f};
            grouping_7bits = new float[]{-0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.4f, -0.8f, -0.4f, 0.0f, -0.8f, -0.4f, 0.4f, -0.8f, -0.4f, 0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.4f, -0.4f, -0.4f, 0.0f, -0.4f, -0.4f, 0.4f, -0.4f, -0.4f, 0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.4f, 0.0f, -0.4f, 0.0f, 0.0f, -0.4f, 0.4f, 0.0f, -0.4f, 0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.4f, 0.4f, -0.4f, 0.0f, 0.4f, -0.4f, 0.4f, 0.4f, -0.4f, 0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.4f, 0.8f, -0.4f, 0.0f, 0.8f, -0.4f, 0.4f, 0.8f, -0.4f, 0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.4f, -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, 0.4f, -0.8f, 0.0f, 0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.4f, -0.4f, 0.0f, 0.0f, -0.4f, 0.0f, 0.4f, -0.4f, 0.0f, 0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.0f, 0.0f, 0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.4f, 0.4f, 0.0f, 0.0f, 0.4f, 0.0f, 0.4f, 0.4f, 0.0f, 0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.4f, 0.8f, 0.0f, 0.0f, 0.8f, 0.0f, 0.4f, 0.8f, 0.0f, 0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.4f, -0.8f, 0.4f, 0.0f, -0.8f, 0.4f, 0.4f, -0.8f, 0.4f, 0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.4f, -0.4f, 0.4f, 0.0f, -0.4f, 0.4f, 0.4f, -0.4f, 0.4f, 0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.4f, 0.0f, 0.4f, 0.0f, 0.0f, 0.4f, 0.4f, 0.0f, 0.4f, 0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.4f, 0.4f, 0.4f, 0.0f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f, 0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.4f, 0.8f, 0.4f, 0.0f, 0.8f, 0.4f, 0.4f, 0.8f, 0.4f, 0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.4f, -0.8f, 0.8f, 0.0f, -0.8f, 0.8f, 0.4f, -0.8f, 0.8f, 0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.4f, -0.4f, 0.8f, 0.0f, -0.4f, 0.8f, 0.4f, -0.4f, 0.8f, 0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.4f, 0.0f, 0.8f, 0.0f, 0.0f, 0.8f, 0.4f, 0.0f, 0.8f, 0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.4f, 0.4f, 0.8f, 0.0f, 0.4f, 0.8f, 0.4f, 0.4f, 0.8f, 0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.4f, 0.8f, 0.8f, 0.0f, 0.8f, 0.8f, 0.4f, 0.8f, 0.8f, 0.8f, 0.8f, 0.8f};
            grouping_10bits = new float[]{-0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f};
            table_ab1_codelength = new int[]{0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            table_ab1_groupingtables = new float[][]{null, grouping_5bits, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
            table_ab1_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f, 3.0517578E-5f};
            table_ab1_c = new float[]{0.0f, 1.3333334f, 1.1428572f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f, 1.0000153f};
            table_ab1_d = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f, 3.051758E-5f};
            table_ab234_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, null, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null};
            table_ab2_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16};
            table_ab2_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.0517578E-5f};
            table_ab2_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.0000153f};
            table_ab2_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.051758E-5f};
            table_ab3_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 16};
            table_ab3_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 3.0517578E-5f};
            table_ab3_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0000153f};
            table_ab3_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 3.051758E-5f};
            table_ab4_codelength = new int[]{0, 5, 7, 16};
            table_ab4_factor = new float[]{0.0f, 0.5f, 0.25f, 3.0517578E-5f};
            table_ab4_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.0000153f};
            table_ab4_d = new float[]{0.0f, 0.5f, 0.5f, 3.051758E-5f};
            table_cd_codelength = new int[]{0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
            table_cd_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null, null};
            table_cd_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f};
            table_cd_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f};
            table_cd_d = new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f};
        }

        @Override
        public void read_allocation(Bitstream stream, Header header, Crc16 crc) {
            int length = this.get_allocationlength(header);
            this.allocation = stream.get_bits(length);
            if (crc != null) {
                crc.add_bits(this.allocation, length);
            }
        }

        protected int get_allocationlength(Header header) {
            if (header.version() == 1) {
                int channel_bitrate = header.bitrate_index();
                if (header.mode() != 3) {
                    channel_bitrate = channel_bitrate == 4 ? 1 : (channel_bitrate -= 4);
                }
                if (channel_bitrate == 1 || channel_bitrate == 2) {
                    if (this.subbandnumber <= 1) {
                        return 4;
                    }
                    return 3;
                }
                if (this.subbandnumber <= 10) {
                    return 4;
                }
                if (this.subbandnumber <= 22) {
                    return 3;
                }
                return 2;
            }
            if (this.subbandnumber <= 3) {
                return 4;
            }
            if (this.subbandnumber <= 10) {
                return 3;
            }
            return 2;
        }

        public SubbandLayer2(int subbandnumber) {
            this.groupingtable = new float[2][];
            this.factor = new float[]{0.0f};
            this.samples = new float[3];
            this.c = new float[]{0.0f};
            this.d = new float[]{0.0f};
            this.subbandnumber = subbandnumber;
            this.samplenumber = 0;
            this.groupnumber = 0;
        }

        protected void prepare_sample_reading(Header header, int allocation, int channel, float[] factor, int[] codelength, float[] c, float[] d) {
            int channel_bitrate = header.bitrate_index();
            if (header.mode() != 3) {
                channel_bitrate = channel_bitrate == 4 ? 1 : (channel_bitrate -= 4);
            }
            if (channel_bitrate == 1 || channel_bitrate == 2) {
                this.groupingtable[channel] = table_cd_groupingtables[allocation];
                factor[0] = table_cd_factor[allocation];
                codelength[0] = table_cd_codelength[allocation];
                c[0] = table_cd_c[allocation];
                d[0] = table_cd_d[allocation];
            } else if (this.subbandnumber <= 2) {
                this.groupingtable[channel] = table_ab1_groupingtables[allocation];
                factor[0] = table_ab1_factor[allocation];
                codelength[0] = table_ab1_codelength[allocation];
                c[0] = table_ab1_c[allocation];
                d[0] = table_ab1_d[allocation];
            } else {
                this.groupingtable[channel] = table_ab234_groupingtables[allocation];
                if (this.subbandnumber <= 10) {
                    factor[0] = table_ab2_factor[allocation];
                    codelength[0] = table_ab2_codelength[allocation];
                    c[0] = table_ab2_c[allocation];
                    d[0] = table_ab2_d[allocation];
                } else if (this.subbandnumber <= 22) {
                    factor[0] = table_ab3_factor[allocation];
                    codelength[0] = table_ab3_codelength[allocation];
                    c[0] = table_ab3_c[allocation];
                    d[0] = table_ab3_d[allocation];
                } else {
                    factor[0] = table_ab4_factor[allocation];
                    codelength[0] = table_ab4_codelength[allocation];
                    c[0] = table_ab4_c[allocation];
                    d[0] = table_ab4_d[allocation];
                }
            }
        }

        @Override
        public boolean read_sampledata(Bitstream stream) {
            if (this.allocation != 0) {
                if (this.groupingtable[0] != null) {
                    int samplecode = stream.get_bits(this.codelength[0]);
                    samplecode += samplecode << 1;
                    float[] target = this.samples;
                    float[] source = this.groupingtable[0];
                    int tmp = 0;
                    int temp = samplecode;
                    if (temp > source.length - 3) {
                        temp = source.length - 3;
                    }
                    target[tmp] = source[temp];
                    target[++tmp] = source[++temp];
                    target[++tmp] = source[++temp];
                } else {
                    this.samples[0] = (float)((double)((float)stream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                    this.samples[1] = (float)((double)((float)stream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                    this.samples[2] = (float)((double)((float)stream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                }
            }
            this.samplenumber = 0;
            return ++this.groupnumber == 12;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0 && channels != 2) {
                float sample = this.samples[this.samplenumber];
                if (this.groupingtable[0] == null) {
                    sample = (sample + this.d[0]) * this.c[0];
                }
                sample = this.groupnumber <= 4 ? (sample *= this.scalefactor1) : (this.groupnumber <= 8 ? (sample *= this.scalefactor2) : (sample *= this.scalefactor3));
                filter1.input_sample(sample, this.subbandnumber);
            }
            return ++this.samplenumber == 3;
        }

        @Override
        public void read_scalefactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                switch (this.scfsi) {
                    case 0: {
                        this.scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.scalefactor1 = this.scalefactor2 = scalefactors[stream.get_bits(6)];
                        this.scalefactor3 = scalefactors[stream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.scalefactor2 = this.scalefactor3 = scalefactors[stream.get_bits(6)];
                        this.scalefactor1 = this.scalefactor3;
                        break;
                    }
                    case 3: {
                        this.scalefactor1 = scalefactors[stream.get_bits(6)];
                        this.scalefactor2 = this.scalefactor3 = scalefactors[stream.get_bits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.allocation, 0, this.factor, this.codelength, this.c, this.d);
            }
        }
    }
}

