/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDeviceBase;
import pers.XiaoShadiao.NMSLException;

public class JavaSoundAudioDevice
extends AudioDeviceBase {
    private AudioFormat fmt = null;
    private SourceDataLine source = null;
    private byte[] byteBuf = new byte[4096];
    private static final NMSLException \u5927\u574f\u86cb = new NMSLException("\u4df9\u26dd\u4dfb\u4deb\u4dfa\u4df8\u4dd3\u2637\u4de4\u4df1\ua64c\u4dd4\u2768\u3ff7\u4de4\u4a46\u2622\ua648\u4ddb\ua64a\u2638\u4df6\u4dfc\u4dca\u4dec\u4dea\u275f\u3fec\u270e\ua64d\u26df\ua67c\ua651\u2721\u4df7\u3780\u3e5c\u4dd2\u266c\u4dcf\u2770");

    public int millisecondsToBytes(AudioFormat fmt, int time) {
        return (int)((double)((float)time * (fmt.getSampleRate() * (float)fmt.getChannels() * (float)fmt.getSampleSizeInBits())) / 8000.0);
    }

    @Override
    protected void openImpl() throws JavaLayerException {
    }

    protected DataLine.Info getSourceLineInfo() {
        AudioFormat fmt = this.getAudioFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
        return info;
    }

    protected byte[] getByteArray(int length) {
        if (this.byteBuf.length < length) {
            this.byteBuf = new byte[length + 1024];
        }
        return this.byteBuf;
    }

    @Override
    protected void closeImpl() {
        if (this.source != null) {
            this.source.close();
        }
    }

    protected void setAudioFormat(AudioFormat fmt0) {
        this.fmt = fmt0;
    }

    @Override
    protected void writeImpl(short[] samples, int offs, int len) throws JavaLayerException {
        if (this.source == null) {
            this.createSource();
        }
        byte[] b = this.toByteArray(samples, offs, len);
        this.source.write(b, 0, len * 2);
    }

    public void test() throws JavaLayerException {
        try {
            this.open(new AudioFormat(22050.0f, 16, 1, true, false));
            short[] data = new short[2205];
            this.write(data, 0, data.length);
            this.flush();
            this.close();
        }
        catch (RuntimeException ex) {
            throw new JavaLayerException("Device test failed: " + ex);
        }
    }

    @Override
    protected void flushImpl() {
        if (this.source != null) {
            this.source.drain();
        }
    }

    protected AudioFormat getAudioFormat() {
        if (this.fmt == null) {
            Decoder decoder = this.getDecoder();
            this.fmt = new AudioFormat(decoder.getOutputFrequency(), 16, decoder.getOutputChannels(), true, false);
        }
        return this.fmt;
    }

    @Override
    public int getPosition() {
        int pos = 0;
        if (this.source != null) {
            pos = (int)(this.source.getMicrosecondPosition() / 1000L);
        }
        return pos;
    }

    public void open(AudioFormat fmt) throws JavaLayerException {
        if (!this.isOpen()) {
            this.setAudioFormat(fmt);
            this.openImpl();
            this.setOpen(true);
        }
    }

    protected byte[] toByteArray(short[] samples, int offs, int len) {
        byte[] b = this.getByteArray(len * 2);
        int idx = 0;
        while (len-- > 0) {
            short s = samples[offs++];
            b[idx++] = (byte)s;
            b[idx++] = (byte)(s >>> 8);
        }
        return b;
    }

    protected void createSource() throws JavaLayerException {
        Throwable t = null;
        try {
            Line line = AudioSystem.getLine(this.getSourceLineInfo());
            if (line instanceof SourceDataLine) {
                this.source = (SourceDataLine)line;
                this.source.open(this.fmt);
                this.source.start();
            }
        }
        catch (RuntimeException ex) {
            t = ex;
        }
        catch (LinkageError ex) {
            t = ex;
        }
        catch (LineUnavailableException ex) {
            t = ex;
        }
        if (this.source == null) {
            throw new JavaLayerException("cannot obtain source audio line", t);
        }
    }
}

